/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.lexer;

import com.streamscape.tools.lexer.Lexer;
import com.streamscape.tools.lexer.LexerContext;
import com.streamscape.tools.lexer.LexerException;
import com.streamscape.tools.lexer.TokenType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LexerFactory {
    private static Map<Class<?>, LexerContext<?>> lexerContextes = new ConcurrentHashMap();

    public static Lexer<DummyTokenType> createLexer(String buffer) throws LexerException {
        return LexerFactory.createLexer(null, buffer);
    }

    public static <T extends TokenType> Lexer<T> createLexer(Class<T> customTokenType) throws LexerException {
        return LexerFactory.createLexer(customTokenType, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TokenType> Lexer<T> createLexer(Class<T> customTokenType, String buffer) throws LexerException {
        LexerContext<Object> lexerContext;
        if (customTokenType == null) {
            customTokenType = DummyTokenType.class;
        }
        if ((lexerContext = lexerContextes.get(customTokenType)) == null) {
            Class<Object> clazz = customTokenType;
            synchronized (clazz) {
                lexerContext = lexerContextes.get(customTokenType);
                if (lexerContext == null) {
                    lexerContext = new LexerContext(customTokenType);
                    lexerContextes.put(customTokenType, lexerContext);
                }
            }
        }
        return new Lexer(lexerContext, buffer);
    }

    public static final class DummyTokenType
    extends Enum<DummyTokenType>
    implements TokenType {
        private static final /* synthetic */ DummyTokenType[] $VALUES;

        public static DummyTokenType[] values() {
            return (DummyTokenType[])$VALUES.clone();
        }

        public static DummyTokenType valueOf(String name) {
            return Enum.valueOf(DummyTokenType.class, name);
        }

        @Override
        public boolean isDelimiter() {
            return false;
        }

        @Override
        public String getValue() {
            return null;
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }

        private static /* synthetic */ DummyTokenType[] $values() {
            return new DummyTokenType[0];
        }

        static {
            $VALUES = DummyTokenType.$values();
        }
    }
}

