/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.lexer;

import com.streamscape.tools.lexer.CommonTokenType;
import com.streamscape.tools.lexer.LexerException;
import com.streamscape.tools.lexer.Token;
import com.streamscape.tools.lexer.TokenType;
import com.streamscape.tools.lexer.TokensTree;
import java.util.HashSet;

class LexerContext<T extends TokenType> {
    private Class<?> customTokenTypeClass;
    private TokensTree<Enum<?>> customLiterals = new TokensTree();
    private TokensTree<Enum<?>> customDelimiters = new TokensTree();

    LexerContext(Class<?> customTokenTypeClass) throws LexerException {
        this.customTokenTypeClass = customTokenTypeClass;
        for (Enum e : (Enum[])customTokenTypeClass.getEnumConstants()) {
            TokenType tokenType = (TokenType)((Object)e);
            if (tokenType.getValue() == null || tokenType.getValue().length() == 0) {
                throw new LexerException("Custom token cannot has null or empty value. Token name " + e.name() + ".");
            }
            if (tokenType.isDelimiter()) {
                this.customDelimiters.put(tokenType.getValue(), e, tokenType.isCaseSensitive());
                continue;
            }
            this.customLiterals.put(tokenType.getValue(), e, tokenType.isCaseSensitive());
        }
        this.validate();
    }

    void validate() {
        HashSet<String> tokens = new HashSet<String>();
        for (CommonTokenType tokenType : CommonTokenType.values()) {
            if (tokenType.getValue() == null || tokenType.getValue().length() <= 0 || tokens.add(tokenType.getValue())) continue;
            throw new RuntimeException("Duplicate common token value " + tokenType.name() + "(" + tokenType.getValue() + ").");
        }
        for (Enum e : (Enum[])this.customTokenTypeClass.getEnumConstants()) {
            TokenType tokenType = (TokenType)((Object)e);
            if (tokenType.getValue() == null || tokenType.getValue().length() <= 0 || tokens.add(tokenType.getValue())) continue;
            throw new RuntimeException("Duplicate custom " + this.customTokenTypeClass.getSimpleName() + " token value " + e.name() + "(" + tokenType.getValue() + ").");
        }
    }

    public Class<?> getCustomTokenType() {
        return this.customTokenTypeClass;
    }

    public boolean isDelimiter(char c) {
        return this.customDelimiters.containsKey(c) || CommonTokenType.delimiters.containsKey(c);
    }

    public boolean isDelimiter(String word) {
        return this.customDelimiters.containsKey(word) || CommonTokenType.delimiters.containsKey(word);
    }

    public boolean isLiteral(String word) {
        return this.customLiterals.containsKey(word) || CommonTokenType.literals.containsKey(word);
    }

    public boolean isDelimiterAtBegin(String buffer, int start, int end) {
        boolean isDelimiter = false;
        String delimiter = null;
        int len = end - start + 1;
        if (len <= this.customDelimiters.getTokenMaxLength()) {
            delimiter = buffer.substring(start, end + 1);
            isDelimiter = this.customDelimiters.containsKey(delimiter);
        }
        if (!isDelimiter && len <= CommonTokenType.delimiters.getTokenMaxLength()) {
            if (delimiter == null) {
                delimiter = buffer.substring(start, end + 1);
            }
            isDelimiter = CommonTokenType.delimiters.containsKey(delimiter);
        }
        return isDelimiter;
    }

    public int isDelimiterAtEnd(String buffer, int start, int end) {
        int delimiterLength = 0;
        for (int i = 0; i < this.getDelimiterMaxLength() && end - i >= start; ++i) {
            Enum tmpTokenType = null;
            String delimiter = buffer.substring(end - i, end + 1);
            tmpTokenType = this.customDelimiters.get(delimiter);
            if (tmpTokenType == null) {
                tmpTokenType = CommonTokenType.delimiters.get(delimiter);
            }
            if (tmpTokenType == null) continue;
            delimiterLength = i + 1;
        }
        return delimiterLength;
    }

    public int getDelimiterMaxLength() {
        return this.customDelimiters.getTokenMaxLength() > CommonTokenType.delimiters.getTokenMaxLength() ? this.customDelimiters.getTokenMaxLength() : CommonTokenType.delimiters.getTokenMaxLength();
    }

    public Token<T> createDelimiter(String delimiter) throws LexerException {
        Enum tokenType = this.customDelimiters.get(delimiter);
        if (tokenType == null) {
            tokenType = CommonTokenType.delimiters.get(delimiter);
        }
        if (tokenType != null) {
            return new Token((TokenType)((Object)tokenType));
        }
        throw new LexerException("Delimiter '" + delimiter + "' doesn't exist.");
    }

    public Token<T> createLiteral(String literal) {
        Enum<?> tokenType = CommonTokenType.literals.get(literal);
        if (tokenType == null) {
            tokenType = this.customLiterals.get(literal);
        }
        if (tokenType != null) {
            return new Token((TokenType)((Object)tokenType), literal);
        }
        return new Token(CommonTokenType.LITERAL, literal);
    }
}

