/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.lexer;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.tools.lexer.BufferUtils;
import com.streamscape.tools.lexer.CommonTokenType;
import com.streamscape.tools.lexer.LexerContext;
import com.streamscape.tools.lexer.LexerException;
import com.streamscape.tools.lexer.Token;
import com.streamscape.tools.lexer.TokenType;
import com.streamscape.tools.lexer.UnexpectedTokenException;
import java.util.regex.Pattern;

public class Lexer<T extends TokenType> {
    private LexerContext<T> lexerContext;
    private String buffer;
    private Token<T> currentToken;
    private int currentTokenPosition;
    private int position;
    private int lineNumber = 1;
    private boolean skipComments = true;
    private static Pattern LONG_NUMBER_PATTERN = Pattern.compile("(0)|([1-9]{1}(\\d+)?)");

    Lexer(LexerContext<T> lexerContext) {
        this(lexerContext, "");
    }

    Lexer(LexerContext<T> lexerContext, String buffer) {
        this.lexerContext = lexerContext;
        this.reset(buffer);
    }

    public void reset(String buffer) {
        this.buffer = buffer;
        this.currentToken = new Token(CommonTokenType.BUFFER_BEGIN);
        this.currentTokenPosition = 0;
        this.position = 0;
        this.lineNumber = 1;
    }

    public Token<T> readToken() throws LexerException {
        this.read();
        return this.currentToken;
    }

    public Token<T> readToken(String token) throws LexerException {
        this.readToken();
        if (this.isCurrentToken(token)) {
            return this.currentToken;
        }
        throw this.unexpectedTokenException(new Token(CommonTokenType.LITERAL, token));
    }

    public Token<T> readToken(TokenType tokenType) throws LexerException {
        if (tokenType instanceof CommonTokenType && (CommonTokenType)tokenType == CommonTokenType.EVENT_ID) {
            this.readEventId();
        } else {
            this.readToken();
        }
        if (this.isCurrentToken(tokenType)) {
            return this.currentToken;
        }
        throw this.unexpectedTokenException(tokenType);
    }

    public Token<T> readCurrentToken(String token) throws LexerException {
        if (!this.isCurrentToken(token)) {
            throw this.unexpectedTokenException(new Token(CommonTokenType.LITERAL, token));
        }
        this.readToken();
        return this.currentToken;
    }

    public Token<T> readCurrentToken(TokenType tokenType) throws LexerException {
        if (!this.isCurrentToken(tokenType)) {
            throw this.unexpectedTokenException(tokenType);
        }
        this.readToken();
        return this.currentToken;
    }

    public boolean readIfCurrentToken(String token) throws LexerException {
        if (this.isCurrentToken(token)) {
            this.readToken();
            return true;
        }
        return false;
    }

    public boolean readIfCurrentToken(TokenType tokenType) throws LexerException {
        if (this.isCurrentToken(tokenType)) {
            this.readToken();
            return true;
        }
        return false;
    }

    public Token<T> getCurrentToken() {
        return this.currentToken;
    }

    public char getLastChar() {
        return this.buffer.charAt(this.buffer.length() - 1);
    }

    public boolean isThereSpaceAfterCurrentToken() {
        if (this.currentToken == null) {
            return false;
        }
        int endTokenPos = this.getCurrentTokenPosition() + this.currentToken.getValue().length();
        if (endTokenPos >= this.buffer.length()) {
            endTokenPos = this.buffer.length() - 1;
        }
        if (endTokenPos >= 0 && endTokenPos < this.buffer.length()) {
            return BufferUtils.isSpace(this.buffer.charAt(endTokenPos));
        }
        return false;
    }

    public boolean isCurrentToken(TokenType tokenType) {
        if (this.currentToken.isCommon() && tokenType instanceof CommonTokenType) {
            return this.currentToken.getCommonType() == (CommonTokenType)tokenType;
        }
        if (this.currentToken.isCustom() && tokenType.getClass().equals(this.lexerContext.getCustomTokenType())) {
            return this.currentToken.getCustomType() == tokenType;
        }
        return false;
    }

    public boolean isCurrentToken(String token) {
        return this.currentToken.isCommon() ? this.currentToken.getCommonType() != CommonTokenType.STRING_LITERAL && this.currentToken.getValue().equalsIgnoreCase(token) : this.currentToken.getValue().equalsIgnoreCase(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNextToken(TokenType tokenType) throws LexerException {
        int position = this.getCurrentTokenPosition();
        try {
            this.readToken();
            boolean bl = this.isCurrentToken(tokenType);
            return bl;
        }
        finally {
            this.rewind(position);
            this.readToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNextToken(String token) throws LexerException {
        int position = this.getCurrentTokenPosition();
        try {
            this.readToken();
            boolean bl = this.isCurrentToken(token);
            return bl;
        }
        finally {
            this.rewind(position);
            this.readToken();
        }
    }

    public boolean isBufferEnd() {
        return this.isCurrentToken(CommonTokenType.BUFFER_END);
    }

    public int getCurrentPosition() {
        return this.position;
    }

    public int getCurrentTokenPosition() {
        return this.currentTokenPosition;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getLineNumber(int position) {
        return BufferUtils.getLineNumber(this.buffer, position);
    }

    public String getPartBeforeCurrentToken(int partLength) {
        return BufferUtils.getPartBefore(this.buffer, this.currentTokenPosition, partLength);
    }

    public String getCurrentLine() {
        return this.getLine(this.currentTokenPosition);
    }

    public int getLineBeginPosition(int position) {
        return BufferUtils.getLineBeginPosition(this.buffer, position);
    }

    public int getPositionInLine(int position) {
        return BufferUtils.getPositionInLine(this.buffer, position);
    }

    public String getLine(int position) {
        return BufferUtils.getLine(this.buffer, position);
    }

    public String substring(int beginPosition, int endPosition) {
        return this.buffer.substring(beginPosition, endPosition);
    }

    public int getLength() {
        return this.buffer.length();
    }

    public void rewind(int toPosition) {
        this.position = toPosition;
        this.currentTokenPosition = toPosition;
        this.currentToken = new Token(CommonTokenType.UNREAD_TOKEN);
    }

    public boolean isAtBegin() {
        return this.position == 0;
    }

    public boolean isAtEnd() throws LexerException {
        this.skipSpaces();
        this.skipComments();
        return this.position == this.buffer.length();
    }

    public boolean isReservedWord(String word) {
        return this.lexerContext.isLiteral(word) || this.lexerContext.isDelimiter(word);
    }

    public void setSkipComments(boolean skipComments) {
        this.skipComments = skipComments;
    }

    public boolean isSkipComments() {
        return this.skipComments;
    }

    public char charAt(int index) {
        return this.buffer.charAt(index);
    }

    private void readEventId() throws LexerException {
        char c;
        this.skipSpaces();
        this.skipComments();
        this.currentTokenPosition = this.position;
        if (this.position == this.buffer.length()) {
            this.currentToken = new Token(CommonTokenType.BUFFER_END);
            return;
        }
        while (this.position < this.buffer.length() && !BufferUtils.isSpace(c = this.buffer.charAt(this.position)) && c != ']') {
            ++this.position;
        }
        String eventId = this.buffer.substring(this.currentTokenPosition, this.position);
        this.currentToken = StringUtils.validateEventId(eventId) ? new Token(CommonTokenType.EVENT_ID, eventId) : new Token(CommonTokenType.LITERAL, eventId);
    }

    public UnexpectedTokenException unexpectedTokenException(TokenType expectedTokenType) {
        return new UnexpectedTokenException(this.currentToken, new Token(expectedTokenType), this.buffer.substring(0, this.currentTokenPosition));
    }

    private UnexpectedTokenException unexpectedTokenException(Token<?> expectedTokenType) {
        return new UnexpectedTokenException(this.currentToken, expectedTokenType, this.buffer.substring(0, this.currentTokenPosition));
    }

    private void read() throws LexerException {
        this.skipSpaces();
        this.skipComments();
        this.currentTokenPosition = this.position;
        if (this.position == this.buffer.length()) {
            this.currentToken = new Token(CommonTokenType.BUFFER_END);
            return;
        }
        boolean doubleValue = false;
        while (this.position < this.buffer.length()) {
            char c = this.buffer.charAt(this.position);
            if (this.position == this.currentTokenPosition) {
                if (this.readComment()) {
                    return;
                }
                if (c == '\'' || c == '\"') {
                    this.readStringLiteral(c);
                    return;
                }
                if (this.lexerContext.isDelimiter(c)) {
                    this.readDelimiter();
                    return;
                }
            } else {
                if (this.lexerContext.isDelimiterAtBegin(this.buffer, this.currentTokenPosition, this.position)) {
                    this.readDelimiter();
                    return;
                }
                if (BufferUtils.isSpace(c)) {
                    if (BufferUtils.isNewLine(c)) {
                        ++this.lineNumber;
                    }
                    this.currentToken = this.lexerContext.createLiteral(this.buffer.substring(this.currentTokenPosition, this.position));
                    return;
                }
                int len = this.lexerContext.isDelimiterAtEnd(this.buffer, this.currentTokenPosition, this.position);
                if (len > 0) {
                    boolean shouldReturn = true;
                    if (len == 1 && this.buffer.charAt(this.position) == '.' && !doubleValue && LONG_NUMBER_PATTERN.matcher(this.buffer.substring(this.currentTokenPosition, this.position - len + 1)).matches()) {
                        doubleValue = true;
                        shouldReturn = false;
                    }
                    if (len == 1 && doubleValue && (this.buffer.charAt(this.position) == '-' || this.buffer.charAt(this.position) == '+') && this.position > 1 && Character.toLowerCase(this.buffer.charAt(this.position - 1)) == 'e') {
                        shouldReturn = false;
                    }
                    if (shouldReturn) {
                        this.currentToken = this.lexerContext.createLiteral(this.buffer.substring(this.currentTokenPosition, this.position - len + 1));
                        this.position -= len - 1;
                        return;
                    }
                }
            }
            ++this.position;
        }
        this.currentToken = this.lexerContext.createLiteral(this.buffer.substring(this.currentTokenPosition, this.position));
    }

    private void readStringLiteral(char closeCharacter) throws LexerException {
        ++this.position;
        char c = '\u0000';
        int startPosition = this.position;
        StringBuilder builder = new StringBuilder();
        while (this.position < this.buffer.length()) {
            if ((c = this.buffer.charAt(this.position++)) == '\\') {
                if (this.position < this.buffer.length()) {
                    if (this.buffer.charAt(this.position) == closeCharacter || this.buffer.charAt(this.position) == '\\') {
                        builder.append(this.buffer.charAt(this.position));
                        ++this.position;
                        continue;
                    }
                    if (this.buffer.charAt(this.position) == 'n') {
                        builder.append("\n");
                        ++this.position;
                        continue;
                    }
                    if (this.buffer.charAt(this.position) == 't') {
                        builder.append("\t");
                        ++this.position;
                        continue;
                    }
                    if (this.buffer.charAt(this.position) == 'r') {
                        builder.append("\r");
                        ++this.position;
                        continue;
                    }
                }
            } else if (c == closeCharacter) {
                if (this.position >= this.buffer.length() || this.buffer.charAt(this.position) != closeCharacter) break;
                builder.append(this.buffer.charAt(this.position));
                ++this.position;
                continue;
            }
            builder.append(c);
        }
        if (c != closeCharacter) {
            throw new LexerException("Missing close character '" + closeCharacter + "', after " + this.buffer.substring(startPosition - 1));
        }
        this.currentToken = new Token(CommonTokenType.STRING_LITERAL, builder.toString());
    }

    private void readDelimiter() throws LexerException {
        int lastDelimiterPosition = 0;
        for (int i = 1; i < this.lexerContext.getDelimiterMaxLength() && this.position + i < this.buffer.length(); ++i) {
            if (!this.lexerContext.isDelimiterAtBegin(this.buffer, this.currentTokenPosition, this.position + i)) continue;
            lastDelimiterPosition = i;
        }
        this.currentToken = this.lexerContext.createDelimiter(this.buffer.substring(this.currentTokenPosition, this.position + lastDelimiterPosition + 1));
        this.position += lastDelimiterPosition + 1;
    }

    public void skipSpaces() {
        while (this.position < this.buffer.length() && BufferUtils.isSpace(this.buffer.charAt(this.position))) {
            if (BufferUtils.isNewLine(this.buffer.charAt(this.position))) {
                ++this.lineNumber;
            }
            ++this.position;
        }
    }

    public void skipSpacesTillNewLine() {
        while (this.position < this.buffer.length() && BufferUtils.isSpace(this.buffer.charAt(this.position))) {
            if (BufferUtils.isNewLine(this.buffer.charAt(this.position))) {
                return;
            }
            ++this.position;
        }
    }

    private boolean readComment() {
        if (this.skipComments) {
            return false;
        }
        char c = this.buffer.charAt(this.position);
        if (c == '/' && this.position + 1 < this.buffer.length()) {
            char c1 = this.buffer.charAt(this.position + 1);
            if (c1 == '/') {
                int newLineIndex = this.buffer.indexOf(10, this.position + 1);
                if (newLineIndex == -1) {
                    newLineIndex = this.buffer.length();
                }
                this.currentToken = new Token(CommonTokenType.ONE_LINE_COMMENT, this.buffer.substring(this.position, newLineIndex));
                this.position = newLineIndex;
            } else if (c1 == '*') {
                int endCommentIndex = this.buffer.indexOf("*/", this.position + 1);
                if (endCommentIndex == -1) {
                    return false;
                }
                if (this.position + 2 < this.buffer.length() && this.buffer.charAt(this.position + 2) == '*') {
                    this.currentToken = new Token(CommonTokenType.JAVADOC_COMMENT, this.buffer.substring(this.position, endCommentIndex + 2));
                    this.position = endCommentIndex + 2;
                } else {
                    this.currentToken = new Token(CommonTokenType.MULTI_LINE_COMMENT, this.buffer.substring(this.position, endCommentIndex + 2));
                    this.position = endCommentIndex + 2;
                }
            } else {
                return false;
            }
            if (this.position > this.buffer.length()) {
                this.position = this.buffer.length();
            }
            return true;
        }
        return false;
    }

    private void skipComments() throws LexerException {
        if (!this.skipComments) {
            return;
        }
        int oldPosition = this.position;
        this.position = BufferUtils.skipSpacesAndCommends(this.buffer, this.position);
        while (oldPosition < this.position && oldPosition < this.buffer.length()) {
            if (!BufferUtils.isNewLine(this.buffer.charAt(oldPosition++))) continue;
            ++this.lineNumber;
        }
        if (this.position < this.buffer.length() - 1 && this.buffer.substring(this.position, this.position + 2).equals("/*")) {
            throw new LexerException("Mutiline comment without end.");
        }
    }
}

