/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.lexer;

import com.drew.lang.Charsets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public class FileUtils {
    public static FileCharactersInfo getFileCharactersInfo(File file, Charset charset) throws IOException {
        return FileUtils.getFileCharactersInfo(file, charset, 0);
    }

    public static FileCharactersInfo getFileCharactersInfo(File file, Charset charset, int lineCountToAnalyze) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            FileCharactersInfo info = FileUtils.getFileCharactersInfo(inputStream, charset, lineCountToAnalyze, file.length());
            info.setBytesCount(file.length());
            FileCharactersInfo fileCharactersInfo = info;
            return fileCharactersInfo;
        }
    }

    public static FileCharactersInfo getFileCharactersInfo(InputStream inputStream, Charset charset) throws IOException {
        return FileUtils.getFileCharactersInfo(inputStream, charset, 0L, 0L);
    }

    public static FileCharactersInfo getFileCharactersInfo(InputStream inputStream, Charset charset, long lineCountToAnalyze, long fileSizeBytes) throws IOException {
        if (charset == null) {
            charset = Charsets.UTF_8;
        }
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new BufferedInputStream(inputStream), charset);){
            FileCharactersInfo fileCharactersInfo = FileUtils.getFileCharactersInfo(inputStreamReader, lineCountToAnalyze, fileSizeBytes);
            return fileCharactersInfo;
        }
    }

    public static FileCharactersInfo getFileCharactersInfo(InputStreamReader inputStreamReader) throws IOException {
        return FileUtils.getFileCharactersInfo(inputStreamReader, 0L, 0L);
    }

    public static FileCharactersInfo getFileCharactersInfo(InputStreamReader inputStreamReader, long lineCountToAnalyze, long fileSizeCharacters) throws IOException {
        FileCharactersInfo info = new FileCharactersInfo();
        char[] chars = new char[0x400000];
        if (lineCountToAnalyze == 0L) {
            int read = 0;
            while ((read = inputStreamReader.read(chars, 0, chars.length)) > 0) {
                for (int i = 0; i < read; ++i) {
                    ++info.charactersCount;
                    if (chars[i] != '\n') continue;
                    ++info.linesCount;
                }
            }
            if (info.linesCount > 0L) {
                info.setOneLineLengthCharacters((int)(info.charactersCount / info.linesCount));
            }
            info.setApproximate(false);
        } else {
            int read = 0;
            long charactersRead = 0L;
            long linesRead = 0L;
            block2: while (linesRead < lineCountToAnalyze && (read = inputStreamReader.read(chars, 0, chars.length)) > 0) {
                for (int i = 0; i < read; ++i) {
                    ++charactersRead;
                    if (chars[i] == '\n' && ++linesRead == lineCountToAnalyze) continue block2;
                }
            }
            if (read == 0 || linesRead == 0L) {
                info.setLinesCount(linesRead);
                info.setCharactersCount(charactersRead);
                if (linesRead > 0L) {
                    info.setOneLineLengthCharacters(charactersRead / linesRead);
                }
                info.setApproximate(false);
            } else {
                info.setOneLineLengthCharacters(charactersRead / linesRead);
                info.setLinesCount(fileSizeCharacters / info.getOneLineLengthCharacters());
                info.setCharactersCount(fileSizeCharacters);
                info.setApproximate(true);
            }
        }
        return info;
    }

    public static void extractFilePart(File sourceFile, File targetFile, long startLine, long endLine, Charset charset) throws IOException {
        if (startLine >= 0L && endLine >= 0L && startLine < endLine) {
            throw new IOException("Start line is less that end line.");
        }
        if (startLine < 0L && endLine < 0L && startLine > endLine) {
            throw new IOException("Start line is less that end line.");
        }
        if (startLine < 0L || endLine < 0L) {
            FileCharactersInfo fileInfo = FileUtils.getFileCharactersInfo(sourceFile, charset);
            if (Math.abs(startLine) > fileInfo.linesCount) {
                throw new IOException("Start line is out of range. Start line: " + startLine + ", total lines count: " + fileInfo.linesCount);
            }
            if (Math.abs(endLine) > fileInfo.linesCount) {
                throw new IOException("End line is out of range. End line: " + startLine + ", total lines count: " + fileInfo.linesCount);
            }
            if (startLine < 0L) {
                startLine = fileInfo.linesCount + startLine;
            }
            if (endLine < 0L) {
                endLine = fileInfo.linesCount + endLine;
            }
        }
        try (FileInputStream inputStream = new FileInputStream(sourceFile);
             FileOutputStream outputStream = new FileOutputStream(targetFile);){
            FileUtils.extractFilePart(inputStream, outputStream, startLine, endLine, charset);
        }
    }

    public static void extractFilePart(InputStream inputStream, OutputStream outputStream, long startLine, long endLine, Charset charset) throws IOException {
        if (startLine < 0L) {
            throw new IOException("Negative start line is not supported when input stream is provided.");
        }
        if (endLine < 0L) {
            throw new IOException("Negative end line is not supported when input stream is provided.");
        }
        if (charset == null) {
            charset = Charsets.UTF_8;
        }
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new BufferedInputStream(inputStream), charset);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream), charset);){
            FileUtils.extractFilePart(inputStreamReader, outputStreamWriter, startLine, endLine);
        }
    }

    public static void extractFilePart(InputStreamReader inputStreamReader, OutputStreamWriter outputStreamWriter, long startLine, long endLine) throws IOException {
        if (startLine < 0L) {
            throw new IOException("Negative start line is not supported when input stream reader is provided.");
        }
        if (endLine < 0L) {
            throw new IOException("Negative end line is not supported when input stream reader is provided.");
        }
        if (startLine == 0L) {
            startLine = 1L;
        }
        char[] chars = new char[0x400000];
        int read = 0;
        int currentLineNumber = 1;
        while ((endLine == 0L || (long)currentLineNumber <= endLine) && (read = inputStreamReader.read(chars, 0, chars.length)) > 0) {
            for (int i = 0; i < read; ++i) {
                if ((long)currentLineNumber >= startLine && (endLine == 0L || (long)currentLineNumber <= endLine)) {
                    outputStreamWriter.write(chars[i]);
                }
                if (chars[i] != '\n') continue;
                ++currentLineNumber;
            }
        }
    }

    public static long[] getLinesOffset(File file, int startLine, int endLine, Charset charset) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            long[] lArray = FileUtils.getLinesOffset(inputStream, startLine, endLine, charset);
            return lArray;
        }
    }

    public static long[] getLinesOffset(InputStream inputStream, int startLine, int endLine, Charset charset) throws IOException {
        if (charset == null) {
            charset = Charsets.UTF_8;
        }
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new BufferedInputStream(inputStream), charset);){
            long[] lArray = FileUtils.getLinesOffset(inputStreamReader, startLine, endLine);
            return lArray;
        }
    }

    public static long[] getLinesOffset(InputStreamReader inputStreamReader, int startLine, int endLine) throws IOException {
        char[] chars = new char[0x400000];
        int read = 0;
        int currentLineNumber = 1;
        long currentOffset = 0L;
        long currentLineOffset = 0L;
        long startOffset = -1L;
        long endOffset = -1L;
        block0: while (endOffset == -1L && (read = inputStreamReader.read(chars, 0, chars.length)) > 0) {
            for (int i = 0; i < read; ++i) {
                if (currentLineNumber == startLine) {
                    startOffset = currentLineOffset;
                }
                if (chars[i] == '\n') {
                    currentLineOffset = currentOffset + 1L;
                    if (++currentLineNumber - 1 == endLine) {
                        endOffset = currentOffset;
                        continue block0;
                    }
                }
                ++currentOffset;
            }
        }
        if (startOffset == -1L) {
            throw new IOException("There is no line with specified startLine(" + startLine + ") index in the file.");
        }
        if (endOffset == -1L) {
            endOffset = currentOffset;
        }
        return new long[]{startOffset, endOffset};
    }

    public static SlicesInfo sliceFile(File sourceFile, Charset charset, NextSliceOutputStreamProvider nextSliceOutputStreamProvider, boolean preserveFirstLine, int numberOfSlices, int slicesToWrite) throws IOException {
        long sourceFileLength = sourceFile.length();
        try (FileInputStream inputStream = new FileInputStream(sourceFile);){
            SlicesInfo slicesInfo = FileUtils.sliceFile(inputStream, sourceFileLength, charset, nextSliceOutputStreamProvider, preserveFirstLine, numberOfSlices, slicesToWrite);
            return slicesInfo;
        }
    }

    public static SlicesInfo sliceFile(InputStream inputStream, long sourceFileLength, Charset charset, NextSliceOutputStreamProvider nextSliceOutputStreamProvider, boolean preserveFirstLine, int numberOfSlices, int slicesToWrite) throws IOException {
        if (charset == null) {
            charset = Charsets.UTF_8;
        }
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new BufferedInputStream(inputStream), charset);){
            SlicesInfo slicesInfo = FileUtils.sliceFile(inputStreamReader, sourceFileLength, nextSliceOutputStreamProvider, preserveFirstLine, numberOfSlices, slicesToWrite);
            return slicesInfo;
        }
    }

    public static SlicesInfo sliceFile(InputStreamReader inputStreamReader, long sourceFileLength, NextSliceOutputStreamProvider nextSliceOutputStreamProvider, boolean preserveFirstLine, int numberOfSlices, int slicesToWrite) throws IOException {
        if (slicesToWrite < -1) {
            throw new IllegalArgumentException("slicesToWrite should be greater than 0");
        }
        if (numberOfSlices <= 0) {
            throw new IllegalArgumentException("numberOfSlices should be greater than 0");
        }
        String firstLine = "";
        char[] chars = new char[0x400000];
        int read = 0;
        int totalLinesCount = 0;
        if (preserveFirstLine) {
            int newLineIndex;
            read = inputStreamReader.read(chars, 0, chars.length);
            if (read <= 0) {
                throw new IOException("Source file is empty.");
            }
            for (newLineIndex = 0; newLineIndex < read && chars[newLineIndex] != '\n'; ++newLineIndex) {
            }
            if (newLineIndex >= read) {
                throw new IOException("There is no new line in the first " + chars.length + " characters of the file.");
            }
            firstLine = new String(chars, 0, newLineIndex + 1);
            ++totalLinesCount;
        }
        int approximateSliceSizeCharacters = (int)((sourceFileLength - (long)firstLine.length()) / (long)numberOfSlices);
        int offset = firstLine.length();
        int sliceCounter = 0;
        int currentFileLinesCounter = 0;
        int currentFileCharactersCounter = 0;
        int currentLineStartPosition = offset;
        int linesPerSlice = 0;
        OutputStreamWriter currentFileOutputStreamWriter = null;
        read -= offset;
        while (!(slicesToWrite > 0 && sliceCounter > slicesToWrite || offset >= read && (read = inputStreamReader.read(chars, offset, chars.length - offset)) <= 0)) {
            for (int i = offset; i < read + offset; ++i) {
                if (chars[i] != '\n') continue;
                ++totalLinesCount;
                int currentLineLength = i - currentLineStartPosition + 1;
                if (linesPerSlice == 0) {
                    if (currentFileCharactersCounter + currentLineLength < approximateSliceSizeCharacters || currentFileLinesCounter == 0) {
                        if (currentFileOutputStreamWriter == null) {
                            currentFileOutputStreamWriter = FileUtils.openNewFile(nextSliceOutputStreamProvider, currentFileOutputStreamWriter, ++sliceCounter, numberOfSlices);
                            currentFileOutputStreamWriter.write(firstLine);
                        }
                        currentFileOutputStreamWriter.write(chars, currentLineStartPosition, currentLineLength);
                        ++currentFileLinesCounter;
                        currentLineStartPosition += currentLineLength;
                        if ((currentFileCharactersCounter += currentLineLength) < approximateSliceSizeCharacters || sliceCounter != slicesToWrite) continue;
                        break;
                    }
                    if (slicesToWrite > 0 && ++sliceCounter > slicesToWrite) break;
                    currentFileOutputStreamWriter = FileUtils.openNewFile(nextSliceOutputStreamProvider, currentFileOutputStreamWriter, sliceCounter, numberOfSlices);
                    currentFileOutputStreamWriter.write(firstLine);
                    currentFileOutputStreamWriter.write(chars, currentLineStartPosition, currentLineLength);
                    linesPerSlice = currentFileLinesCounter;
                    currentFileCharactersCounter = currentLineLength;
                    currentFileLinesCounter = 1;
                    currentLineStartPosition += currentLineLength;
                    continue;
                }
                if (currentFileLinesCounter < linesPerSlice || sliceCounter == numberOfSlices) {
                    currentFileOutputStreamWriter.write(chars, currentLineStartPosition, currentLineLength);
                    currentFileCharactersCounter += currentLineLength;
                    currentLineStartPosition += currentLineLength;
                    if (++currentFileLinesCounter != linesPerSlice || sliceCounter != slicesToWrite) continue;
                    break;
                }
                if (slicesToWrite > 0 && ++sliceCounter > slicesToWrite) break;
                currentFileOutputStreamWriter = FileUtils.openNewFile(nextSliceOutputStreamProvider, currentFileOutputStreamWriter, sliceCounter, numberOfSlices);
                currentFileOutputStreamWriter.write(firstLine);
                currentFileOutputStreamWriter.write(chars, currentLineStartPosition, currentLineLength);
                currentFileCharactersCounter = currentLineLength;
                currentFileLinesCounter = 1;
                currentLineStartPosition += currentLineLength;
            }
            if (currentLineStartPosition < read + offset) {
                System.arraycopy(chars, currentLineStartPosition, chars, 0, read + offset - currentLineStartPosition);
                read = offset = read + offset - currentLineStartPosition;
                currentLineStartPosition = 0;
                continue;
            }
            offset = 0;
            read = 0;
            currentLineStartPosition = 0;
        }
        if (currentFileOutputStreamWriter != null) {
            currentFileOutputStreamWriter.close();
        }
        SlicesInfo slicesInfo = new SlicesInfo();
        slicesInfo.sliceCount = sliceCounter;
        slicesInfo.linesPerSlice = linesPerSlice;
        slicesInfo.totalLineCount = totalLinesCount;
        return slicesInfo;
    }

    private static OutputStreamWriter openNewFile(NextSliceOutputStreamProvider nextSliceOutputStreamProvider, OutputStreamWriter currentFileOutputStreamWriter, int sliceCounter, int maxSliceCount) throws IOException {
        if (currentFileOutputStreamWriter != null) {
            currentFileOutputStreamWriter.close();
        }
        return nextSliceOutputStreamProvider.createNextSliceOutputStreamWriter(sliceCounter, maxSliceCount);
    }

    public static void main(String[] args) throws IOException {
        final File sourceFile = new File("/Users/nkutuzov/Streamscape/git/NeeveBuild/testfile.txt");
        NextSliceOutputStreamProvider provider = new NextSliceOutputStreamProvider(){

            @Override
            public String createSliceName(int index, int maxIndex) throws IOException {
                String directory = sourceFile.getParent();
                String filename = sourceFile.getName();
                String extension = "";
                int dotPos = filename.lastIndexOf(".");
                if (dotPos > 0) {
                    extension = filename.substring(dotPos);
                    filename = filename.substring(0, dotPos);
                }
                int zeroCount = (int)Math.log10(maxIndex) + 1;
                return directory + "/" + filename + "_" + String.format("%0" + zeroCount + "d", index) + extension;
            }

            @Override
            public OutputStream createNextSliceOutputStream(int index, int maxIndex) {
                return null;
            }

            @Override
            public OutputStreamWriter createNextSliceOutputStreamWriter(int index, int maxIndex) throws IOException {
                return new OutputStreamWriter(new FileOutputStream(new File(this.createSliceName(index, maxIndex))));
            }
        };
        FileUtils.sliceFile(sourceFile, null, provider, true, 3, 0);
    }

    public static class FileCharactersInfo {
        private long charactersCount;
        private long linesCount;
        private long oneLineLengthCharacters;
        private long bytesCount;
        private boolean approximate;

        public long getCharactersCount() {
            return this.charactersCount;
        }

        public FileCharactersInfo setCharactersCount(long charactersCount) {
            this.charactersCount = charactersCount;
            return this;
        }

        public long getLinesCount() {
            return this.linesCount;
        }

        public FileCharactersInfo setLinesCount(long linesCount) {
            this.linesCount = linesCount;
            return this;
        }

        public long getBytesCount() {
            return this.bytesCount;
        }

        public FileCharactersInfo setBytesCount(long bytesCount) {
            this.bytesCount = bytesCount;
            return this;
        }

        public long getOneLineLengthCharacters() {
            return this.oneLineLengthCharacters;
        }

        public FileCharactersInfo setOneLineLengthCharacters(long oneLineLengthCharacters) {
            this.oneLineLengthCharacters = oneLineLengthCharacters;
            return this;
        }

        public boolean isApproximate() {
            return this.approximate;
        }

        public FileCharactersInfo setApproximate(boolean approximate) {
            this.approximate = approximate;
            return this;
        }
    }

    public static interface NextSliceOutputStreamProvider {
        public String createSliceName(int var1, int var2) throws IOException;

        public OutputStream createNextSliceOutputStream(int var1, int var2);

        public OutputStreamWriter createNextSliceOutputStreamWriter(int var1, int var2) throws IOException;
    }

    public static class SlicesInfo {
        private int sliceCount;
        private int linesPerSlice;
        private int totalLineCount;

        public int getSliceCount() {
            return this.sliceCount;
        }

        public SlicesInfo setSliceCount(int sliceCount) {
            this.sliceCount = sliceCount;
            return this;
        }

        public int getLinesPerSlice() {
            return this.linesPerSlice;
        }

        public SlicesInfo setLinesPerSlice(int linesPerSlice) {
            this.linesPerSlice = linesPerSlice;
            return this;
        }

        public int getTotalLineCount() {
            return this.totalLineCount;
        }

        public SlicesInfo setTotalLineCount(int totalLineCount) {
            this.totalLineCount = totalLineCount;
            return this;
        }
    }
}

