/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.lexer;

import com.streamscape.tools.lexer.TokenType;
import com.streamscape.tools.lexer.TokensTree;

public enum CommonTokenType implements TokenType
{
    LITERAL,
    STRING_LITERAL,
    NUMBER,
    BUFFER_BEGIN,
    BUFFER_END,
    UNREAD_TOKEN,
    EVENT_ID,
    ONE_LINE_COMMENT,
    MULTI_LINE_COMMENT,
    JAVADOC_COMMENT,
    ASSIGNMENT_OPERAND("=", true),
    NOT_OPERAND("!", true),
    GREATER_THAN(">", true),
    GREATER_THAN_OR_EQUALS(">=", true),
    LESS_THAN("<", true),
    LESS_THAN_OR_EQUALS("<=", true),
    EQUALS("==", true),
    NOT_EQUALS("!=", true),
    OPEN_BRACKET("(", true),
    CLOSE_BRACKET(")", true),
    OPEN_CURLY_BRACKET("{", true),
    CLOSE_CURLY_BRACKET("}", true),
    OPEN_SQUARE_BRACKET("[", true),
    CLOSE_SQUARE_BRACKET("]", true),
    PLUS_ASSIGN("+=", true),
    MINUS_ASSIGN("-=", true),
    ASTERISK_ASSIGN("*=", true),
    DIVIDE_ASSIGN("/=", true),
    PLUS("+", true),
    MINUS("-", true),
    ASTERISK("*", true),
    DIVIDE("/", true),
    CIRCUMFLEX("^", true),
    COMMA(",", true),
    DOT(".", true),
    SEMICOLON(";", true),
    COLON(":", true),
    DOG("@", true),
    SHARP("#", true),
    PERCENT("%", true),
    QUESTION("?", true),
    AND("&", true),
    DOUBLE_AND("&&", true),
    OR("|", true),
    DOUBLE_OR("||", true),
    DOUBLE_PLUS("++", true),
    DOUBLE_MINUS("--", true);

    private String value;
    private boolean isDelimiter = false;
    private boolean isCaseSensitive = true;
    static TokensTree<CommonTokenType> literals;
    static TokensTree<CommonTokenType> delimiters;

    private CommonTokenType() {
        this("");
    }

    private CommonTokenType(String value) {
        this(value, false);
    }

    private CommonTokenType(String value, boolean isDelimiter) {
        this(value, isDelimiter, true);
    }

    private CommonTokenType(String value, boolean isDelimiter, boolean isCaseSensitive) {
        this.value = value;
        this.isDelimiter = isDelimiter;
        this.isCaseSensitive = isCaseSensitive;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isDelimiter() {
        return this.isDelimiter;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    static {
        literals = new TokensTree();
        delimiters = new TokensTree();
        for (CommonTokenType type : CommonTokenType.values()) {
            if (type.getValue() == null || type.getValue().length() <= 0) continue;
            if (type.isDelimiter()) {
                delimiters.put(type.getValue(), type, type.isCaseSensitive());
                continue;
            }
            literals.put(type.getValue(), type, type.isCaseSensitive());
        }
    }
}

