/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.lexer;

import com.streamscape.Trace;
import com.streamscape.lib.utils.JVM;
import com.streamscape.runtime.mf.operation.edl.javadoc.JavaDoc;
import com.streamscape.tools.lexer.CommonTokenType;
import com.streamscape.tools.lexer.Lexer;
import com.streamscape.tools.lexer.LexerException;
import com.streamscape.tools.lexer.LexerFactory;
import com.streamscape.tools.lexer.Token;
import com.streamscape.tools.parser.ParserPositionalException;
import java.util.ArrayList;
import java.util.List;

public class BufferUtils {
    private static final char[] escapedCharMap;

    public static String getPartBefore(String buffer, int beginPosition, int partLength) {
        int newLineBeginIndex = buffer.lastIndexOf(10, beginPosition);
        newLineBeginIndex = newLineBeginIndex == -1 ? 0 : ++newLineBeginIndex;
        if (partLength > beginPosition) {
            return buffer.substring(newLineBeginIndex, beginPosition);
        }
        return buffer.substring(beginPosition - partLength > newLineBeginIndex ? beginPosition - partLength : newLineBeginIndex, beginPosition);
    }

    public static int getLineNumber(String buffer, int position) {
        int number = 1;
        if (position >= buffer.length()) {
            position = buffer.length();
        }
        while (position > 0) {
            if ((position = buffer.lastIndexOf(10, position - 1)) < 0) continue;
            ++number;
        }
        return number;
    }

    public static int getLineBeginPosition(String buffer, int position) {
        int index = buffer.lastIndexOf(10, position);
        if (index == -1) {
            return 0;
        }
        return index + 1;
    }

    public static int getAbsolutePosition(String buffer, int lineNumber, int positionInLine) {
        int position;
        if (positionInLine < 0) {
            positionInLine = 0;
        }
        for (position = 0; lineNumber > 1 && position < buffer.length() && (position = buffer.indexOf(10, position)) != -1; --lineNumber, ++position) {
        }
        if (position == -1) {
            return buffer.length() + positionInLine;
        }
        return position + positionInLine;
    }

    public static int getPositionInLine(String buffer, int position) {
        int i = 0;
        int positionInLine = -1;
        boolean wasNewLine = false;
        while (i <= position && i < buffer.length()) {
            if (wasNewLine) {
                positionInLine = -1;
                wasNewLine = false;
            }
            ++positionInLine;
            if (buffer.charAt(i++) != '\n') continue;
            wasNewLine = true;
        }
        if (wasNewLine) {
            positionInLine = 0;
        }
        return positionInLine;
    }

    public static String getLine(String buffer, int position) {
        int newLineBeginIndex = buffer.lastIndexOf(10, position - 1);
        int newLineEndIndex = buffer.indexOf(10, position);
        newLineBeginIndex = newLineBeginIndex == -1 ? 0 : ++newLineBeginIndex;
        if (newLineEndIndex == -1) {
            newLineEndIndex = buffer.length();
        }
        if (newLineBeginIndex < newLineEndIndex) {
            return buffer.substring(newLineBeginIndex, newLineEndIndex);
        }
        return "";
    }

    public static String getLineByLineNumber(String buffer, int lineNumber) {
        if (buffer.length() == 0) {
            if (lineNumber == 1) {
                return "";
            }
            return null;
        }
        int position = -1;
        while (lineNumber > 0 && ++position < buffer.length() && (position = buffer.indexOf(10, position)) != -1) {
            --lineNumber;
        }
        if (position == -1) {
            if (lineNumber == 1) {
                return BufferUtils.getLine(buffer, buffer.length());
            }
            return null;
        }
        return BufferUtils.getLine(buffer, position);
    }

    public static void setLineAndPositions(ParserPositionalException exception, String buffer, int position) {
        exception.setLineNumber(BufferUtils.getLineNumber(buffer, position));
        exception.setPositionInLine(BufferUtils.getPositionInLine(buffer, position) + 1);
        exception.setLine(BufferUtils.getLine(buffer, position));
    }

    public static String extractUnwrappedJavaDoc(String buffer) {
        if (buffer == null) {
            return null;
        }
        return JavaDoc.Builder.extractJavaDoc(buffer).getJavaDoc();
    }

    public static List<String> extractJavaDoc(String buffer) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Token<LexerFactory.DummyTokenType> token;
            Lexer<LexerFactory.DummyTokenType> lexer = LexerFactory.createLexer(buffer);
            lexer.setSkipComments(false);
            while ((token = lexer.readToken()) != null && token.getCommonType() != CommonTokenType.BUFFER_END) {
                if (token.getCommonType() != CommonTokenType.JAVADOC_COMMENT) continue;
                result.add(token.getValue());
            }
        }
        catch (LexerException exception) {
            Trace.logError(BufferUtils.class, exception.getMessage());
        }
        return result;
    }

    public static String removeJavaDoc(String buffer) {
        return BufferUtils.removeComments(buffer, true, true);
    }

    public static String removeMultilineComments(String buffer) {
        return BufferUtils.removeComments(buffer, false, true);
    }

    public static String removeComments(String buffer) {
        return BufferUtils.removeComments(buffer, false, false);
    }

    private static String removeComments(String buffer, boolean javaDocOnly, boolean multilineOnly) {
        StringBuilder result = null;
        try {
            Token<LexerFactory.DummyTokenType> token;
            Lexer<LexerFactory.DummyTokenType> lexer = LexerFactory.createLexer(buffer);
            lexer.setSkipComments(false);
            int lastPosition = 0;
            while ((token = lexer.readToken()) != null && token.getCommonType() != CommonTokenType.BUFFER_END) {
                int position;
                boolean needToRemove;
                boolean bl = needToRemove = token.getCommonType() == CommonTokenType.JAVADOC_COMMENT || token.getCommonType() == CommonTokenType.ONE_LINE_COMMENT || token.getCommonType() == CommonTokenType.MULTI_LINE_COMMENT;
                if (javaDocOnly && token.getCommonType() != CommonTokenType.JAVADOC_COMMENT) {
                    needToRemove = false;
                }
                if (multilineOnly && token.getCommonType() == CommonTokenType.ONE_LINE_COMMENT) {
                    needToRemove = false;
                }
                if (!needToRemove) continue;
                if (result == null) {
                    result = new StringBuilder();
                }
                if (lastPosition < (position = BufferUtils.getLastNotSpacePosition(lastPosition, lexer))) {
                    BufferUtils.appendWithSpaceIfNeeded(result, lexer.substring(lastPosition, position));
                }
                lexer.skipSpacesTillNewLine();
                lastPosition = lexer.getCurrentPosition();
            }
            if (result != null) {
                BufferUtils.appendWithSpaceIfNeeded(result, lexer.substring(lastPosition, lexer.getLength()));
                return result.toString();
            }
        }
        catch (LexerException lexerException) {
            // empty catch block
        }
        return buffer;
    }

    private static void appendWithSpaceIfNeeded(StringBuilder result, String trailingPart) {
        if (result.length() > 0 && trailingPart.length() > 0 && !BufferUtils.isSpace(result.charAt(result.length() - 1)) && !BufferUtils.isSpace(trailingPart.charAt(0))) {
            result.append(" ");
        }
        result.append(trailingPart);
    }

    private static int getLastNotSpacePosition(int beginPosition, Lexer<?> lexer) {
        char c;
        int position = lexer.getCurrentTokenPosition();
        --position;
        boolean newline = false;
        while (position >= beginPosition && BufferUtils.isSpace(c = lexer.charAt(position))) {
            --position;
            if (!BufferUtils.isNewLine(c)) continue;
            if (newline) break;
            newline = true;
        }
        return ++position;
    }

    public static boolean isSpace(char c) {
        return Character.isWhitespace(c);
    }

    public static boolean isNewLine(char c) {
        switch (c) {
            case '\n': {
                return true;
            }
        }
        return false;
    }

    public static String normalizeCommand(String command) {
        StringBuilder builder = new StringBuilder(command);
        while (builder.length() > 0 && BufferUtils.isSpace(builder.charAt(0))) {
            builder.deleteCharAt(0);
        }
        for (int i = 0; i < builder.length(); ++i) {
            if (!BufferUtils.isSpace(builder.charAt(i))) continue;
            builder.setCharAt(i, ' ');
            ++i;
            while (i < builder.length() && BufferUtils.isSpace(builder.charAt(i))) {
                builder.deleteCharAt(i);
            }
        }
        return builder.toString();
    }

    public static String getCommonPrefix(List<String> values) {
        if (values == null || values.size() == 0) {
            return null;
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        int prefixLength = 0;
        int shortValueIndex = 0;
        boolean running = true;
        block0: while (running && prefixLength < values.get(shortValueIndex).length()) {
            char c = values.get(shortValueIndex).charAt(prefixLength++);
            for (int i = 0; i < values.size(); ++i) {
                String value = values.get(i);
                if (prefixLength > value.length() || value.charAt(prefixLength - 1) != c) {
                    --prefixLength;
                    running = false;
                    continue block0;
                }
                if (prefixLength != 1 || value.length() >= values.get(shortValueIndex).length()) continue;
                shortValueIndex = i;
            }
        }
        if (prefixLength > 0) {
            return values.get(shortValueIndex).substring(0, prefixLength);
        }
        return null;
    }

    public static int skipSpacesAndCommends(String buffer, int position) {
        int oldPosition;
        do {
            oldPosition = position;
            position = BufferUtils.skipSpaces(buffer, position);
            position = BufferUtils.skipOneLineComments(buffer, position);
        } while (oldPosition != (position = BufferUtils.skipMultilineComments(buffer, position)));
        return position;
    }

    public static int skipSpaces(String buffer, int position) {
        while (position < buffer.length() && Character.isWhitespace(buffer.charAt(position))) {
            ++position;
        }
        return position;
    }

    public static int skipOneLineComments(String buffer, int position) {
        if (position + 1 < buffer.length() && buffer.charAt(position) == '/' && buffer.charAt(position + 1) == '/') {
            position = (position = buffer.indexOf("\n", position + 1)) == -1 ? buffer.length() : ++position;
        }
        return position;
    }

    public static int skipMultilineComments(String buffer, int position) {
        int endIndex;
        if (position + 3 < buffer.length() && buffer.charAt(position) == '/' && buffer.substring(position, position + 2).equals("/*") && (endIndex = buffer.indexOf("*/", position + 2)) != -1) {
            position = endIndex + 2;
        }
        return position;
    }

    public static String replaceSpecialChars(String str) {
        StringBuilder builder = null;
        int lastBuiltPos = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '\\' || i >= str.length() - 1) continue;
            char nextChar = str.charAt(i + 1);
            Character newChar = null;
            if (nextChar == '\\') {
                newChar = Character.valueOf('\\');
            } else if (nextChar == 'n') {
                newChar = Character.valueOf('\n');
            } else if (nextChar == 't') {
                newChar = Character.valueOf('\t');
            } else if (nextChar == 'r') {
                newChar = Character.valueOf('\r');
            }
            if (newChar == null) continue;
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(str, lastBuiltPos, i);
            builder.append(newChar);
            lastBuiltPos = i + 2;
            ++i;
        }
        if (lastBuiltPos > 0 && lastBuiltPos < str.length()) {
            builder.append(str, lastBuiltPos, str.length());
        }
        return builder != null ? builder.toString() : str;
    }

    public static String replaceSpecialCharsBackward(String str) {
        str = str.replace("\n", "\\n");
        str = str.replace("\t", "\\t");
        str = str.replace("\r", "\\r");
        return str;
    }

    public static String normalizeCommandWithLowerCase(String command) {
        command = BufferUtils.normalizeCommand(command);
        StringBuilder builder = new StringBuilder();
        Character openQuote = null;
        for (char c : command.toCharArray()) {
            if (openQuote != null) {
                if (c == openQuote.charValue()) {
                    openQuote = null;
                }
            } else if (c == '\'' || c == '\"') {
                openQuote = Character.valueOf(c);
            } else {
                c = Character.toLowerCase(c);
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String normalizeCommandWithLowerCase(String command, char open, char close) {
        command = BufferUtils.normalizeCommand(command);
        StringBuilder builder = new StringBuilder();
        Character openQuote = null;
        for (char c : command.toCharArray()) {
            if (openQuote != null) {
                if (c == close) {
                    openQuote = null;
                }
            } else if (c == open) {
                openQuote = Character.valueOf(c);
            } else {
                c = Character.toLowerCase(c);
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String unslashString(String s) {
        if (s == null) {
            return s;
        }
        int lastAppendedPos = 0;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= escapedCharMap.length || escapedCharMap[c] == '\u0000') continue;
            if (lastAppendedPos < i) {
                builder.append(s, lastAppendedPos, i);
            }
            builder.append('\\');
            builder.append(escapedCharMap[c]);
            lastAppendedPos = i + 1;
        }
        if (lastAppendedPos > 0) {
            if (lastAppendedPos < s.length()) {
                builder.append(s, lastAppendedPos, s.length());
            }
            s = builder.toString();
        }
        return s;
    }

    public static String unslashPath(String s) {
        if ((s = BufferUtils.unslashString(s)) != null && !JVM.isWindowsOS()) {
            s = s.replaceAll("\\\\", "/").replace("\\", "/");
        }
        return s;
    }

    static {
        char[] escapedChars = new char[]{'\b', '\f', '\n', '\r', '\t'};
        int escapedCharMaxCode = 0;
        for (char c : escapedChars) {
            escapedCharMaxCode = Math.max(escapedCharMaxCode, c);
        }
        escapedCharMap = new char[escapedCharMaxCode + 1];
        BufferUtils.escapedCharMap[8] = 98;
        BufferUtils.escapedCharMap[12] = 102;
        BufferUtils.escapedCharMap[10] = 110;
        BufferUtils.escapedCharMap[13] = 114;
        BufferUtils.escapedCharMap[9] = 116;
    }
}

