/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.console.terminal;

import com.streamscape.tools.console.terminal.AbstractColouredPrintStream;
import com.streamscape.tools.console.terminal.AbstractTerminal;
import com.streamscape.tools.console.terminal.Color;
import com.streamscape.tools.console.terminal.InputCharacter;
import com.streamscape.tools.console.terminal.Keys;
import com.streamscape.tools.console.terminal.PrintStreamWithInPlacePrint;
import com.streamscape.tools.console.terminal.ReadInterruptedException;
import com.streamscape.tools.console.terminal.WindowsNativeLibrary;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class WindowsTerminal
extends AbstractTerminal {
    private InputStream in;
    private PrintStream out;
    private Color defaultColor = null;
    private Charset encoding = Charset.defaultCharset();

    public WindowsTerminal(boolean interruptable) {
        super(interruptable);
        this.in = new InputStream(){

            @Override
            public int read() throws IOException {
                return WindowsTerminal.this.readByte();
            }
        };
        try {
            this.setOut(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.defaultColor = new Color(WindowsNativeLibrary.getConsoleTextAttribute());
    }

    @Override
    protected InputCharacter convertByteInterruptable(int code, boolean interruptable) throws ReadInterruptedException {
        if (code == -1) {
            return null;
        }
        if (code == 13) {
            code = 13;
        }
        if (code >= 32 && code < 127 || code == 13) {
            return new InputCharacter(code);
        }
        if (code == 127) {
            return new InputCharacter(Keys.CTRL_BACKSPACE, code);
        }
        Keys key = Keys.UNKNOWN;
        if (code == 0 || code == 224) {
            code = interruptable ? this.readByteInterruptable() : this.readByte();
            switch (code) {
                case 72: {
                    key = Keys.UP;
                    break;
                }
                case 80: {
                    key = Keys.DOWN;
                    break;
                }
                case 75: {
                    key = Keys.LEFT;
                    break;
                }
                case 77: {
                    key = Keys.RIGHT;
                    break;
                }
                case 71: {
                    key = Keys.HOME;
                    break;
                }
                case 79: {
                    key = Keys.END;
                    break;
                }
                case 73: {
                    key = Keys.PAGEUP;
                    break;
                }
                case 81: {
                    key = Keys.PAGEDOWN;
                    break;
                }
                case 83: {
                    key = Keys.DEL;
                    break;
                }
                case 82: {
                    key = Keys.INSERT;
                    break;
                }
                case 115: {
                    key = Keys.CTRL_LEFT;
                    break;
                }
                case 116: {
                    key = Keys.CTRL_RIGHT;
                    break;
                }
                case 119: {
                    key = Keys.CTRL_HOME;
                    break;
                }
                case 117: {
                    key = Keys.CTRL_END;
                }
            }
            return new InputCharacter(key, code);
        }
        switch (code) {
            case 3: {
                key = Keys.CTRL_C;
                break;
            }
            case 11: {
                key = Keys.CTRL_K;
                break;
            }
            case 8: {
                key = Keys.BACKSPACE;
                break;
            }
            case 9: {
                key = Keys.TAB;
                break;
            }
            case 27: {
                key = Keys.ESCAPE;
            }
        }
        return new InputCharacter(key, code);
    }

    @Override
    public int readByte() {
        return WindowsNativeLibrary.getch();
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public PrintStream getPrintStream() {
        return this.out;
    }

    @Override
    public PrintStream getPrintStream(Color color) {
        return new ColouredPrintStream(this.out, color);
    }

    @Override
    public int getWidth() {
        return WindowsNativeLibrary.getTerminalWidth();
    }

    @Override
    public int getHeight() {
        return WindowsNativeLibrary.getTerminalHeight();
    }

    @Override
    public void clear() {
        WindowsNativeLibrary.COORD current = new WindowsNativeLibrary.COORD();
        WindowsNativeLibrary.getCurrentCursorPosition(current);
        WindowsNativeLibrary.COORD top = new WindowsNativeLibrary.COORD();
        top.X = 0;
        top.Y = (short)this.getHeight();
        while (top.Y >= 0) {
            WindowsNativeLibrary.fillWithCharacter(' ', this.getWidth(), top);
            top.Y = (short)(top.Y - 1);
        }
        if (current.Y != 0) {
            current.Y = (short)(current.Y + 1);
        }
        current.X = 0;
        WindowsNativeLibrary.setCurrentCursorPosition(current);
    }

    @Override
    public void back() {
        this.back(1);
    }

    @Override
    public void back(int count) {
        WindowsNativeLibrary.COORD coord = new WindowsNativeLibrary.COORD();
        if (WindowsNativeLibrary.getCurrentCursorPosition(coord)) {
            int width = WindowsNativeLibrary.getTerminalWidth();
            coord.X = (short)(coord.X - count);
            while (coord.X < 0) {
                coord.X = (short)(coord.X + width);
                coord.Y = (short)(coord.Y + 1);
            }
            WindowsNativeLibrary.setCurrentCursorPosition(coord);
        }
    }

    @Override
    public void backspace() {
        this.backspace(1);
    }

    @Override
    public void backspace(int count) {
        WindowsNativeLibrary.COORD coord = new WindowsNativeLibrary.COORD();
        if (WindowsNativeLibrary.getCurrentCursorPosition(coord)) {
            int width = WindowsNativeLibrary.getTerminalWidth();
            coord.X = (short)(coord.X - count);
            while (coord.X < 0) {
                coord.X = (short)(coord.X + width);
                coord.Y = (short)(coord.Y + 1);
            }
            WindowsNativeLibrary.fillWithCharacter(' ', count, coord);
            WindowsNativeLibrary.setCurrentCursorPosition(coord);
        }
    }

    @Override
    public void clearforward() {
        this.clearforward(1);
    }

    @Override
    public void clearforward(int count) {
        WindowsNativeLibrary.COORD coord = new WindowsNativeLibrary.COORD();
        if (WindowsNativeLibrary.getCurrentCursorPosition(coord)) {
            int width = WindowsNativeLibrary.getTerminalWidth();
            while (count > 0) {
                if (count >= width - coord.X) {
                    int toClearCount = width - coord.X;
                    WindowsNativeLibrary.fillWithCharacter(' ', toClearCount, coord);
                    coord.X = 0;
                    coord.Y = (short)(coord.Y - 1);
                    WindowsNativeLibrary.setCurrentCursorPosition(coord);
                    count -= toClearCount;
                    continue;
                }
                WindowsNativeLibrary.fillWithCharacter(' ', count, coord);
                count = 0;
            }
        }
    }

    @Override
    public void forward(Character c) {
        this.forward(1, c.toString());
    }

    @Override
    public void forward(int count, String forwardString) {
        WindowsNativeLibrary.COORD coord = new WindowsNativeLibrary.COORD();
        if (WindowsNativeLibrary.getCurrentCursorPosition(coord)) {
            int width = WindowsNativeLibrary.getTerminalWidth();
            coord.X = (short)(coord.X + count);
            while (coord.X >= width) {
                coord.X = (short)(coord.X - width);
                coord.Y = (short)(coord.Y - 1);
            }
            WindowsNativeLibrary.setCurrentCursorPosition(coord);
        }
    }

    @Override
    public void setPositionRelative(int dx, int dy) {
        WindowsNativeLibrary.COORD coord = new WindowsNativeLibrary.COORD();
        if (WindowsNativeLibrary.getCurrentCursorPosition(coord)) {
            coord.X = (short)(coord.X + dx);
            coord.Y = (short)(coord.Y - dy);
            WindowsNativeLibrary.setCurrentCursorPosition(coord);
        }
    }

    @Override
    public boolean isEchoEnabled() {
        return false;
    }

    private void setOut(Charset charset) throws UnsupportedEncodingException {
        this.out = new PrintStreamWithInPlacePrint(new PrintStream((OutputStream)System.out, true, charset.name()), this);
    }

    @Override
    public void setEncoding(Charset charset) throws UnsupportedEncodingException {
        this.setOut(charset);
    }

    @Override
    public void setEchoEnabled(boolean enabled) {
    }

    private class ColouredPrintStream
    extends AbstractColouredPrintStream {
        ColouredPrintStream(PrintStream out, Color color) {
            super(out, color);
            this.setColor(color);
        }

        @Override
        public void onPrint(String s) {
            if (this.color != null) {
                WindowsNativeLibrary.setConsoleTextAttribute(this.color.getColor());
                super.onPrint(s);
                WindowsNativeLibrary.setConsoleTextAttribute(WindowsTerminal.this.defaultColor.getColor());
            } else {
                super.onPrint(s);
            }
        }

        @Override
        public void onNewLine() {
            if (this.color != null) {
                WindowsNativeLibrary.setConsoleTextAttribute(this.color.getColor());
                super.onNewLine();
                WindowsNativeLibrary.setConsoleTextAttribute(WindowsTerminal.this.defaultColor.getColor());
            } else {
                super.onNewLine();
            }
        }

        private void setColor(Color color) {
            if (color == null) {
                return;
            }
            this.color = new Color(WindowsTerminal.this.defaultColor.getForegroundColor(), WindowsTerminal.this.defaultColor.getBackgroundColor());
            if (color.isForegroundColorSet()) {
                this.color.setForegroundColor(color.getForegroundColor());
            }
            if (color.isBackgroundColorSet()) {
                this.color.setBackgroundColor(color.getBackgroundColor());
            }
        }
    }
}

