/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.console.terminal;

import com.streamscape.tools.console.terminal.DllLoader;
import com.streamscape.tools.console.terminal.DllLoaderException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class WindowsNativeLibrary {
    public static final String DLL_RELEASE_DIR = "/WindowsNativeLibrary/Release/";
    public static final String DLL_NAME = "WindowsNativeLibrary.dll";
    private static final Map<String, Integer> codePageMap;

    public static void init() throws DllLoaderException {
        String path = "/WindowsNativeLibrary/Release/x";
        if (System.getProperty("sun.arch.data.model") != null) {
            DllLoader.loadFromJar(path + System.getProperty("sun.arch.data.model") + "/WindowsNativeLibrary.dll");
        } else {
            try {
                DllLoader.loadFromJar(path + "64/WindowsNativeLibrary.dll");
            }
            catch (Exception e) {
                DllLoader.loadFromJar(path + "32/WindowsNativeLibrary.dll");
            }
        }
    }

    public static void init(String filename) throws DllLoaderException {
        DllLoader.load(filename);
    }

    public static native int getch();

    public static native boolean setCP(int var0);

    public static native int getTerminalWidth();

    public static native int getTerminalHeight();

    public static native boolean getCurrentCursorPosition(COORD var0);

    public static native boolean setCurrentCursorPosition(COORD var0);

    public static native int fillWithCharacterFromCurrentPosition(char var0, int var1);

    public static native int fillWithCharacter(char var0, int var1, COORD var2);

    public static native short getConsoleTextAttribute();

    public static native boolean setConsoleTextAttribute(short var0);

    public static native int getLastError();

    public static native String getLastErrorStr();

    public static boolean setCodePage(String cpName) {
        if (!codePageMap.containsKey(cpName = cpName.toLowerCase())) {
            return false;
        }
        return WindowsNativeLibrary.setCP(codePageMap.get(cpName));
    }

    static {
        LinkedHashMap<String, Integer> cp = new LinkedHashMap<String, Integer>();
        cp.put("ibm037", 37);
        cp.put("ibm437", 437);
        cp.put("ibm500", 500);
        cp.put("asmo-708", 708);
        cp.put("dos-720", 720);
        cp.put("ibm737", 737);
        cp.put("ibm775", 775);
        cp.put("ibm850", 850);
        cp.put("ibm852", 852);
        cp.put("ibm855", 855);
        cp.put("ibm857", 857);
        cp.put("ibm00858", 858);
        cp.put("ibm860", 860);
        cp.put("ibm861", 861);
        cp.put("dos-862", 862);
        cp.put("ibm863", 863);
        cp.put("ibm864", 864);
        cp.put("ibm865", 865);
        cp.put("cp866", 866);
        cp.put("ibm869", 869);
        cp.put("ibm870", 870);
        cp.put("windows-874", 874);
        cp.put("cp875", 875);
        cp.put("shift_jis", 932);
        cp.put("gb2312", 936);
        cp.put("ks_c_5601-1987", 949);
        cp.put("big5", 950);
        cp.put("ibm1026", 1026);
        cp.put("ibm01047", 1047);
        cp.put("ibm01140", 1140);
        cp.put("ibm01141", 1141);
        cp.put("ibm01142", 1142);
        cp.put("ibm01143", 1143);
        cp.put("ibm01144", 1144);
        cp.put("ibm01145", 1145);
        cp.put("ibm01146", 1146);
        cp.put("ibm01147", 1147);
        cp.put("ibm01148", 1148);
        cp.put("ibm01149", 1149);
        cp.put("utf-16", 1200);
        cp.put("unicodefffe", 1201);
        cp.put("windows-1250", 1250);
        cp.put("windows-1251", 1251);
        cp.put("windows-1252", 1252);
        cp.put("windows-1253", 1253);
        cp.put("windows-1254", 1254);
        cp.put("windows-1255", 1255);
        cp.put("windows-1256", 1256);
        cp.put("windows-1257", 1257);
        cp.put("windows-1258", 1258);
        cp.put("johab", 1361);
        cp.put("macintosh", 10000);
        cp.put("x-mac-japanese", 10001);
        cp.put("x-mac-chinesetrad", 10002);
        cp.put("x-mac-korean", 10003);
        cp.put("x-mac-arabic", 10004);
        cp.put("x-mac-hebrew", 10005);
        cp.put("x-mac-greek", 10006);
        cp.put("x-mac-cyrillic", 10007);
        cp.put("x-mac-chinesesimp", 10008);
        cp.put("x-mac-romanian", 10010);
        cp.put("x-mac-ukrainian", 10017);
        cp.put("x-mac-thai", 10021);
        cp.put("x-mac-ce", 10029);
        cp.put("x-mac-icelandic", 10079);
        cp.put("x-mac-turkish", 10081);
        cp.put("x-mac-croatian", 10082);
        cp.put("utf-32", 12000);
        cp.put("utf-32be", 12001);
        cp.put("x-chinese_cns", 20000);
        cp.put("x-cp20001", 20001);
        cp.put("x_chinese-eten", 20002);
        cp.put("x-cp20003", 20003);
        cp.put("x-cp20004", 20004);
        cp.put("x-cp20005", 20005);
        cp.put("x-ia5", 20105);
        cp.put("x-ia5-german", 20106);
        cp.put("x-ia5-swedish", 20107);
        cp.put("x-ia5-norwegian", 20108);
        cp.put("us-ascii", 20127);
        cp.put("x-cp20261", 20261);
        cp.put("x-cp20269", 20269);
        cp.put("ibm273", 20273);
        cp.put("ibm277", 20277);
        cp.put("ibm278", 20278);
        cp.put("ibm280", 20280);
        cp.put("ibm284", 20284);
        cp.put("ibm285", 20285);
        cp.put("ibm290", 20290);
        cp.put("ibm297", 20297);
        cp.put("ibm420", 20420);
        cp.put("ibm423", 20423);
        cp.put("ibm424", 20424);
        cp.put("x-ebcdic-koreanextended", 20833);
        cp.put("ibm-thai", 20838);
        cp.put("koi8-r", 20866);
        cp.put("ibm871", 20871);
        cp.put("ibm880", 20880);
        cp.put("ibm905", 20905);
        cp.put("ibm00924", 20924);
        cp.put("euc-jp", 20932);
        cp.put("x-cp20936", 20936);
        cp.put("x-cp20949", 20949);
        cp.put("cp1025", 21025);
        cp.put("koi8-u", 21866);
        cp.put("iso-8859-1", 28591);
        cp.put("iso-8859-2", 28592);
        cp.put("iso-8859-3", 28593);
        cp.put("iso-8859-4", 28594);
        cp.put("iso-8859-5", 28595);
        cp.put("iso-8859-6", 28596);
        cp.put("iso-8859-7", 28597);
        cp.put("iso-8859-8", 28598);
        cp.put("iso-8859-9", 28599);
        cp.put("iso-8859-13", 28603);
        cp.put("iso-8859-15", 28605);
        cp.put("x-europa", 29001);
        cp.put("iso-8859-8-i", 38598);
        cp.put("iso-2022-jp", 50220);
        cp.put("csiso2022jp", 50221);
        cp.put("iso-2022-jp", 50222);
        cp.put("iso-2022-kr", 50225);
        cp.put("x-cp50227", 50227);
        cp.put("euc-jp", 51932);
        cp.put("euc-cn", 51936);
        cp.put("euc-kr", 51949);
        cp.put("hz-gb-2312", 52936);
        cp.put("gb18030", 54936);
        cp.put("x-iscii-de", 57002);
        cp.put("x-iscii-be", 57003);
        cp.put("x-iscii-ta", 57004);
        cp.put("x-iscii-te", 57005);
        cp.put("x-iscii-as", 57006);
        cp.put("x-iscii-or", 57007);
        cp.put("x-iscii-ka", 57008);
        cp.put("x-iscii-ma", 57009);
        cp.put("x-iscii-gu", 57010);
        cp.put("x-iscii-pa", 57011);
        cp.put("utf-7", 65000);
        cp.put("utf-8", 65001);
        codePageMap = Collections.unmodifiableMap(cp);
    }

    public static class COORD {
        public short X;
        public short Y;
    }
}

