/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.console.terminal;

import com.streamscape.lib.utils.JVM;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SttySettings {
    public static final String STTY_COMMAND = "stty";
    public static final String SH_COMMAND = "/bin/bash";
    public static final String DEFAULT_TTY = "/dev/tty";
    private String sttyCommand = "stty";
    private String shCommand = "/bin/bash";
    private String tty;
    private String config;
    private String intr;
    private long configLastFetched;
    private boolean withSttySetup = true;

    public SttySettings(boolean withSttySetup) {
        this.withSttySetup = withSttySetup;
    }

    public void setSHCommand(String shCommand) {
        this.shCommand = shCommand;
    }

    public void setTty(String tty) {
        this.tty = tty;
    }

    public void init() throws IOException, InterruptedException {
        this.config = this.get("-a");
        this.configLastFetched = System.currentTimeMillis();
        if (this.config.length() == 0) {
            throw new IOException(MessageFormat.format("Unrecognized stty code: {0}", this.config));
        }
        if (this.withSttySetup) {
            this.intr = SttySettings.getStringProperty("intr", this.config);
            this.stty("-icanon min 1 -icrnl -inlcr");
            this.stty("-echo");
            this.stty("intr ^c");
        }
    }

    public void restore() throws IOException, InterruptedException {
        if (this.withSttySetup) {
            this.set("sane");
            this.set("intr " + this.intr);
        }
    }

    public String get(String args) throws IOException, InterruptedException {
        return this.stty(args);
    }

    public void set(String args) throws IOException, InterruptedException {
        this.stty(args);
    }

    public int getProperty(String name) {
        try {
            if (this.config == null || System.currentTimeMillis() - this.configLastFetched > 1000L) {
                this.config = this.get("-a");
                this.configLastFetched = System.currentTimeMillis();
            }
            return SttySettings.getProperty(name, this.config);
        }
        catch (Exception e) {
            return -1;
        }
    }

    protected static int getProperty(String name, String stty) {
        String s = SttySettings.getStringProperty(name, stty);
        if (s == null) {
            return -1;
        }
        return SttySettings.parseControlChar(s);
    }

    protected static String getStringProperty(String name, String stty) {
        Pattern pattern = Pattern.compile(name + "\\s+=\\s+([^;]*)[;\\n\\r]");
        Matcher matcher = pattern.matcher(stty);
        if (!(matcher.find() || (matcher = (pattern = Pattern.compile(name + "\\s+([^;]*)[;\\n\\r]")).matcher(stty)).find() || (matcher = (pattern = Pattern.compile("(\\S*)\\s+" + name)).matcher(stty)).find())) {
            return null;
        }
        return matcher.group(1);
    }

    private static int parseControlChar(String str) {
        if ("<undef>".equals(str)) {
            return -1;
        }
        if (str.charAt(0) == '0') {
            return Integer.parseInt(str, 8);
        }
        if (str.charAt(0) >= '1' && str.charAt(0) <= '9') {
            return Integer.parseInt(str, 10);
        }
        if (str.charAt(0) == '^') {
            if (str.charAt(1) == '?') {
                return 127;
            }
            return str.charAt(1) - 64;
        }
        if (str.charAt(0) == 'M' && str.charAt(1) == '-') {
            if (str.charAt(2) == '^') {
                if (str.charAt(3) == '?') {
                    return 255;
                }
                return str.charAt(3) - 64 + 128;
            }
            return str.charAt(2) + 128;
        }
        return str.charAt(0);
    }

    private String stty(String args) throws IOException, InterruptedException {
        if (this.tty != null) {
            if (JVM.isMacOS()) {
                return this.exec(String.format("%s -f %s %s ", this.sttyCommand, this.tty, args));
            }
            if (JVM.isSolarisOS()) {
                return this.exec(String.format("%s %s ", this.sttyCommand, args));
            }
            return this.exec(String.format("%s -F %s %s ", this.sttyCommand, this.tty, args));
        }
        return this.exec(String.format("%s %s", this.sttyCommand, args));
    }

    private String exec(String cmd) throws IOException, InterruptedException {
        return this.exec(this.shCommand, "-c", cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String exec(String ... cmd) throws IOException, InterruptedException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        boolean isError = false;
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        processBuilder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        Process p = processBuilder.start();
        InputStream in = null;
        InputStream err = null;
        OutputStream out = null;
        try {
            int c;
            in = p.getInputStream();
            while ((c = in.read()) != -1) {
                bout.write(c);
            }
            err = p.getErrorStream();
            while ((c = err.read()) != -1) {
                bout.write(c);
                isError = true;
            }
            out = p.getOutputStream();
            p.waitFor();
        }
        catch (Throwable throwable) {
            SttySettings.close(in, out, err);
            throw throwable;
        }
        SttySettings.close(in, out, err);
        if (isError) {
            throw new IOException("Failed to call stty: " + bout.toString());
        }
        return bout.toString();
    }

    private static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

