/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.console.terminal;

import com.streamscape.tools.console.terminal.PrintStreamDecorator;
import com.streamscape.tools.console.terminal.Terminal;
import java.io.PrintStream;

public class PrintStreamWithInPlacePrint
extends PrintStreamDecorator {
    private final Terminal terminal;
    private String lastLine = null;

    public PrintStreamWithInPlacePrint(PrintStream printStream, Terminal terminal) {
        super(printStream);
        this.terminal = terminal;
    }

    @Override
    protected void onPrint(char c) {
        this.lastLine = null;
        super.onPrint(c);
    }

    @Override
    protected void onPrint(String s) {
        if (PrintStreamWithInPlacePrint.canLinesBeReplaced(this.lastLine, s)) {
            this.clearLastLine();
        }
        this.lastLine = null;
        super.onPrint(s);
        if (s != null && s.endsWith("\n")) {
            this.lastLine = s;
        }
    }

    @Override
    protected void onNewLine() {
        this.lastLine = null;
        super.onNewLine();
    }

    private void clearLastLine() {
        if (this.lastLine != null) {
            this.terminal.setPositionRelative(this.lastLine.length() - 1, -1);
            this.terminal.backspace(this.lastLine.length() - 1);
        }
    }

    private static boolean canLinesBeReplaced(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        if (!s1.endsWith("\n") || !s2.endsWith("\n")) {
            return false;
        }
        boolean inNumber = false;
        int s1Index = 0;
        int s2Index = 0;
        while (s1Index < s1.length() && s2Index < s2.length()) {
            if (s1.charAt(s1Index) == s2.charAt(s2Index)) {
                ++s1Index;
                ++s2Index;
                continue;
            }
            if (Character.isDigit(s1.charAt(s1Index)) && Character.isDigit(s2.charAt(s2Index))) {
                inNumber = true;
                ++s1Index;
                ++s2Index;
                continue;
            }
            if (inNumber) {
                if (Character.isDigit(s1.charAt(s1Index))) {
                    ++s1Index;
                    continue;
                }
                if (!Character.isDigit(s2.charAt(s2Index))) break;
                ++s2Index;
                continue;
            }
            if (inNumber) break;
            inNumber = true;
            if (Character.isDigit(s1.charAt(s1Index))) {
                ++s1Index;
                continue;
            }
            if (!Character.isDigit(s2.charAt(s2Index))) break;
            ++s2Index;
        }
        return s1Index == s1.length() && s2Index == s2.length();
    }

    public static void main(String[] args) {
        PrintStreamWithInPlacePrint.printCanLinesBeReplaced("1234\n", "12345\n");
        PrintStreamWithInPlacePrint.printCanLinesBeReplaced("line 2 ..\n", "line 13 ..\n");
        PrintStreamWithInPlacePrint.printCanLinesBeReplaced("line 12 ..\n", "line 13 ..\n");
        PrintStreamWithInPlacePrint.printCanLinesBeReplaced("line1\n", "line2\n");
    }

    private static void printCanLinesBeReplaced(String line1, String line2) {
        System.out.print(line1);
        System.out.print(line2);
        System.out.println(PrintStreamWithInPlacePrint.canLinesBeReplaced(line1, line2));
        System.out.println();
    }
}

