/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.console.terminal;

import java.io.PrintStream;
import java.util.Locale;

public class PrintStreamDecorator
extends PrintStream {
    private PrintStream printStream;

    public PrintStreamDecorator(PrintStream printStream) {
        super(printStream);
        this.printStream = printStream;
    }

    protected void onPrint(char c) {
        this.printStream.print(c);
    }

    protected void onPrint(String s) {
        this.printStream.print(s);
    }

    protected void onNewLine() {
        this.printStream.println();
    }

    @Override
    public void flush() {
        this.printStream.flush();
    }

    @Override
    public void close() {
        this.printStream.close();
    }

    @Override
    public boolean checkError() {
        return this.printStream.checkError();
    }

    @Override
    public void write(int b) {
        this.printStream.write(b);
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.printStream.write(buf, off, len);
    }

    @Override
    public void print(boolean b) {
        this.onPrint(b ? "true" : "false");
    }

    @Override
    public void print(char c) {
        this.onPrint(String.valueOf(c));
    }

    @Override
    public void print(int i) {
        this.onPrint(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.onPrint(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.onPrint(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.onPrint(String.valueOf(d));
    }

    @Override
    public void print(char[] s) {
        this.onPrint(new String(s));
    }

    @Override
    public void print(String s) {
        if (s == null) {
            s = "null";
        }
        this.onPrint(s);
    }

    @Override
    public void print(Object obj) {
        this.onPrint(String.valueOf(obj));
    }

    @Override
    public void println() {
        this.onNewLine();
    }

    private void newLine() {
        this.onNewLine();
    }

    @Override
    public void println(boolean x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(char x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(int x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(long x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(float x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(double x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(char[] x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(String x) {
        this.print(x);
        this.newLine();
    }

    @Override
    public void println(Object x) {
        String s = String.valueOf(x);
        this.print(s);
        this.newLine();
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        return this.printStream.format(format, args);
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        return this.printStream.format(l, format, args);
    }

    @Override
    public PrintStream format(String format, Object ... args) {
        return this.printStream.format(format, args);
    }

    @Override
    public PrintStream format(Locale l, String format, Object ... args) {
        return this.printStream.format(l, format, args);
    }

    @Override
    public PrintStream append(CharSequence csq) {
        if (csq == null) {
            this.print("null");
        } else {
            this.print(csq.toString());
        }
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.print(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public PrintStream append(char c) {
        this.print(c);
        return this;
    }
}

