/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.console.terminal;

import com.streamscape.slex.lang.PrefixTree;
import com.streamscape.tools.console.terminal.AbstractColouredPrintStream;
import com.streamscape.tools.console.terminal.AbstractTerminal;
import com.streamscape.tools.console.terminal.Color;
import com.streamscape.tools.console.terminal.InputCharacter;
import com.streamscape.tools.console.terminal.Keys;
import com.streamscape.tools.console.terminal.PrintStreamWithInPlacePrint;
import com.streamscape.tools.console.terminal.ReadInterruptedException;
import com.streamscape.tools.console.terminal.SttySettings;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;

public class LinuxTerminal
extends AbstractTerminal {
    private InputStream in;
    private PrintStream out;
    SttySettings sttySettings = null;
    private PrefixTree<Keys> keysMap;

    public LinuxTerminal() {
        this(null);
    }

    public LinuxTerminal(SttySettings sttySetting) {
        super(true);
        this.sttySettings = sttySetting;
    }

    @Override
    public void init() throws Exception {
        if (this.sttySettings == null) {
            this.sttySettings = new SttySettings(true);
        }
        this.sttySettings.init();
        this.initKeysMap();
        this.in = new InputStream(){

            @Override
            public int read() throws IOException {
                return LinuxTerminal.this.readByte();
            }
        };
        this.out = new PrintStreamWithInPlacePrint(System.out, this);
    }

    @Override
    public void destroy() {
        try {
            this.sttySettings.restore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void initKeysMap() {
        this.keysMap = new PrefixTree(true);
        this.keysMap.setIgnoreMultilineComments(false);
        this.keysMap.setIgnoreOneLineComments(false);
        this.keysMap.add("\u001b\u001b[A", Keys.ALT_UP);
        this.keysMap.add("\u001b\u001b[B", Keys.ALT_DOWN);
        this.keysMap.add("\u001b[A", Keys.UP);
        this.keysMap.add("\u001b[B", Keys.DOWN);
        this.keysMap.add("\u001b[C", Keys.RIGHT);
        this.keysMap.add("\u001b[D", Keys.LEFT);
        this.keysMap.add("\u001b[1;5A", Keys.CTRL_UP);
        this.keysMap.add("\u001b[1;5B", Keys.CTRL_DOWN);
        this.keysMap.add("\u001b[1;5C", Keys.CTRL_RIGHT);
        this.keysMap.add("\u001b[1;5D", Keys.CTRL_LEFT);
        this.keysMap.add("\u001b[5~", Keys.PAGEUP);
        this.keysMap.add("\u001b[6~", Keys.PAGEDOWN);
        this.keysMap.add("\u001b[H", Keys.HOME);
        this.keysMap.add("\u001b[F", Keys.END);
        this.keysMap.add("\u001b[5;5~", Keys.CTRL_PAGEUP);
        this.keysMap.add("\u001b[6;5~", Keys.CTRL_PAGEDOWN);
        this.keysMap.add("\u001b[1;5H", Keys.CTRL_HOME);
        this.keysMap.add("\u001b[1;5F", Keys.CTRL_END);
        this.keysMap.add("\u001b[3~", Keys.DEL);
        this.keysMap.add("\u001b[2~", Keys.INSERT);
    }

    @Override
    protected InputCharacter convertByteInterruptable(int code, boolean interruptable) throws ReadInterruptedException {
        if (code == -1) {
            return null;
        }
        if (code >= 32 && code < 127 || code == 13) {
            return new InputCharacter(code);
        }
        Keys key = Keys.UNKNOWN;
        if (code == 27) {
            PrefixTree.Node<Keys> node;
            int bytesRead = 0;
            for (node = this.keysMap.lookupNode("\u001b"); node != null && !node.isDataNode() && (code = interruptable ? this.readByteInterruptable(10) : this.readByte()) != -1; node = node.lookupChild((char)code, true)) {
                ++bytesRead;
            }
            if (bytesRead > 0) {
                if (node != null && node.isDataNode()) {
                    return new InputCharacter(node.getData(), 27);
                }
                return new InputCharacter(Keys.UNKNOWN, 27);
            }
            return new InputCharacter(Keys.ESCAPE, 27);
        }
        if (code > 127) {
            int bytesCount = 1;
            if ((code & 0xF0) == 240) {
                bytesCount = 4;
            } else if ((code & 0xE0) == 224) {
                bytesCount = 3;
            } else if ((code & 0xC0) == 192) {
                bytesCount = 2;
            }
            if (bytesCount > 1) {
                byte[] bytes = new byte[bytesCount];
                bytes[0] = (byte)code;
                for (int bytesRead = 1; bytesRead < bytesCount && (code = interruptable ? this.readByteInterruptable(10) : this.readByte()) != -1; ++bytesRead) {
                    bytes[bytesRead] = (byte)code;
                }
                char c = new String(bytes, 0, bytes.length, StandardCharsets.UTF_8).charAt(0);
                return new InputCharacter(c);
            }
        }
        switch (code) {
            case 3: {
                key = Keys.CTRL_C;
                break;
            }
            case 11: {
                key = Keys.CTRL_K;
                break;
            }
            case 127: {
                key = Keys.BACKSPACE;
                break;
            }
            case 9: {
                key = Keys.TAB;
                break;
            }
            case 27: {
                key = Keys.ESCAPE;
                break;
            }
            case 31: {
                key = Keys.CTRL_BACKSPACE;
            }
        }
        return new InputCharacter(key, code);
    }

    @Override
    public int readByte() {
        try {
            return System.in.read();
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public PrintStream getPrintStream() {
        return this.out;
    }

    @Override
    public PrintStream getPrintStream(Color color) {
        return new ColouredPrintStream(this.out, color);
    }

    @Override
    public int getWidth() {
        return this.sttySettings.getProperty("columns");
    }

    @Override
    public int getHeight() {
        return this.sttySettings.getProperty("rows");
    }

    @Override
    public void clear() {
        this.printAnsiSequence("2J");
        this.printAnsiSequence(this.getHeight() + ";1H");
    }

    @Override
    public void back() {
        this.back(1);
    }

    @Override
    public void back(int count) {
        for (int i = 0; i < count; ++i) {
            this.out.print("\b");
        }
    }

    @Override
    public void backspace() {
        this.backspace(1);
    }

    @Override
    public void backspace(int count) {
        for (int i = 0; i < count; ++i) {
            this.out.print("\b");
            this.out.print(" ");
            this.out.print("\b");
        }
    }

    @Override
    public void clearforward() {
        this.clearforward(1);
    }

    @Override
    public void clearforward(int count) {
        for (int i = 0; i < count; ++i) {
            this.out.print(" ");
        }
    }

    @Override
    public void forward(Character c) {
        this.forward(1, c.toString());
    }

    @Override
    public void forward(int count, String forwardString) {
        this.out.print(forwardString.substring(0, count < forwardString.length() ? count : forwardString.length()));
    }

    @Override
    public void setPositionRelative(int dx, int dy) {
        if (dy > 0) {
            this.printAnsiSequence(dy + "B");
        } else if (dy < 0) {
            this.printAnsiSequence(-dy + "A");
        }
        if (dx > 0) {
            this.printAnsiSequence(dx + "C");
        } else if (dx < 0) {
            this.printAnsiSequence(-dx + "D");
        }
    }

    @Override
    public boolean isEchoEnabled() {
        return false;
    }

    @Override
    public void setEchoEnabled(boolean enabled) {
    }

    private void printAnsiSequence(String sequence) {
        this.out.write(27);
        this.out.write(91);
        char[] cArray = sequence.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            this.out.write(c.charValue());
        }
        this.out.flush();
    }

    private class ColouredPrintStream
    extends AbstractColouredPrintStream {
        static final String DEFAULT_FG_COLOR = "39;22m";
        static final String DEFAULT_BG_COLOR = "49;22m";
        String fgColorString;
        String bgColorString;

        ColouredPrintStream(PrintStream out, Color color) {
            super(out, color);
            this.fgColorString = null;
            this.bgColorString = null;
            this.initColorStrings(color);
        }

        @Override
        protected void onPrint(String s) {
            try {
                if (this.fgColorString != null) {
                    LinuxTerminal.this.printAnsiSequence(this.fgColorString);
                }
                if (this.bgColorString != null) {
                    LinuxTerminal.this.printAnsiSequence(this.bgColorString);
                }
                super.onPrint(s);
            }
            finally {
                if (this.fgColorString != null) {
                    LinuxTerminal.this.printAnsiSequence(DEFAULT_FG_COLOR);
                }
                if (this.bgColorString != null) {
                    LinuxTerminal.this.printAnsiSequence(DEFAULT_BG_COLOR);
                }
            }
        }

        @Override
        protected void onNewLine() {
            try {
                if (this.fgColorString != null) {
                    LinuxTerminal.this.printAnsiSequence(this.fgColorString);
                }
                if (this.bgColorString != null) {
                    LinuxTerminal.this.printAnsiSequence(this.bgColorString);
                }
                super.onNewLine();
            }
            finally {
                if (this.fgColorString != null) {
                    LinuxTerminal.this.printAnsiSequence(DEFAULT_FG_COLOR);
                }
                if (this.bgColorString != null) {
                    LinuxTerminal.this.printAnsiSequence(DEFAULT_BG_COLOR);
                }
            }
        }

        private void initColorStrings(Color color) {
            String decorators;
            int ansiColor;
            this.fgColorString = null;
            this.bgColorString = null;
            if (color == null) {
                return;
            }
            if (color.isForegroundColorSet()) {
                int ifgColor = color.getForegroundColor();
                ansiColor = 30;
                decorators = this.decoratorsString(ifgColor, (short)8);
                if (((ifgColor = this.unsetDecorators(ifgColor, 8)) | 0) == 0) {
                    ansiColor += 0;
                } else if ((ifgColor | 4) == 4) {
                    ++ansiColor;
                } else if ((ifgColor | 2) == 2) {
                    ansiColor += 2;
                } else if ((ifgColor | 6) == 6) {
                    ansiColor += 3;
                } else if ((ifgColor | 1) == 1) {
                    ansiColor += 4;
                } else if ((ifgColor | 5) == 5) {
                    ansiColor += 5;
                } else if ((ifgColor | 3) == 3) {
                    ansiColor += 6;
                } else if ((ifgColor | 7) == 7) {
                    ansiColor += 7;
                }
                this.fgColorString = ansiColor + decorators + "m";
            }
            if (color.isBackgroundColorSet()) {
                int ibgColor = color.getBackgroundColor();
                ansiColor = 40;
                decorators = this.decoratorsString(ibgColor, (short)128);
                if (((ibgColor = this.unsetDecorators(ibgColor, 128)) | 0) == 0) {
                    ansiColor += 0;
                } else if ((ibgColor | 0x40) == 64) {
                    ++ansiColor;
                } else if ((ibgColor | 0x20) == 32) {
                    ansiColor += 2;
                } else if ((ibgColor | 0x60) == 96) {
                    ansiColor += 3;
                } else if ((ibgColor | 0x10) == 16) {
                    ansiColor += 4;
                } else if ((ibgColor | 0x50) == 80) {
                    ansiColor += 5;
                } else if ((ibgColor | 0x30) == 48) {
                    ansiColor += 6;
                } else if ((ibgColor | 0x70) == 112) {
                    ansiColor += 7;
                }
                this.bgColorString = ansiColor + decorators + "m";
            }
        }

        private String decoratorsString(int color, short bold) {
            boolean isBold = (color & bold) == bold;
            boolean isItalic = (color & 0x200) == 512;
            boolean isUnderline = (color & 0x400) == 1024;
            boolean isStrikethrough = (color & 0x800) == 2048;
            Object s = "";
            if (isBold) {
                s = (String)s + ";1";
            }
            if (isItalic) {
                s = (String)s + ";3";
            }
            if (isUnderline) {
                s = (String)s + ";4";
            }
            if (isStrikethrough) {
                s = (String)s + ";9";
            }
            return s;
        }

        int unsetDecorators(int color, int bold) {
            color = this.unsetBit(color, bold);
            color = this.unsetBit(color, 1024);
            color = this.unsetBit(color, 2048);
            color = this.unsetBit(color, 512);
            return color;
        }

        int unsetBit(int color, int bit) {
            return color & (0xFFFF ^ bit);
        }
    }
}

