/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.console.terminal;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.tools.console.terminal.DllLoaderException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class DllLoader {
    public static void loadLibrary(String libname) throws DllLoaderException {
        try {
            System.loadLibrary(libname);
        }
        catch (Error | Exception exception) {
            throw new DllLoaderException("Loading library '" + libname + "' failed.", exception);
        }
    }

    public static void load(String filename) throws DllLoaderException {
        try {
            System.load(new File(filename).getAbsolutePath());
        }
        catch (Error | Exception exception) {
            throw new DllLoaderException("Loading library '" + filename + "' failed.", exception);
        }
    }

    public static void loadFromJar(String filename) throws DllLoaderException {
        InputStream in = DllLoader.class.getResourceAsStream(filename);
        if (in == null) {
            throw new DllLoaderException("Loading library '" + filename + "' failed. Cause: library not found.");
        }
        try {
            String dllFileName = new File(filename).getName();
            String dllPath = DllLoader.getPathForDLL() + "/" + dllFileName;
            File dllFile = new File(dllPath);
            if (dllFile.exists()) {
                dllFile.delete();
            }
            if (!dllFile.exists()) {
                FileOutputStream out = new FileOutputStream(dllFile);
                FileIOUtils.copy(in, (OutputStream)out);
                ((OutputStream)out).close();
                in.close();
            }
            DllLoader.load(dllFile.getAbsolutePath());
        }
        catch (Error | Exception exception) {
            throw new DllLoaderException("Loading library '" + filename + "' failed.", exception);
        }
    }

    public static String getPathForDLL() {
        String path = System.getenv("TMP");
        if (path == null) {
            path = System.getenv("TEMP");
        }
        if (path == null) {
            path = ".";
        }
        return path;
    }
}

