/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.console.terminal;

import com.streamscape.tools.console.terminal.InputCharacter;
import com.streamscape.tools.console.terminal.ReadInterruptedException;
import com.streamscape.tools.console.terminal.Terminal;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

abstract class AbstractTerminal
implements Terminal {
    private NonBlockingReader nonBlockingReader = null;

    AbstractTerminal(boolean interruptable) {
        if (interruptable) {
            this.nonBlockingReader = new NonBlockingReader();
        }
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void destroy() {
    }

    @Override
    public InputCharacter read() {
        int code = this.readByte();
        return this.convertByte(code);
    }

    protected InputCharacter convertByte(int code) {
        try {
            return this.convertByteInterruptable(code, false);
        }
        catch (ReadInterruptedException exception) {
            return null;
        }
    }

    protected abstract InputCharacter convertByteInterruptable(int var1, boolean var2) throws ReadInterruptedException;

    @Override
    public InputCharacter readInterruptable() throws ReadInterruptedException {
        return this.readInterruptable(0L);
    }

    @Override
    public InputCharacter readInterruptable(long timeout) throws ReadInterruptedException {
        if (this.nonBlockingReader != null) {
            return this.convertByteInterruptable(this.nonBlockingReader.readByteInterruptable(timeout), true);
        }
        return this.convertByte(this.readByte());
    }

    @Override
    public int readByteInterruptable() throws ReadInterruptedException {
        return this.readByteInterruptable(0);
    }

    @Override
    public int readByteInterruptable(int timeout) throws ReadInterruptedException {
        int code = this.nonBlockingReader != null ? this.nonBlockingReader.readByteInterruptable(timeout) : this.readByte();
        return code;
    }

    @Override
    public void interrupt() {
        if (this.nonBlockingReader != null) {
            this.nonBlockingReader.interrupt();
        }
    }

    @Override
    public void setEncoding(Charset charset) throws UnsupportedEncodingException {
    }

    class NonBlockingReader
    implements Runnable {
        private final Object mutex = new Object();
        private int lastCharacter = -1;
        private boolean lastCharacterSet = false;
        private boolean needToRead = false;
        private boolean interrupted = false;
        private boolean stopped = false;

        NonBlockingReader() {
            Thread t = new Thread(this);
            t.setName("NonBlockingReaderThread");
            t.setDaemon(true);
            t.start();
        }

        synchronized int readByteInterruptable() throws ReadInterruptedException {
            return this.readByteInterruptable(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized int readByteInterruptable(long timeout) throws ReadInterruptedException {
            Object object;
            if (this.stopped) {
                throw new ReadInterruptedException("NonBlockingReader thread is not running.");
            }
            Object object2 = this.mutex;
            synchronized (object2) {
                this.interrupted = false;
            }
            object2 = this.mutex;
            synchronized (object2) {
                if (!this.lastCharacterSet) {
                    this.needToRead = true;
                    this.mutex.notify();
                }
            }
            long startTime = System.currentTimeMillis();
            while (!(this.interrupted || timeout > 0L && System.currentTimeMillis() - startTime > timeout)) {
                object = this.mutex;
                synchronized (object) {
                    if (this.lastCharacterSet) {
                        int c = this.lastCharacter;
                        this.lastCharacter = -1;
                        this.lastCharacterSet = false;
                        this.mutex.notify();
                        return c;
                    }
                    try {
                        if (timeout <= 0L) {
                            this.mutex.wait(500L);
                        } else {
                            long t = timeout - (System.currentTimeMillis() - startTime);
                            if (t > 0L) {
                                this.mutex.wait(t);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            object = this.mutex;
            synchronized (object) {
                this.mutex.notify();
            }
            if (this.interrupted) {
                throw new ReadInterruptedException("Read has been interrupted.");
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void interrupt() {
            Object object = this.mutex;
            synchronized (object) {
                this.interrupted = true;
                this.mutex.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.mutex;
            synchronized (object) {
                this.stopped = true;
                this.mutex.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopped) {
                while (!this.needToRead && !this.stopped) {
                    Object object = this.mutex;
                    synchronized (object) {
                        if (!this.needToRead && !this.stopped) {
                            try {
                                this.mutex.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (this.stopped) break;
                int c = AbstractTerminal.this.readByte();
                Object object = this.mutex;
                synchronized (object) {
                    this.lastCharacter = c;
                    this.lastCharacterSet = true;
                    this.needToRead = false;
                    this.mutex.notify();
                }
                while (this.lastCharacterSet && !this.stopped) {
                    object = this.mutex;
                    synchronized (object) {
                        if (this.lastCharacterSet && !this.stopped) {
                            try {
                                this.mutex.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
    }
}

