/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.console.terminal;

import com.streamscape.tools.console.terminal.Color;
import com.streamscape.tools.console.terminal.PrintStreamDecorator;
import java.io.PrintStream;

public abstract class AbstractColouredPrintStream
extends PrintStreamDecorator {
    protected Color color;

    public AbstractColouredPrintStream(PrintStream printStream, Color color) {
        super(printStream);
        this.color = color;
    }

    @Override
    protected void onPrint(String s) {
        if (this.color.isForegroundColorSet() && (this.color.getForegroundColor() & 0x800) == 2048) {
            for (char c : s.toCharArray()) {
                super.onPrint(c);
                if (Character.isWhitespace(c)) continue;
                super.onPrint("\u0336");
            }
        } else {
            super.onPrint(s);
        }
    }
}

