/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.console.autocompletion;

import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.PrefixTree;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.Suggestion;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.SyntaxSuggestion;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import com.streamscape.tools.console.autocompletion.AbstractCompleter;
import com.streamscape.tools.console.autocompletion.CompleterCondition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrefixTreeCompleter<T>
extends AbstractCompleter {
    private PrefixTree<T> tree;
    private Map<String, Integer> orderedValues;
    private SuggestionGroup suggestionGroup;

    public PrefixTreeCompleter() {
    }

    public PrefixTreeCompleter(PrefixTree<T> tree) {
        this.tree = tree;
    }

    public void setOrderedValues(List<String> values) {
        this.orderedValues = new HashMap<String, Integer>();
        for (int i = 0; i < values.size(); ++i) {
            this.orderedValues.put(values.get(i), i);
        }
    }

    public PrefixTreeCompleter setSuggestionGroup(SuggestionGroup suggestionGroup) {
        this.suggestionGroup = suggestionGroup;
        return this;
    }

    protected void setPrefixTree(PrefixTree<T> tree) {
        this.tree = tree;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DSLCompletion completeDsl(String command, final CompleterCondition condition) {
        if (this.tree == null) {
            return null;
        }
        PrefixTree.Node<T> tmpnode = this.tree.lookupNode(command);
        if (tmpnode == null && (tmpnode = this.tree.lookupNode(command.trim() + " ")) == null) {
            return null;
        }
        final PrefixTree.Node<T> node = tmpnode;
        PrefixTree.Node<T> completionNode = node.getCompletion();
        final DSLCompletion completion = new DSLCompletion();
        Object completionToken = null;
        if (completionNode != node) {
            if (condition != null) {
                if (completionNode.isDataNode() && condition.isGood(completionNode.getData())) {
                    completionToken = completionNode.getDefinitionUpTo(node);
                } else {
                    DataNodesConditionVisitor visitor = new DataNodesConditionVisitor(condition);
                    completionNode.accept(visitor);
                    if (!visitor.isConditionGood()) return null;
                    completionToken = completionNode.getDefinitionUpTo(node);
                }
            } else {
                completionToken = completionNode.getDefinitionUpTo(node);
            }
        } else if (completionNode.isDataNode()) {
            PrefixTree.Node<T> spaceChild;
            completionToken = "";
            if (completionNode.getChilds() != null && completionNode.getChilds().size() == 1 && (spaceChild = completionNode.lookupChild(' ', true)) != null) {
                completionNode = spaceChild;
                completionToken = " ";
            }
        }
        final String prefix = node.getDefinition();
        completionNode.accept(new PrefixTree.DataNodesVisitor<T>(){

            @Override
            public void onDataNode(PrefixTree.Node<T> dataNode) {
                if (node != dataNode && (condition == null || condition.isGood(dataNode.getData()))) {
                    String token = dataNode.getDefinitionUpTo(node);
                    completion.addSuggestion(PrefixTreeCompleter.this.buildSuggestionFor(dataNode, token, prefix));
                }
            }
        });
        if (completionToken != null) {
            if (this.isNeedSpaceAfter(completionNode) && (completion.getSuggestions().size() == 0 || completion.getSuggestions().size() == 1 && ((String)completionToken).equals(completion.getSuggestions().get(0).getDisplayStringFromOffset()))) {
                completionToken = (String)completionToken + " ";
                if (completion.getSuggestions().size() == 1) {
                    completion.getSuggestions().clear();
                }
            }
            completion.setCompletion(this.buildSuggestionFor(completionNode, (String)completionToken, prefix));
        }
        if (completion.getSuggestions().size() > 0 && completionNode.isDataNode()) {
            completionToken = completionNode.getDefinitionUpTo(node);
            completion.addSuggestion(this.buildSuggestionFor(completionNode, (String)completionToken, prefix));
        }
        if (this.orderedValues != null) {
            completion.order(this.orderedValues);
        }
        completion.checkAndCompress();
        completion.moveSingleSuggestionToCompletion();
        return completion;
    }

    private Suggestion buildSuggestionFor(PrefixTree.Node<?> dataNode, String token, String prefix) {
        if (prefix != null) {
            token = prefix + (String)token;
        }
        if (dataNode.getData() instanceof SyntaxSuggestion) {
            SyntaxSuggestion syntax = (SyntaxSuggestion)dataNode.getData();
            return new SyntaxSuggestion((String)token, syntax.getSyntax(), syntax.getGroup()).setOffset(prefix).compress();
        }
        if (dataNode.getData() instanceof TokenSuggestion) {
            return new TokenSuggestion((String)token, ((TokenSuggestion)dataNode.getData()).getGroup()).setOffset(prefix).compress();
        }
        if (dataNode.getData() instanceof SuggestionGroup) {
            return new TokenSuggestion((String)token, (SuggestionGroup)((Object)dataNode.getData())).setOffset(prefix).compress();
        }
        return new TokenSuggestion((String)token, this.suggestionGroup).setOffset(prefix).compress();
    }

    private boolean isNeedSpaceAfter(PrefixTree.Node<?> node) {
        return node.isDataNode() && node.getCharacter().charValue() != ' ' && (!(node.getData() instanceof AbstractDSLOperation) || !((AbstractDSLOperation)node.getData()).getDSLSyntax().isNoSpacesAfter());
    }

    static class DataNodesConditionVisitor<T>
    extends PrefixTree.DataNodesVisitor<T> {
        private CompleterCondition condition;
        private boolean conditionIsGood = false;

        DataNodesConditionVisitor(CompleterCondition condition) {
            this.condition = condition;
        }

        @Override
        public void onDataNode(PrefixTree.Node<T> node) {
            if (this.condition.isGood(node.getData())) {
                this.conditionIsGood = true;
            }
        }

        public boolean isConditionGood() {
            return this.conditionIsGood;
        }
    }
}

