/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.console.autocompletion;

import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import com.streamscape.tools.console.autocompletion.AbstractCompleter;
import com.streamscape.tools.console.autocompletion.Completer;
import com.streamscape.tools.console.autocompletion.CompleterCondition;
import com.streamscape.tools.lexer.BufferUtils;
import java.util.ArrayList;
import java.util.List;

public class CompoundCompleter
extends AbstractCompleter {
    protected List<Completer> completers = new ArrayList<Completer>();

    public void addCompleter(Completer completer) {
        this.completers.add(completer);
    }

    public boolean removeCompleter(Completer completer) {
        for (int i = 0; i < this.completers.size(); ++i) {
            if (this.completers.get(i) != completer) continue;
            this.completers.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public DSLCompletion completeDsl(String command, CompleterCondition condition) {
        if (this.completers.size() == 1) {
            return this.completers.get(0).completeDsl(command, condition);
        }
        DSLCompletion completion = null;
        for (Completer completer : this.completers) {
            completion = CompoundCompleter.mergeCompletions(command, completion, completer.completeDsl(command, condition));
        }
        return completion;
    }

    private static boolean noCompletionAndNoSuggestions(DSLCompletion completion) {
        return completion == null || completion.getCompletion() == null && (completion.getSuggestions() == null || completion.getSuggestions().size() == 0);
    }

    public static DSLCompletion mergeCompletions(String command, DSLCompletion first, DSLCompletion second) {
        if (CompoundCompleter.noCompletionAndNoSuggestions(first) && CompoundCompleter.noCompletionAndNoSuggestions(second)) {
            if (first != null && first.getException() != null) {
                return first;
            }
            if (second != null && second.getException() != null) {
                return second;
            }
        }
        if (CompoundCompleter.noCompletionAndNoSuggestions(first)) {
            first = null;
        }
        if (CompoundCompleter.noCompletionAndNoSuggestions(second)) {
            second = null;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        if (command != null) {
            String normalizedCommand = BufferUtils.normalizeCommand(command).toLowerCase();
            if (normalizedCommand.length() >= 4 && normalizedCommand.startsWith("help")) {
                command = normalizedCommand.substring(4);
            } else if (normalizedCommand.length() >= 1 && normalizedCommand.startsWith("?")) {
                command = normalizedCommand.substring(1);
            }
            if (normalizedCommand.startsWith("alter password ") && !normalizedCommand.equals("alter password ")) {
                return second;
            }
        }
        if (first.getCompletion() == null || second.getCompletion() == null) {
            CompoundCompleter.mergeSuggestions(second, first);
            first.checkAndCompress();
            return first;
        }
        StringBuilder commonBuilder = new StringBuilder();
        String prefix = "";
        String token1 = first.getCompletion().getTokenFromOffset();
        String token2 = second.getCompletion().getTokenFromOffset();
        for (int i = 0; token1 != null && token2 != null && i < token1.length() && i < token2.length() && token1.charAt(i) == token2.charAt(i); ++i) {
            commonBuilder.append(token1.charAt(i));
        }
        String t1 = first.getCompletion().getTokenBeforeOffset();
        String t2 = second.getCompletion().getTokenBeforeOffset();
        if (t1 != null && t1.equals(t2)) {
            prefix = t1;
        }
        DSLCompletion mergedCompletion = new DSLCompletion();
        if (commonBuilder.length() > 0) {
            mergedCompletion.setCompletion(new TokenSuggestion(prefix + commonBuilder.toString()).setOffset(prefix));
        }
        if (first.getSuggestions().size() == 0) {
            mergedCompletion.addSuggestion(first.getCompletion());
        }
        mergedCompletion.addSuggestions(first.getSuggestions());
        if (second.getSuggestions().size() == 0) {
            mergedCompletion.addSuggestion(second.getCompletion());
        }
        mergedCompletion.addSuggestions(second.getSuggestions());
        mergedCompletion.checkAndCompress();
        if (first.getSuggestions().size() == 0 && second.getSuggestions().size() == 0) {
            mergedCompletion.moveSingleSuggestionToCompletion();
        }
        return mergedCompletion;
    }

    private static void mergeSuggestions(DSLCompletion from, DSLCompletion to) {
        if (to.getCompletion() != null) {
            if (to.getSuggestions().size() == 0) {
                to.addSuggestion(to.getCompletion().trim());
            }
            to.setCompletion(null);
        }
        if (from.getCompletion() != null) {
            if (from.getSuggestions().size() == 0) {
                from.addSuggestion(from.getCompletion().trim());
            }
            from.setCompletion(null);
        }
        from.getSuggestions().forEach(to::addSuggestion);
    }
}

