/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.console;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.HelpSLResponse;
import com.streamscape.sdo.operation.Operation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.AbstractDSLProvider;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.UnsupportedRequestException;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.HelpDSLOperation;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Action;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.Predicate;
import com.streamscape.slex.lang.modifier.Subject;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.NumericParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.parameter.TextParameter;
import com.streamscape.tools.console.ConsoleConfiguration;
import com.streamscape.tools.console.NativeConsole;
import com.streamscape.tools.console.terminal.Color;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class NativeConsoleDSLSyntaxProvider
extends AbstractDSLProvider<NativeConsole> {
    NativeConsoleDSLSyntaxProvider(NativeConsole callable) {
        super("NativeConsoleDSLSyntaxProvider", callable, SuggestionGroup.CONSOLE_OPERATIONS);
        this.registerOperation(new ClearOperation());
        this.registerOperation(new SetMonochromeOperation());
        this.registerOperation(new HelpSlangOperation());
        this.registerOperation(new HistoryOperation());
        this.registerOperation(new ClearHistoryOperation());
        this.registerOperation(new SetHistoryLimitOperation());
        this.registerOperation(new GetHistoryLimitOperation());
        this.registerOperation(new RecallOperation());
        this.registerOperation(new SetDelimiterOperation());
        this.registerOperation(new GetDelimiterOperation());
        this.registerOperation(new HelpConsoleOperation());
        this.registerOperation(new SetColorOperation());
        this.activate(callable);
    }

    static class ClearOperation
    extends AbstractDSLOperation<NativeConsole> {
        private static final String NAME = "cls";

        ClearOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction(NAME);
            this.syntax.setDescription("Clears the screen.");
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            ((NativeConsole)this.callable).clear();
            return new SLResponse();
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition();
        }

        static class Definition
        extends AbstractSLStatement {
            Definition() {
                super(ClearOperation.NAME);
            }
        }
    }

    public static class SetMonochromeOperation
    extends AbstractDSLOperation<NativeConsole> {
        public static final String NAME = "set monochrome";

        SetMonochromeOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction(NAME);
            this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier().setSyntaxHint(SyntaxHint.SPACE)).setRequired(false)).addModifier(new Modifier("TRUE"))).addModifier(new Modifier("FALSE")));
            this.syntax.setDescription("Set monochrome console.");
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            ConsoleConfiguration.instance().setMonochrome(((Definition)statement).isMonochrome);
            return new SLResponse();
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            if (statement.getModifier("FALSE").isPresent()) {
                return new Definition(false);
            }
            return new Definition(true);
        }

        static class Definition
        extends AbstractSLStatement {
            boolean isMonochrome;

            Definition(boolean isMonochrome) {
                super(SetMonochromeOperation.NAME);
                this.isMonochrome = isMonochrome;
            }
        }
    }

    static class HelpSlangOperation
    extends AbstractDSLOperation<NativeConsole> {
        private static final String NAME = "help slang";

        HelpSlangOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction(NAME);
            this.syntax.setAlias("? slang");
            this.syntax.setDescription("Displays help on SLANG tool.");
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            StringBuilder builder = new StringBuilder();
            builder.append("\n");
            builder.append("SLANG CONSOLE COMMANDS\n");
            builder.append("======================\n\n");
            builder.append("Special keys in commands editor\n");
            builder.append("-------------------------------\n\n");
            builder.append(" up/down arrows - if input is empty or previous command from not changed not changed - history navigation\n");
            builder.append("                  otherwise - multiline command navigation\n");
            builder.append(" ctrl-C         - terinates SLANG applicaion\n");
            builder.append(" ctrl-K         - interrupts current command execution\n");
            builder.append(" ESC            - clears current line\n");
            builder.append(" ctrl-backspace - clears last word\n");
            builder.append(" ctrl-left      - moves cursor to the previous word\n");
            builder.append(" ctrl-right     - moves cursor to the next word\n");
            builder.append(" home           - moves cursor to the begin\n");
            builder.append(" end            - moves cursor to the end\n");
            builder.append(" del            - removes symbol on the current position\n");
            builder.append(" tab            - completes current command\n                  if command has only one completion then this completion is displayed\n                  if there are more then one completion then all possible completions displayed above command line\n                  if <tab> pressed on the completed command then slang tries to make completion for the first command parameter\n                  for example: start acceptor <tab>, all stopped acceptors will be displayed\n");
            builder.append("\n\n");
            builder.append("Special keys in --More--\n");
            builder.append("------------------------\n\n");
            builder.append(" q              - exit from --More--\n");
            builder.append(" space/tab      - next screen\n");
            builder.append("\n\n");
            builder.append("Special commands\n");
            builder.append("----------------\n\n");
            builder.append(" history                - Displays commands history.\n");
            builder.append(" clear history          - Clears commands history.\n");
            builder.append(" set history limit      - Sets commands history limit.\n");
            builder.append(" get history limit      - Displays commands history limit.\n");
            builder.append(" r:                     - Recalls command from history.\n");
            builder.append(" cls                    - Clears the screen.\n");
            builder.append(" set monochrome         - Disables colours.\n                          Also colours can be disabled by -nocolor option of command line.\n");
            builder.append(" set color              - Sets the color for a specific displayed entity (error, warning etc).\n");
            builder.append(" set delimiter          - Sets line delimiter.\n");
            builder.append(" get delimiter          - Displays line delimiter.\n");
            builder.append(" help slang             - Displays this help.\n");
            builder.append(" help console           - Displays all console commands.\n");
            builder.append(" help console <command> - Displays help for console command.\n");
            builder.append(" help                   - Displays help in the current context.\n");
            return new SLResponse(builder.toString());
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition();
        }

        static class Definition
        extends AbstractSLStatement {
            Definition() {
                super(HelpSlangOperation.NAME);
            }
        }
    }

    static class HistoryOperation
    extends AbstractDSLOperation<NativeConsole> {
        private static final String NAME = "history";

        HistoryOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction(NAME);
            this.syntax.setDescription("Displays commands history.");
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            StringBuilder builder = new StringBuilder();
            int index = 0;
            Iterator<String> iterator = ((NativeConsole)this.callable).getCommandsHistory().getHistory().iterator();
            while (iterator.hasNext()) {
                builder.append(index++).append(": ").append(iterator.next());
                if (!iterator.hasNext()) continue;
                builder.append("\n");
            }
            return new SLResponse(builder.toString());
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition();
        }

        static class Definition
        extends AbstractSLStatement {
            Definition() {
                super(HistoryOperation.NAME);
            }
        }
    }

    static class ClearHistoryOperation
    extends AbstractDSLOperation<NativeConsole> {
        private static final String NAME = "clear history";

        ClearHistoryOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction(NAME);
            this.syntax.setDescription("Clears command history.");
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            ((NativeConsole)this.callable).getCommandsHistory().clear();
            return new SLResponse();
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition();
        }

        static class Definition
        extends AbstractSLStatement {
            Definition() {
                super(ClearHistoryOperation.NAME);
            }
        }
    }

    static class SetHistoryLimitOperation
    extends AbstractDSLOperation<NativeConsole> {
        private static final String NAME = "set history limit";

        SetHistoryLimitOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction(NAME).addActionParameter(new NumericParameter("limit"));
            this.syntax.setDescription("Sets commands history limit.");
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            ((NativeConsole)this.callable).getCommandsHistory().setLimitCount(((Definition)statement).limit);
            return new SLResponse();
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(Integer.parseInt(statement.getParameter("limit").getValue()));
        }

        static class Definition
        extends AbstractSLStatement {
            int limit;

            Definition(int limit) {
                super(SetHistoryLimitOperation.NAME);
                this.limit = limit;
            }
        }
    }

    static class GetHistoryLimitOperation
    extends AbstractDSLOperation<NativeConsole> {
        private static final String NAME = "get history limit";

        GetHistoryLimitOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction(NAME);
            this.syntax.setDescription("Gets commands history limit.");
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            return new SLResponse(Integer.toString(((NativeConsole)this.callable).getCommandsHistory().getLimitCount()));
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition();
        }

        static class Definition
        extends AbstractSLStatement {
            Definition() {
                super(GetHistoryLimitOperation.NAME);
            }
        }
    }

    static class RecallOperation
    extends AbstractDSLOperation<NativeConsole> {
        private static final String NAME = "r:";

        RecallOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction((Action)new Action(NAME).setNoSpacesAfter());
            this.syntax.addActionParameter((SyntaxParameter)((ExpressionParameter)((ExpressionParameter)new ExpressionParameter("CommandNumber or Command from history").setName("Command")).setIgnoreQuotes(true).setEndDelimiterToCommandEnd()).setCompletionAdviser(new CommandsAdviser()));
            this.syntax.setDescription("Recalls operation from history with specified number.");
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            Definition definition = (Definition)statement;
            String command = definition.command;
            try {
                int index = Integer.parseInt(definition.command);
                command = ((NativeConsole)this.callable).getCommandsHistory().getCommand(index);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (command != null) {
                return new RecallResponse(command, true);
            }
            return new RecallResponse("Wrong command number: " + definition.command, false);
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition(statement.getParameter("Command").getValue());
        }

        static class CommandsAdviser
        implements CompletionAdviser<NativeConsole> {
            CommandsAdviser() {
            }

            @Override
            public List<String> getCompletions(String script, String processedScript, NativeConsole callable, MFSession session) {
                return callable.getCommandsHistory().getHistory();
            }

            @Override
            public boolean isCaseSensitive() {
                return true;
            }
        }

        static class Definition
        extends AbstractSLStatement {
            String command;

            Definition(String command) {
                super(RecallOperation.NAME);
                this.command = command;
            }
        }
    }

    static class SetDelimiterOperation
    extends AbstractDSLOperation<NativeConsole> {
        private static final String NAME = "set delimiter";

        SetDelimiterOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("SET DELIMITER").addActionParameter((SyntaxParameter)new ExpressionParameter("delimiter").setRequired(false));
            this.syntax.setDescription("Sets lines delimiter.");
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            if (!statement.getParameter("delimiter").isPresent()) {
                return new Definition("\n");
            }
            return new Definition(statement.getParameter("delimiter").getValue().trim());
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            ((NativeConsole)this.callable).setDelimiter(((Definition)statement).delimiter);
            return new SLResponse();
        }

        static class Definition
        extends AbstractSLStatement {
            private String delimiter;

            Definition(String delimiter) {
                super(SetDelimiterOperation.NAME);
                this.delimiter = delimiter;
            }
        }
    }

    static class GetDelimiterOperation
    extends AbstractDSLOperation<NativeConsole> {
        private static final String NAME = "get delimiter";

        GetDelimiterOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("GET DELIMITER");
            this.syntax.setDescription("Shows lines delimiter.");
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            return new SLResponse("Delimiter: '" + (((NativeConsole)this.callable).getDelimiter().equals("\n") ? "new line" : ((NativeConsole)this.callable).getDelimiter()) + "'");
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            return new Definition();
        }

        static class Definition
        extends AbstractSLStatement {
            Definition() {
                super(GetDelimiterOperation.NAME);
            }
        }
    }

    static class HelpConsoleOperation
    extends AbstractDSLOperation<NativeConsole> {
        private static final String NAME = "help console";

        HelpConsoleOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("HELP CONSOLE");
            this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("").addParameter((SyntaxParameter)new TextParameter("operation").setRequired(false))).setSyntaxHint(SyntaxHint.SPACE));
            this.syntax.setAlias("? console");
            this.syntax.addCompletionCommand(NAME);
            this.syntax.setDescription("help console             - Returns a list of console operations.\nhelp console <operation> - Returns a syntax and description of the specified console operation.");
            this.syntax.setExamples("help console\nhelp console history\n??");
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            Definition definition = (Definition)statement;
            if (definition.operation != null) {
                Operation operation = this.provider.getVisibleOperation(definition.operation, session);
                if (operation != null) {
                    return HelpDSLOperation.internalInvokeHelpForOperation(definition.operation, operation, session);
                }
                Set<String> operations = this.provider.listVisibleOperations(session, definition.operation);
                if (!operations.isEmpty()) {
                    return new HelpSLResponse().setConsoleOperations(operations);
                }
                throw new UnsupportedRequestException("ERROR: Unsupported language request '" + definition.operation + "'.");
            }
            Set<String> operations = this.provider.listVisibleOperations(session, null);
            if (!operations.isEmpty()) {
                return new SLResponse(operations.stream().map(name -> name + "\n").collect(Collectors.joining()), true);
            }
            return new SLResponse("There are no operations.");
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            if (statement.getParameter("operation").isPresent()) {
                return new Definition(statement.getParameter("operation").getValue());
            }
            return new Definition();
        }

        @Override
        protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
            completions.addAll(this.provider.listVisibleOperations(session, null));
        }

        static class Definition
        extends AbstractSLStatement {
            String operation = null;

            Definition() {
                this(null);
            }

            Definition(String operation) {
                super(HelpConsoleOperation.NAME);
                this.operation = operation;
            }
        }
    }

    static class SetColorOperation
    extends AbstractDSLOperation<NativeConsole> {
        private static final String NAME = "set color";

        SetColorOperation() {
            this.createDSLSyntax(NAME);
            this.syntax.setAction("SET");
            this.syntax.setPredicate(new Predicate("").addPossibleValues("RESPONSE", "ERROR", "WARNING", "COMPLETION", "BOLD", "ITALIC", "UNDERLINE"));
            this.syntax.setSubject((Subject)new Subject("COLOR").addParameter(new EnumParameter("Color", Definition.Color.class)));
            this.syntax.addModifier((AbstractModifier)new Modifier("INTENSITY", false).setSyntaxHintSpace());
            this.syntax.setDescription("Sets the color for the specified displayed entity.");
        }

        @Override
        public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
            Definition.StreamType type;
            String typeModifierValue = statement.getModifier("ACTION_PREDICATE").getToken();
            if (typeModifierValue.equalsIgnoreCase("RESPONSE")) {
                type = Definition.StreamType.RESPONSE;
            } else if (typeModifierValue.equalsIgnoreCase("ERROR")) {
                type = Definition.StreamType.ERROR;
            } else if (typeModifierValue.equalsIgnoreCase("WARNING")) {
                type = Definition.StreamType.WARNING;
            } else if (typeModifierValue.equalsIgnoreCase("COMPLETION")) {
                type = Definition.StreamType.COMPLETION;
            } else if (typeModifierValue.equalsIgnoreCase("BOLD")) {
                type = Definition.StreamType.HTML_TAG_B;
            } else if (typeModifierValue.equalsIgnoreCase("ITALIC")) {
                type = Definition.StreamType.HTML_TAG_I;
            } else if (typeModifierValue.equalsIgnoreCase("UNDERLINE")) {
                type = Definition.StreamType.HTML_TAG_U;
            } else {
                throw new ParsingException("Invalid StreamType!");
            }
            Definition.Color color = Definition.Color.valueOf(statement.getParameter("Color").getValue().toUpperCase());
            boolean isIntensity = statement.existsModifier("INTENSITY") && statement.getModifier("INTENSITY").isPresent();
            return new Definition(type, color, isIntensity);
        }

        @Override
        public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
            Definition definition = (Definition)statement;
            int iColor = definition.color.convertToTerminalFgColor();
            if (definition.isIntensity) {
                iColor |= 8;
            }
            Color terminalColor = new Color(iColor, -1);
            switch (definition.streamType.ordinal()) {
                case 0: {
                    ConsoleConfiguration.instance().setResponseColor(terminalColor);
                    break;
                }
                case 1: {
                    ConsoleConfiguration.instance().setErrorColor(terminalColor);
                    break;
                }
                case 2: {
                    ConsoleConfiguration.instance().setWarningColor(terminalColor);
                    break;
                }
                case 3: {
                    ConsoleConfiguration.instance().setCompletionColor(terminalColor);
                    break;
                }
                case 4: {
                    ConsoleConfiguration.instance().setHtmlTagBColor(terminalColor);
                    break;
                }
                case 5: {
                    ConsoleConfiguration.instance().setHtmlTagIColor(terminalColor);
                    break;
                }
                case 6: {
                    ConsoleConfiguration.instance().setHtmlTagUColor(terminalColor);
                }
            }
            return new SLResponse();
        }

        static class Definition
        extends AbstractSLStatement {
            StreamType streamType;
            Color color;
            boolean isIntensity;

            Definition(StreamType streamType, Color color, boolean isIntensity) {
                super(SetColorOperation.NAME);
                this.streamType = streamType;
                this.color = color;
                this.isIntensity = isIntensity;
            }

            static enum StreamType {
                RESPONSE,
                ERROR,
                WARNING,
                COMPLETION,
                HTML_TAG_B,
                HTML_TAG_I,
                HTML_TAG_U;

            }

            static enum Color {
                BLACK,
                BLUE,
                GREEN,
                RED,
                YELLOW,
                MAGENTA,
                CYAN,
                WHITE,
                GRAY;


                int convertToTerminalFgColor() {
                    switch (this.ordinal()) {
                        case 0: {
                            return 0;
                        }
                        case 1: {
                            return 1;
                        }
                        case 2: {
                            return 2;
                        }
                        case 3: {
                            return 4;
                        }
                        case 4: {
                            return 6;
                        }
                        case 5: {
                            return 5;
                        }
                        case 6: {
                            return 3;
                        }
                        case 7: {
                            return 7;
                        }
                        case 8: {
                            return 8;
                        }
                    }
                    return 0;
                }
            }
        }
    }

    public static class RecallResponse
    extends SLResponse {
        public RecallResponse(String text, boolean isOK) {
            super(text, isOK);
        }
    }
}

