/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.console;

import com.streamscape.omf.java.Utils;
import com.streamscape.sdo.operation.HelpSLResponse;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowSetPrinter;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.UnsupportedRequestException;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.Suggestion;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.SuggestionType;
import com.streamscape.slex.lang.completion.SyntaxSuggestion;
import com.streamscape.tools.console.CommandReader;
import com.streamscape.tools.console.CommandsHistory;
import com.streamscape.tools.console.ConsoleConfiguration;
import com.streamscape.tools.console.InterruptableStream;
import com.streamscape.tools.console.MultilineCommandReader;
import com.streamscape.tools.console.NativeConsoleDSLSyntaxProvider;
import com.streamscape.tools.console.PasswordReader;
import com.streamscape.tools.console.autocompletion.AbstractAutoCompletionConsole;
import com.streamscape.tools.console.terminal.Color;
import com.streamscape.tools.console.terminal.InputCharacter;
import com.streamscape.tools.console.terminal.Keys;
import com.streamscape.tools.console.terminal.PrintStreamDecorator;
import com.streamscape.tools.console.terminal.ReadInterruptedException;
import com.streamscape.tools.console.terminal.Terminal;
import com.streamscape.tools.parser.ParserPositionalException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.StringTokenizer;

public class NativeConsole
extends AbstractAutoCompletionConsole
implements SLCallable {
    private Terminal terminal;
    private CommandsHistory<String> history;
    private NativeConsoleDSLSyntaxProvider internalCommandsProvider;
    private String commandToRecall;
    private Queue<InputCharacter> notProcessedCharacters = new ArrayDeque<InputCharacter>();

    public NativeConsole(Terminal terminal) {
        super(terminal.getPrintStream());
        this.terminal = terminal;
        this.history = ConsoleConfiguration.instance().getCommandsHistory();
        this.history.resetIterator();
        this.internalCommandsProvider = new NativeConsoleDSLSyntaxProvider(this);
        this.addCompleter(this.internalCommandsProvider);
    }

    @Override
    public void destroy() {
        this.terminal.destroy();
    }

    @Override
    public String readCommand(String delimiter) throws ReadInterruptedException {
        return this.readCommand(delimiter, true);
    }

    protected String readCommand(String delimiter, boolean addToHistory) throws ReadInterruptedException {
        MultilineCommandReader command = new MultilineCommandReader(this.terminal);
        String globalDelimiter = ConsoleConfiguration.instance().getDelimiter();
        while (this.readCommand(command, delimiter, true)) {
            String commandWithDelimiter = command.toStringWithDelimiter();
            String commandWithoutDelimiter = command.toStringWithoutDelimiter(delimiter);
            if (this.isCommand(command, "set delimiter", true)) {
                commandWithoutDelimiter = commandWithDelimiter;
            }
            command.reset();
            if (commandWithoutDelimiter == null || commandWithoutDelimiter.trim().length() == 0) continue;
            if (this.isLocalConsoleCommand(commandWithoutDelimiter, commandWithDelimiter)) {
                int pos;
                if (this.commandToRecall == null) {
                    if (globalDelimiter.equals(ConsoleConfiguration.instance().getDelimiter())) continue;
                    globalDelimiter = delimiter = ConsoleConfiguration.instance().getDelimiter();
                    continue;
                }
                commandWithoutDelimiter = commandWithDelimiter = this.commandToRecall;
                this.commandToRecall = null;
                if (commandWithoutDelimiter.endsWith(delimiter) && (pos = commandWithoutDelimiter.length() - delimiter.length()) > 0) {
                    commandWithoutDelimiter = commandWithoutDelimiter.substring(0, pos);
                }
                this.getPrintStream().println(this.getPrompt() + commandWithDelimiter);
                if (this.isLocalConsoleCommand(commandWithoutDelimiter, commandWithDelimiter)) continue;
            }
            if (addToHistory) {
                this.history.addCommand(commandWithDelimiter);
            }
            return commandWithoutDelimiter;
        }
        return null;
    }

    boolean isLocalConsoleCommand(String commandWithoutDelimiter, String commandWithDelimiter) {
        if (commandWithoutDelimiter == null) {
            return false;
        }
        try {
            DSLStatement statement = this.internalCommandsProvider.parseDsl(commandWithoutDelimiter, null);
            if (statement != null) {
                SLResponse response = this.internalCommandsProvider.invoke(statement, null);
                if (response.getException() instanceof UnsupportedRequestException) {
                    throw (UnsupportedRequestException)response.getException();
                }
                if (response instanceof NativeConsoleDSLSyntaxProvider.RecallResponse) {
                    if (response.isOK()) {
                        this.commandToRecall = response.getText();
                    } else {
                        this.getErrorPrintStream().println();
                        this.printWithTags(this.getErrorPrintStream(), response.getText());
                        this.getErrorPrintStream().println();
                    }
                } else {
                    if (!commandWithoutDelimiter.trim().equalsIgnoreCase("history")) {
                        this.history.addCommand(commandWithDelimiter);
                    }
                    if (response != null && response.isOK()) {
                        PrintStream printStream = this.getPrintStreamLess(ConsoleConfiguration.instance().getResponseColor());
                        if (response.getText() != null) {
                            printStream.println();
                            this.printWithTags(printStream, response.getText());
                            printStream.println("\n");
                        } else if (response instanceof HelpSLResponse) {
                            if ((response = ((HelpSLResponse)response).convertToUserResponse()).getRowSet() != null) {
                                printStream.println();
                                RowSetPrinter rowSetPrinter = new RowSetPrinter();
                                rowSetPrinter.setPrintStream(printStream);
                                rowSetPrinter.print(response.getRowSet());
                                printStream.println();
                            }
                        } else if (!statement.getAction().getToken().equalsIgnoreCase("cls")) {
                            printStream.println("\nOK\n");
                        }
                    }
                }
                return true;
            }
        }
        catch (ParsingException exception) {
            this.getErrorPrintStream().println();
            this.printWithTags(this.getErrorPrintStream(), exception.getMessage());
            this.getErrorPrintStream().println();
            this.history.addCommand(commandWithDelimiter);
            return true;
        }
        catch (UnsupportedRequestException exception) {
            this.getErrorPrintStream().println();
            this.getErrorPrintStream().println(exception.getMessage());
            this.getErrorPrintStream().println();
            this.history.addCommand(commandWithDelimiter);
            return true;
        }
        catch (Exception exception) {
            this.history.addCommand(commandWithDelimiter);
            return true;
        }
        return false;
    }

    @Override
    public SLResponse invokeConsoleCommand(String command) {
        try {
            DSLStatement statement = this.internalCommandsProvider.parseDsl(command, null);
            if (statement != null) {
                return this.internalCommandsProvider.invoke(statement, null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    protected void clear() {
        this.terminal.clear();
    }

    public CommandsHistory<String> getCommandsHistory() {
        return this.history;
    }

    protected boolean readCommand(CommandReader command, String delimiter, boolean withTabAndHistory) throws ReadInterruptedException {
        InputCharacter c;
        boolean needToResetHistory = false;
        this.getPrintStream().print(this.getPrompt());
        while ((c = this.readInterruptable()) != null) {
            String h;
            if (!c.isSpecialCharacter()) {
                if (c.getCode() == 13) {
                    if (!this.isCommand(command, "set delimiter", true) && !this.isCommand(command, "get delimiter", false) && !command.newline(this.getPrompt1(), delimiter)) continue;
                    command.ctrlend();
                    this.getPrintStream().println();
                    if (!needToResetHistory) break;
                    this.history.resetIterator();
                    break;
                }
                command.append(this.getPrompt(), c.getCharacter());
                needToResetHistory = true;
                continue;
            }
            if (c.getSpecialKey() == Keys.CTRL_C) {
                return false;
            }
            if (c.getSpecialKey() == Keys.ESCAPE) {
                command.clearCommandLastLine(this.getPrompt());
                command.reset();
                this.history.storeCurrentElement();
                continue;
            }
            if (c.getSpecialKey() == Keys.BACKSPACE) {
                command.backspace(this.getPrompt1());
                continue;
            }
            if (c.getSpecialKey() == Keys.CTRL_BACKSPACE) {
                command.ctrlbackspace();
                continue;
            }
            if (c.getSpecialKey() == Keys.LEFT) {
                command.back(this.getPrompt(), this.getPrompt1());
                continue;
            }
            if (c.getSpecialKey() == Keys.CTRL_LEFT) {
                command.ctrlback(this.getPrompt(), this.getPrompt1());
                continue;
            }
            if (c.getSpecialKey() == Keys.RIGHT) {
                command.forward(this.getPrompt(), this.getPrompt1());
                continue;
            }
            if (c.getSpecialKey() == Keys.CTRL_RIGHT) {
                command.ctrlforward(this.getPrompt(), this.getPrompt1());
                continue;
            }
            if (c.getSpecialKey() == Keys.CTRL_HOME || c.getSpecialKey() == Keys.HOME) {
                command.ctrlhome();
                continue;
            }
            if (c.getSpecialKey() == Keys.CTRL_END || c.getSpecialKey() == Keys.END) {
                command.ctrlend();
                continue;
            }
            if (c.getSpecialKey() == Keys.DEL) {
                command.del();
                continue;
            }
            if (c.getSpecialKey() == Keys.TAB && withTabAndHistory) {
                DSLCompletion completion = this.completeDsl(command.getToCurrentPosition());
                if (completion == null) continue;
                if (completion.getException() != null) {
                    command.clearCommandTillTheEnd(this.getPrompt());
                    this.getPrintStream().println();
                    this.getPrintStream().println();
                    PrintStream errorStream = this.getPrintStream(ConsoleConfiguration.instance().getErrorColor());
                    if (completion.getException() instanceof ParserPositionalException) {
                        if (((ParserPositionalException)((Object)completion.getException())).getLineNumber() > 0) {
                            errorStream.print(((ParserPositionalException)((Object)completion.getException())).getLineAndPositionMessage());
                        }
                        this.printWithTags(errorStream, ((ParserPositionalException)((Object)completion.getException())).getErrorMessage());
                    } else {
                        this.printWithTags(errorStream, Utils.formatExceptionWithUnrepeatedCauses(completion.getException(), "\n"));
                    }
                    this.getPrintStream().println();
                    this.getPrintStream().println();
                    command.display(this.getPrompt(), this.getPrompt1());
                    continue;
                }
                if (completion.getCompletion() != null) {
                    String completeToken = completion.getCompletion().getTokenFromOffset();
                    if (completeToken != null && completeToken.length() > 0) {
                        command.append(this.getPrompt1(), completeToken);
                    }
                    if (completeToken != null && completeToken.length() != 0 && completion.getCompletion().asSequence().get(0).getType() == SuggestionType.TOKEN) continue;
                    command.clearCommandTillTheEnd(this.getPrompt());
                    this.getPrintStream().println();
                    this.getPrintStream().println();
                    PrintStream lessStream = this.getPrintStreamLess(ConsoleConfiguration.instance().getCompletionColor());
                    this.printWithTags(lessStream, completion.getCompletion().getDisplayString());
                    lessStream.println();
                    lessStream.println();
                    this.printDescriptionSamples(lessStream, completion.getCompletion(), 0);
                    command.display(this.getPrompt(), this.getPrompt1());
                    continue;
                }
                this.printSuggestions(completion, command);
                continue;
            }
            if (c.getSpecialKey() == Keys.UP && withTabAndHistory) {
                if (!command.isPositionChanged()) {
                    h = this.history.previousCommand();
                    if (h == null) continue;
                    if (this.history.getLastCommand() == null) {
                        this.history.setLastCommand(command.toStringWithDelimiter());
                    }
                    command.clearCommandLastLine(this.getPrompt());
                    command.append(this.getPrompt1(), h);
                    command.positionChanged(false);
                    continue;
                }
                command.altup(this.getPrompt(), this.getPrompt1());
                continue;
            }
            if (c.getSpecialKey() == Keys.DOWN && withTabAndHistory) {
                if (!command.isPositionChanged()) {
                    h = this.history.nextCommand();
                    if (h == null) continue;
                    command.clearCommandLastLine(this.getPrompt());
                    command.append(this.getPrompt1(), h);
                    command.positionChanged(false);
                    continue;
                }
                command.altdown(this.getPrompt(), this.getPrompt1());
                continue;
            }
            if (c.getSpecialKey() == Keys.ALT_UP && withTabAndHistory) {
                command.altup(this.getPrompt(), this.getPrompt1());
                continue;
            }
            if (c.getSpecialKey() == Keys.ALT_DOWN && withTabAndHistory) {
                command.altdown(this.getPrompt(), this.getPrompt1());
                continue;
            }
            if (c.getSpecialKey() == Keys.PAGEUP && withTabAndHistory || c.getSpecialKey() != Keys.PAGEDOWN || !withTabAndHistory) continue;
        }
        if (c == null) {
            System.out.println("\nERROR: Reading from terminal failed.");
            return false;
        }
        return true;
    }

    private InputCharacter readInterruptable() throws ReadInterruptedException {
        if (this.notProcessedCharacters.size() > 0) {
            return this.notProcessedCharacters.poll();
        }
        return this.terminal.readInterruptable();
    }

    private void printDescriptionSamples(PrintStream stream, Suggestion suggestion, int indent) {
        boolean printed = false;
        if (suggestion.getDescription() != null && suggestion.getDescription().length() > 0) {
            stream.print(this.buildIndent(indent));
            stream.println(this.indent(suggestion.getDescription(), indent));
            printed = true;
        }
        if (suggestion.getSamples() != null && suggestion.getSamples().size() > 0) {
            stream.println();
            stream.print(this.buildIndent(indent));
            stream.println("Samples:");
            int samplesIndent = indent + 3;
            for (String sample : suggestion.getSamples()) {
                stream.print(this.buildIndent(samplesIndent));
                stream.println(this.indent(sample, samplesIndent + 1));
            }
            printed = true;
        }
        if (printed) {
            stream.println();
        }
    }

    private void printSuggestions(DSLCompletion completion, CommandReader command) {
        if (completion.getSuggestions().size() == 0) {
            return;
        }
        command.clearCommandTillTheEnd(this.getPrompt());
        HashMap<SuggestionGroup, List<Suggestion>> groups = new HashMap<SuggestionGroup, List<Suggestion>>();
        for (Suggestion suggestion : completion.getSuggestions()) {
            SuggestionGroup group = suggestion.asSequence().get(0).getGroup();
            ArrayList<Suggestion> seq = (ArrayList<Suggestion>)groups.get((Object)group);
            if (seq == null) {
                seq = new ArrayList<Suggestion>();
                groups.put(group, seq);
            }
            seq.add(suggestion);
        }
        this.getPrintStream().println();
        this.getPrintStream().println();
        PrintStream lessStream = this.getPrintStreamLess(ConsoleConfiguration.instance().getCompletionColor());
        ArrayList<SuggestionGroup> groupsOrder = new ArrayList<SuggestionGroup>(Arrays.asList(SuggestionGroup.RUNTIME_OPERATION, SuggestionGroup.SERVICE_OPERATION, SuggestionGroup.DATASPACE_OPERATION, SuggestionGroup.EVENT_PROPERTY, SuggestionGroup.ELEMENT, SuggestionGroup.METHOD, SuggestionGroup.COLLECTION, SuggestionGroup.FUNCTION_UNIT, SuggestionGroup.VARIABLE, SuggestionGroup.ROUTINE, SuggestionGroup.FUNCTION, SuggestionGroup.OPERATION));
        if (groups.containsKey((Object)SuggestionGroup.DATASPACE_OPERATION) && !groups.containsKey((Object)SuggestionGroup.SERVICE_OPERATION)) {
            groupsOrder.remove((Object)SuggestionGroup.OPERATION);
            groupsOrder.add(0, SuggestionGroup.OPERATION);
        }
        boolean nedNewLine = false;
        for (SuggestionGroup group : groupsOrder) {
            nedNewLine = this.printSuggestions(lessStream, completion, group, groups, nedNewLine);
        }
        List noName = (List)groups.remove(null);
        for (Map.Entry entry : groups.entrySet()) {
            nedNewLine = this.printSuggestions(lessStream, completion, (SuggestionGroup)((Object)entry.getKey()), (List)entry.getValue(), nedNewLine);
        }
        nedNewLine = this.printSuggestions(lessStream, completion, null, noName, nedNewLine);
        lessStream.println();
        command.display(this.getPrompt(), this.getPrompt1());
    }

    private boolean printSuggestions(PrintStream stream, DSLCompletion completion, SuggestionGroup groupName, Map<SuggestionGroup, List<Suggestion>> groups, boolean needNewLine) {
        List<Suggestion> group = groups.remove((Object)groupName);
        if (group != null) {
            needNewLine = this.printSuggestions(stream, completion, groupName, group, needNewLine);
        }
        return needNewLine;
    }

    private boolean printSuggestions(PrintStream stream, DSLCompletion completion, SuggestionGroup name, List<Suggestion> suggestions, boolean needNewLine) {
        if (suggestions == null) {
            return needNewLine;
        }
        if (suggestions.size() > 0) {
            if (needNewLine) {
                stream.println();
            }
            if (name != null) {
                stream.print("  +-- ");
                stream.print(name.getGroupName());
                stream.println(" ---");
                stream.println("     |");
            }
            needNewLine = true;
        }
        for (Suggestion suggestion : suggestions) {
            int indent = this.print(stream, "  ");
            if (name != null) {
                indent += this.print(stream, "   +- ");
            }
            String displayString = suggestion.getDisplayString();
            if (suggestion instanceof SyntaxSuggestion && suggestions.size() > 0 && name != null) {
                displayString = displayString.replace("\n", "");
            }
            this.printWithTags(stream, this.indent(displayString, indent));
            stream.println();
            this.printDescriptionSamples(stream, suggestion, indent);
        }
        return needNewLine;
    }

    private int print(PrintStream stream, String s) {
        stream.print(s);
        return s.length();
    }

    private String indent(String s, int indent) {
        int newLine;
        if (indent == 0 || s.indexOf(10) == -1) {
            return s;
        }
        String sindent = this.buildIndent(indent);
        StringBuilder builder = new StringBuilder();
        int pos = 0;
        do {
            newLine = (newLine = s.indexOf(10, pos)) == -1 ? s.length() : ++newLine;
            if (builder.length() > 0) {
                builder.append(sindent);
            }
            builder.append(s.substring(pos, newLine));
        } while ((pos = newLine) != s.length());
        return builder.toString();
    }

    private String buildIndent(int indent) {
        StringBuilder indentBuilder = new StringBuilder();
        while (indent-- > 0) {
            indentBuilder.append(' ');
        }
        return indentBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readUser(String prompt) throws ReadInterruptedException {
        String oldPrompt = this.getPrompt();
        try {
            this.setPrompt(prompt);
            MultilineCommandReader user = new MultilineCommandReader(this.terminal);
            if (!this.readCommand(user, "\n", false)) {
                String string = null;
                return string;
            }
            String string = ((Object)user).toString();
            return string;
        }
        finally {
            this.setPrompt(oldPrompt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readPassword(String prompt) throws ReadInterruptedException {
        String oldPrompt = this.getPrompt();
        try {
            this.setPrompt(prompt);
            PasswordReader password = new PasswordReader(this.terminal);
            if (!this.readCommand(password, "\n", false)) {
                String string = null;
                return string;
            }
            String string = password.toString();
            return string;
        }
        finally {
            this.setPrompt(oldPrompt);
        }
    }

    @Override
    public PrintStream getPrintStreamLess() {
        return new PrintStreamLess(this.getPrintStream());
    }

    @Override
    public PrintStream getPrintStream(Color color) {
        if (ConsoleConfiguration.instance().isMonochrome()) {
            return this.terminal.getPrintStream();
        }
        return this.terminal.getPrintStream(color);
    }

    @Override
    public PrintStream getPrintStreamLess(Color color) {
        if (ConsoleConfiguration.instance().isMonochrome()) {
            return new PrintStreamLess(this.terminal.getPrintStream());
        }
        return new PrintStreamLess(this.terminal.getPrintStream(color));
    }

    @Override
    public PrintStream getErrorPrintStream() {
        if (ConsoleConfiguration.instance().isMonochrome()) {
            return new PrintStreamLess(this.terminal.getPrintStream());
        }
        return new PrintStreamLess(this.terminal.getPrintStream(ConsoleConfiguration.instance().getErrorColor()));
    }

    @Override
    public PrintStream getWarningPrintStream() {
        if (ConsoleConfiguration.instance().isMonochrome()) {
            return new PrintStreamLess(this.terminal.getPrintStream());
        }
        return new PrintStreamLess(this.terminal.getPrintStream(ConsoleConfiguration.instance().getWarningColor()));
    }

    @Override
    public boolean interrupt() {
        this.terminal.interrupt();
        return true;
    }

    @Override
    public void waitForInterrupt(String allowedChars) {
        InputCharacter c;
        do {
            try {
                c = this.terminal.readInterruptable();
            }
            catch (ReadInterruptedException exception) {
                break;
            }
        } while (c != null && (!c.isSpecialCharacter() || c.getSpecialKey() != Keys.CTRL_C) && (c.isSpecialCharacter() || allowedChars == null || allowedChars.indexOf(c.getCharacter()) == -1));
    }

    @Override
    public Keys waitForCtrlKC(long timeout) {
        while (true) {
            InputCharacter c;
            try {
                c = this.terminal.readInterruptable(timeout);
                if (c == null) {
                }
            }
            catch (ReadInterruptedException exception) {}
            break;
            if (c.isSpecialCharacter() && (c.getSpecialKey() == Keys.CTRL_K || c.getSpecialKey() == Keys.CTRL_C)) {
                this.notProcessedCharacters.clear();
                return c.getSpecialKey();
            }
            this.notProcessedCharacters.add(c);
        }
        return null;
    }

    protected InputCharacter waitForChar(String suggestion, String chars) throws ReadInterruptedException {
        InputCharacter c;
        this.getPrintStream().print(suggestion);
        while ((c = this.terminal.readInterruptable()) != null && chars.indexOf(c.getCharacter()) == -1) {
        }
        this.terminal.backspace(suggestion.length());
        return c;
    }

    private boolean isCommand(CommandReader command, String command2, boolean startWith) {
        block4: {
            String command1 = command.toOneLineString().trim().toLowerCase();
            if (command1.equals(command2 = command2.toLowerCase())) {
                return true;
            }
            StringTokenizer tokens1 = new StringTokenizer(command1);
            StringTokenizer tokens2 = new StringTokenizer(command2);
            do {
                boolean hasMore2;
                boolean hasMore1;
                if ((hasMore1 = tokens1.hasMoreTokens()) != (hasMore2 = tokens2.hasMoreTokens())) {
                    if (startWith) {
                        return !hasMore2;
                    }
                    return false;
                }
                if (!hasMore1) break block4;
            } while (tokens1.nextToken().equals(tokens2.nextToken()));
            return false;
        }
        return true;
    }

    @Override
    public boolean isNativeContext(MFSession session) {
        return true;
    }

    @Override
    public void setEncoding(Charset charset) throws UnsupportedEncodingException {
        this.terminal.setEncoding(charset);
    }

    public class PrintStreamLess
    extends PrintStreamDecorator
    implements InterruptableStream {
        private static final String suggestion = "--More--";
        private int linesCount;
        private int charsCount;
        private boolean withExit;
        private boolean interrupted;

        PrintStreamLess(PrintStream out) {
            super(out);
            this.linesCount = 0;
            this.charsCount = 0;
            this.withExit = true;
            this.interrupted = false;
        }

        PrintStreamLess(PrintStream out, boolean withExit) {
            super(out);
            this.linesCount = 0;
            this.charsCount = 0;
            this.withExit = true;
            this.interrupted = false;
            this.withExit = withExit;
        }

        @Override
        protected void onPrint(String s) {
            if (this.isInterrupted()) {
                return;
            }
            int height = NativeConsole.this.terminal.getHeight();
            int width = NativeConsole.this.terminal.getWidth();
            StringBuilder bufferBuilder = null;
            for (int index = 0; index < s.length(); ++index) {
                if (this.linesCount == height - 1 || this.charsCount == width) {
                    if (bufferBuilder != null) {
                        super.onPrint(bufferBuilder.toString());
                        bufferBuilder = null;
                    }
                    try {
                        InputCharacter c = NativeConsole.this.waitForChar(suggestion, " q\t");
                        if (this.withExit && (c == null || c.getCharacter() == 'q')) {
                            this.interrupted = true;
                            return;
                        }
                    }
                    catch (ReadInterruptedException exception) {
                        this.interrupted = true;
                        return;
                    }
                    height = NativeConsole.this.terminal.getHeight();
                    width = NativeConsole.this.terminal.getWidth();
                    this.linesCount = 0;
                    this.charsCount = 0;
                }
                if (s.charAt(index) == '\n') {
                    ++this.linesCount;
                    this.charsCount = 0;
                } else {
                    ++this.charsCount;
                }
                if (this.charsCount == width) {
                    ++this.linesCount;
                    this.charsCount = 0;
                }
                if (bufferBuilder == null) {
                    bufferBuilder = new StringBuilder();
                }
                bufferBuilder.append(s.charAt(index));
            }
            if (bufferBuilder != null) {
                super.onPrint(bufferBuilder.toString());
            }
        }

        @Override
        protected void onNewLine() {
            if (this.isInterrupted()) {
                return;
            }
            int height = NativeConsole.this.terminal.getHeight();
            if (this.linesCount == height - 1) {
                try {
                    InputCharacter c = NativeConsole.this.waitForChar(suggestion, " Qq\t");
                    if (this.withExit && (c == null || Character.toLowerCase(c.getCharacter()) == 'q')) {
                        this.interrupted = true;
                        return;
                    }
                }
                catch (ReadInterruptedException exception) {
                    this.interrupted = true;
                    return;
                }
                this.linesCount = 0;
            }
            super.onNewLine();
            ++this.linesCount;
            this.charsCount = 0;
        }

        @Override
        public boolean isInterrupted() {
            return this.interrupted;
        }
    }
}

