/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.console;

import com.streamscape.Trace;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.omf.xml.XConstants;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.omf.xml.xstream.converters.reflection.FabricDefaultsProvider;
import com.streamscape.tools.console.CommandsHistory;
import com.streamscape.tools.console.terminal.Color;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.function.Consumer;

public class ConsoleConfiguration {
    public static final String CONFIGURATION_FILE_NAME = ".slprofile";
    private static final Color DEFAULT_RESPONSE_COLOR = new Color(10, -1);
    private static final Color DEFAULT_ERROR_COLOR = new Color(12, -1);
    private static final Color DEFAULT_WARNING_COLOR = new Color(14, -1);
    private static final Color DEFAULT_COMPLETION_COLOR = new Color(6, -1);
    private static final Color DEFAULT_HTML_TAG_B_COLOR = new Color(14, -1);
    private static final Color DEFAULT_HTML_TAG_I_COLOR = new Color(15, -1);
    private static final Color DEFAULT_HTML_TAG_U_COLOR = new Color(15, -1);
    private static final long DEFAULT_REPLY_TIMEOUT = 30000L;
    private static final int DEFAULT_RECONNECT_ATTEMPTS = 0;
    private static final long DEFAULT_RECONNECT_INTERVAL = 30L;
    private static final String DEFAULT_DISCOVERY_FABRIC_DIRECTORY = "DirectoryTable.xdo";
    private static final boolean DEFAULT_DISCOVERY_MULTICAST_ENABLED = true;
    private static final String DEFAULT_DISCOVERY_MULTICAST_ADDRESS = "230.0.0.0:8888";
    private static final long DEFAULT_DISCOVERY_MULTICAST_WAITING_TIME = 3L;
    private CommandsHistory<String> commandsHistory = new CommandsHistory();
    private Color responseColor = DEFAULT_RESPONSE_COLOR;
    private Color errorColor = DEFAULT_ERROR_COLOR;
    private Color warningColor = DEFAULT_WARNING_COLOR;
    private Color completionColor = DEFAULT_COMPLETION_COLOR;
    private Color htmlTagBColor = DEFAULT_HTML_TAG_B_COLOR;
    private Color htmlTagIColor = DEFAULT_HTML_TAG_I_COLOR;
    private Color htmlTagUColor = DEFAULT_HTML_TAG_U_COLOR;
    private boolean isMonochrome = false;
    private String delimiter = null;
    private Long replyTimeout = 30000L;
    private Integer reconnectAttempts = 0;
    private Long reconnectInterval = 30L;
    private boolean statsTimeOn = false;
    private boolean basicPrompt = false;
    private String discoveryFabricDirectory = "DirectoryTable.xdo";
    private Boolean discoveryMulticastEnabled = true;
    private String discoveryMulticastAddress = "230.0.0.0:8888";
    private Long discoveryMulticastWaitingTime = 3L;
    private transient boolean saveToFile = true;
    private transient long lastUpdateTime = 0L;
    private transient long lastSaveTime = 0L;
    private static XSerializer xSerializer = null;
    private static ConsoleConfiguration instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConsoleConfiguration instance() {
        if (instance != null) return instance;
        Class<ConsoleConfiguration> clazz = ConsoleConfiguration.class;
        synchronized (ConsoleConfiguration.class) {
            if (instance != null) return instance;
            throw new RuntimeException("ConsoleConfiguration not initialized, initialize first.");
        }
    }

    private ConsoleConfiguration() {
    }

    public void initializeParameters() {
        boolean needSave = false;
        needSave |= this.doInit(this.responseColor, t -> {
            this.responseColor = t;
        }, DEFAULT_RESPONSE_COLOR);
        needSave |= this.doInit(this.errorColor, t -> {
            this.errorColor = t;
        }, DEFAULT_ERROR_COLOR);
        needSave |= this.doInit(this.warningColor, t -> {
            this.warningColor = t;
        }, DEFAULT_WARNING_COLOR);
        needSave |= this.doInit(this.completionColor, t -> {
            this.completionColor = t;
        }, DEFAULT_COMPLETION_COLOR);
        needSave |= this.doInit(this.htmlTagBColor, t -> {
            this.htmlTagBColor = t;
        }, DEFAULT_HTML_TAG_B_COLOR);
        needSave |= this.doInit(this.htmlTagIColor, t -> {
            this.htmlTagIColor = t;
        }, DEFAULT_HTML_TAG_I_COLOR);
        needSave |= this.doInit(this.htmlTagUColor, t -> {
            this.htmlTagUColor = t;
        }, DEFAULT_HTML_TAG_U_COLOR);
        needSave |= this.doInit(this.replyTimeout, t -> {
            this.replyTimeout = t;
        }, 30000L);
        needSave |= this.doInit(this.reconnectAttempts, t -> {
            this.reconnectAttempts = t;
        }, 0);
        needSave |= this.doInit(this.reconnectInterval, t -> {
            this.reconnectInterval = t;
        }, 30L);
        needSave |= this.doInit(this.discoveryFabricDirectory, t -> {
            this.discoveryFabricDirectory = t;
        }, DEFAULT_DISCOVERY_FABRIC_DIRECTORY);
        needSave |= this.doInit(this.discoveryMulticastEnabled, t -> {
            this.discoveryMulticastEnabled = t;
        }, true);
        needSave |= this.doInit(this.discoveryMulticastAddress, t -> {
            this.discoveryMulticastAddress = t;
        }, DEFAULT_DISCOVERY_MULTICAST_ADDRESS);
        if (needSave |= this.doInit(this.discoveryMulticastWaitingTime, t -> {
            this.discoveryMulticastWaitingTime = t;
        }, 3L)) {
            this.setLastUpdateTime();
            this.saveToFile();
        }
    }

    private <T> boolean doInit(T parameter, Consumer<T> updater, T defaultValue) {
        if (parameter == null) {
            updater.accept(defaultValue);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConsoleConfiguration initializeDefault() {
        Class<ConsoleConfiguration> clazz = ConsoleConfiguration.class;
        synchronized (ConsoleConfiguration.class) {
            if (instance != null) {
                throw new RuntimeException("ConsoleConfiguration already initialized.");
            }
            instance = new ConsoleConfiguration();
            instance.setLastUpdateTime();
            instance.saveToFile();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConsoleConfiguration initializeFromFile() {
        Class<ConsoleConfiguration> clazz = ConsoleConfiguration.class;
        synchronized (ConsoleConfiguration.class) {
            if (instance != null) {
                throw new RuntimeException("ConsoleConfiguration already initialized.");
            }
            File file = new File(ConsoleConfiguration.getProfileFileName());
            if (!file.exists()) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return ConsoleConfiguration.initializeDefault();
            }
            try {
                Object object = ConsoleConfiguration.getSerializer().deserialize(new DataInputStream(new FileInputStream(file)));
                if (!(object instanceof ConsoleConfiguration)) {
                    throw new Exception("Null or invalid object in configuration file.");
                }
                instance = (ConsoleConfiguration)object;
            }
            catch (Exception exception) {
                Trace.logError(ConsoleConfiguration.class, "Deserialization of profile '" + file.getAbsolutePath() + "' failed.");
                Trace.logException(ConsoleConfiguration.class, exception, false);
                // ** MonitorExit[var0] (shouldn't be in output)
                return ConsoleConfiguration.initializeDefault();
            }
            return instance;
        }
    }

    public static String getProfileFileName() {
        Object fileName = System.getProperty("user.home");
        if (fileName == null) {
            fileName = ".";
        }
        fileName = (String)fileName + "/.slprofile";
        return fileName;
    }

    public void setSaveToFile(boolean saveToFile) {
        this.saveToFile = saveToFile;
    }

    public synchronized void saveToFile() {
        if (!this.saveToFile) {
            return;
        }
        if (this.lastSaveTime >= this.lastUpdateTime && this.lastSaveTime >= this.commandsHistory.getLastUpdateTime()) {
            return;
        }
        long lastSaveTimeBkp = this.lastSaveTime;
        try (FileWriter writer = new FileWriter(ConsoleConfiguration.getProfileFileName());){
            this.lastSaveTime = System.currentTimeMillis();
            ConsoleConfiguration.getSerializer().serialize((Object)this, writer);
        }
        catch (Exception exception) {
            this.lastSaveTime = lastSaveTimeBkp;
            Trace.logError(ConsoleConfiguration.class, "Serialization of profile '" + ConsoleConfiguration.getProfileFileName() + "' failed.");
            Trace.logException(ConsoleConfiguration.class, exception, false);
        }
    }

    private static XSerializer getSerializer() throws FactoryManagerException {
        if (xSerializer == null) {
            ObjectMediationAliasManager aliasManager = new ObjectMediationAliasManager();
            aliasManager.alias("ConsoleConfiguration", ConsoleConfiguration.class);
            xSerializer = XSerializerFactory.getInstance().createSerializer("ConsoleConfigurationSerializer", aliasManager);
            FabricDefaultsProvider defaultsProvider = xSerializer.getDefaultsProvider();
            defaultsProvider.setFieldDefault("replyTimeout", Long.class, ConsoleConfiguration.class, XConstants.NULL);
            defaultsProvider.setFieldDefault("reconnectAttempts", Integer.class, ConsoleConfiguration.class, XConstants.NULL);
            defaultsProvider.setFieldDefault("reconnectInterval", Long.class, ConsoleConfiguration.class, XConstants.NULL);
            defaultsProvider.setFieldDefault("discoveryMulticastWaitingTime", Long.class, ConsoleConfiguration.class, XConstants.NULL);
        }
        return xSerializer;
    }

    private void setLastUpdateTime() {
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public CommandsHistory<String> getCommandsHistory() {
        return this.commandsHistory;
    }

    public Color getResponseColor() {
        return this.responseColor;
    }

    public void setResponseColor(Color responseColor) {
        this.responseColor = responseColor;
        this.setLastUpdateTime();
    }

    public Color getErrorColor() {
        return this.errorColor;
    }

    public void setErrorColor(Color errorColor) {
        this.errorColor = errorColor;
        this.setLastUpdateTime();
    }

    public Color getWarningColor() {
        return this.warningColor;
    }

    public void setWarningColor(Color warningColor) {
        this.warningColor = warningColor;
        this.setLastUpdateTime();
    }

    public Color getCompletionColor() {
        return this.completionColor;
    }

    public void setCompletionColor(Color completionColor) {
        this.completionColor = completionColor;
        this.setLastUpdateTime();
    }

    public Color getHtmlTagBColor() {
        return this.htmlTagBColor;
    }

    public void setHtmlTagBColor(Color color) {
        this.htmlTagBColor = color;
        this.setLastUpdateTime();
    }

    public Color getHtmlTagIColor() {
        return this.htmlTagIColor;
    }

    public void setHtmlTagIColor(Color color) {
        this.htmlTagIColor = color;
        this.setLastUpdateTime();
    }

    public Color getHtmlTagUColor() {
        return this.htmlTagUColor;
    }

    public void setHtmlTagUColor(Color color) {
        this.htmlTagUColor = color;
        this.setLastUpdateTime();
    }

    public boolean isMonochrome() {
        return this.isMonochrome;
    }

    public void setMonochrome(boolean isMonochrome) {
        this.isMonochrome = isMonochrome;
        this.setLastUpdateTime();
    }

    public String getDelimiter() {
        if (this.delimiter == null) {
            return "\n";
        }
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter.equals("\n") ? null : delimiter;
        this.setLastUpdateTime();
    }

    public long getReplyTimeout() {
        return this.replyTimeout;
    }

    public void setReplyTimeout(long replyTimeout) {
        this.replyTimeout = replyTimeout;
        this.setLastUpdateTime();
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public void setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
        this.setLastUpdateTime();
    }

    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectInterval(long reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
        this.setLastUpdateTime();
    }

    public void setStatsTimeOn(boolean statsTimeOn) {
        this.statsTimeOn = statsTimeOn;
        this.setLastUpdateTime();
    }

    public boolean isStatsTimeOn() {
        return this.statsTimeOn;
    }

    public void setBasicPrompt(boolean basicPrompt) {
        this.basicPrompt = basicPrompt;
        this.setLastUpdateTime();
    }

    public boolean isBasicPrompt() {
        return this.basicPrompt;
    }

    public String getDiscoveryFabricDirectory() {
        return this.discoveryFabricDirectory;
    }

    public void setDiscoveryFabricDirectory(String discoveryFabricDirectory) {
        this.discoveryFabricDirectory = discoveryFabricDirectory;
        this.setLastUpdateTime();
    }

    public boolean isDiscoveryMulticastEnabled() {
        return this.discoveryMulticastEnabled;
    }

    public void setDiscoveryMulticastEnabled(boolean discoveryMulticastEnabled) {
        this.discoveryMulticastEnabled = discoveryMulticastEnabled;
        this.setLastUpdateTime();
    }

    public String getDiscoveryMulticastAddress() {
        return this.discoveryMulticastAddress;
    }

    public void setDiscoveryMulticastAddress(String discoveryMulticastAddress) {
        this.discoveryMulticastAddress = discoveryMulticastAddress;
        this.setLastUpdateTime();
    }

    public long getDiscoveryMulticastWaitingTime() {
        return this.discoveryMulticastWaitingTime;
    }

    public void setDiscoveryMulticastWaitingTime(long discoveryMulticastWaitingTime) {
        this.discoveryMulticastWaitingTime = discoveryMulticastWaitingTime;
        this.setLastUpdateTime();
    }
}

