/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.console;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class CommandsHistory<T> {
    public static int DEFAULT_LIMIT = 1000;
    private int limitCount = DEFAULT_LIMIT;
    private List<T> history = Collections.synchronizedList(new LinkedList());
    private transient int iteratorIndex = -2;
    private transient int iteratorStoredIndex = -2;
    private transient T lastCommand = null;
    private transient long lastUpdateTime = 0L;

    public CommandsHistory() {
        this(DEFAULT_LIMIT);
    }

    public CommandsHistory(int limitCount) {
        this.limitCount = limitCount;
    }

    public void addCommand(T t) {
        if (!this.history.isEmpty() && this.history.get(this.history.size() - 1) != null && this.history.get(this.history.size() - 1).equals(t)) {
            this.storeCurrentElement();
            return;
        }
        if (this.history.size() >= this.limitCount && this.history.size() > 0) {
            this.history.remove(0);
            if (this.iteratorIndex != -2) {
                --this.iteratorIndex;
                if (this.iteratorIndex <= 0) {
                    this.iteratorIndex = 0;
                }
            }
        }
        if (this.limitCount > 0) {
            this.history.add(t);
            this.storeCurrentElement();
            if (this.iteratorIndex != -2 && !this.history.get(this.iteratorIndex).equals(t)) {
                this.resetIterator();
            }
            this.setLastUpdateTime();
        }
    }

    public void storeCurrentElement() {
        this.iteratorStoredIndex = this.iteratorIndex;
    }

    public T previousCommand() {
        if (this.iteratorStoredIndex != -2) {
            T element = this.history.get(this.iteratorStoredIndex);
            this.iteratorStoredIndex = -2;
            return element;
        }
        if (this.iteratorIndex == -2) {
            this.iteratorIndex = this.history.size();
        }
        --this.iteratorIndex;
        if (this.iteratorIndex < 0) {
            this.iteratorIndex = 0;
        }
        return this.iteratorIndex >= this.history.size() ? null : (T)this.history.get(this.iteratorIndex);
    }

    public T nextCommand() {
        this.iteratorStoredIndex = -2;
        if (this.iteratorIndex == -2 || this.iteratorIndex >= this.history.size() || ++this.iteratorIndex >= this.history.size()) {
            T result = this.lastCommand;
            this.resetIterator();
            return result;
        }
        return this.history.get(this.iteratorIndex);
    }

    public T getLastCommand() {
        return this.lastCommand;
    }

    public void setLastCommand(T lastCommand) {
        this.lastCommand = lastCommand;
    }

    public void resetIterator() {
        this.iteratorIndex = -2;
        this.iteratorStoredIndex = -2;
        this.lastCommand = null;
    }

    public T getCommand(int index) {
        try {
            return this.history.get(index);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void clear() {
        this.history.clear();
        this.resetIterator();
    }

    public void setLimitCount(int limitCount) {
        this.limitCount = limitCount;
        while (this.history.size() > limitCount && this.history.size() > 0) {
            this.history.remove(0);
        }
        this.resetIterator();
        this.setLastUpdateTime();
    }

    public int getLimitCount() {
        return this.limitCount;
    }

    public List<T> getHistory() {
        return Collections.unmodifiableList(this.history);
    }

    private void setLastUpdateTime() {
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }
}

