/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.console;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.AbstractDSLProvider;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.tools.console.AbstractConsole;
import com.streamscape.tools.console.ConsoleConfiguration;
import java.io.PrintStream;

public abstract class AbstractJavaConsole
extends AbstractConsole
implements SLCallable {
    private JavaConsoleDSLSyntaxProvider internalCommandsProvider = new JavaConsoleDSLSyntaxProvider(this);

    public AbstractJavaConsole() {
        this.internalCommandsProvider.activate(this);
    }

    protected abstract String readLine(String var1);

    @Override
    public String readCommand(String delimiter) {
        StringBuilder builder = new StringBuilder();
        String currentPrompt = this.getPrompt();
        boolean isCommandFull = false;
        while (true) {
            String part;
            if ((part = this.readLine(currentPrompt)) == null) {
                if (builder.length() > 0) {
                    return builder.toString();
                }
                return null;
            }
            if ((part = part.trim()).startsWith("//") && builder.toString().trim().length() == 0) continue;
            if (this.isLocalConsoleCommand(builder.toString() + part)) {
                delimiter = this.getDelimiter();
                builder = new StringBuilder();
                currentPrompt = this.getPrompt();
                continue;
            }
            if (!delimiter.isEmpty() && !delimiter.equals("\n") && part.endsWith(delimiter)) {
                part = part.substring(0, part.length() - delimiter.length());
                isCommandFull = true;
            }
            if (builder.length() > 0 && builder.charAt(builder.length() - 1) != '\n' && !part.isEmpty()) {
                builder.append('\n');
            }
            builder.append(part);
            if (isCommandFull || delimiter.isEmpty() || delimiter.equals("\n")) break;
            if (builder.length() <= 0) continue;
            currentPrompt = this.getPrompt1();
        }
        return builder.toString().trim();
    }

    boolean isLocalConsoleCommand(String command) {
        if (command == null) {
            return false;
        }
        try {
            DSLStatement statement = this.internalCommandsProvider.parseDsl(command, null);
            if (statement != null) {
                SLResponse response = this.internalCommandsProvider.invoke(statement, null);
                if (response != null && response.isOK()) {
                    PrintStream printStream = this.getPrintStreamLess(ConsoleConfiguration.instance().getResponseColor());
                    if (response.getText() != null) {
                        printStream.println();
                        printStream.println(response.getText());
                        printStream.println();
                    } else {
                        printStream.println("\nOK\n");
                    }
                }
                return true;
            }
        }
        catch (ParsingException e) {
            this.getErrorPrintStream().println();
            this.getErrorPrintStream().println(e.getMessage());
            this.getErrorPrintStream().println();
            return true;
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isNativeContext(MFSession session) {
        return true;
    }

    public static class JavaConsoleDSLSyntaxProvider
    extends AbstractDSLProvider<AbstractJavaConsole> {
        JavaConsoleDSLSyntaxProvider(AbstractJavaConsole callable) {
            super("JavaConsoleDSLSyntaxProvider", callable);
            this.registerOperation(new SetDelimiterOperation());
            this.registerOperation(new GetDelimiterOperation());
        }

        static class SetDelimiterOperation
        extends AbstractDSLOperation<AbstractJavaConsole> {
            private static final String NAME = "set delimiter";

            SetDelimiterOperation() {
                this.createDSLSyntax(NAME);
                this.syntax.setAction("SET DELIMITER").addActionParameter((SyntaxParameter)new ExpressionParameter("delimiter").setRequired(false));
                this.syntax.setDescription("Sets lines delimiter.");
            }

            @Override
            public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
                if (!statement.getParameter("delimiter").isPresent()) {
                    return new Definition("\n");
                }
                return new Definition(statement.getParameter("delimiter").getValue().trim());
            }

            @Override
            public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
                ((AbstractJavaConsole)this.callable).setDelimiter(((Definition)statement).delimiter);
                return new SLResponse();
            }

            static class Definition
            extends AbstractSLStatement {
                private String delimiter;

                Definition(String delimiter) {
                    super(SetDelimiterOperation.NAME);
                    this.delimiter = delimiter;
                }
            }
        }

        static class GetDelimiterOperation
        extends AbstractDSLOperation<AbstractJavaConsole> {
            private static final String NAME = "get delimiter";

            GetDelimiterOperation() {
                this.createDSLSyntax(NAME);
                this.syntax.setAction("GET DELIMITER");
                this.syntax.setDescription("Shows lines delimiter.");
            }

            @Override
            public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
                return new SLResponse("Delimiter: '" + (((AbstractJavaConsole)this.callable).getDelimiter().equals("\n") ? "new line" : ((AbstractJavaConsole)this.callable).getDelimiter()) + "'");
            }

            @Override
            public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
                return new Definition();
            }

            static class Definition
            extends AbstractSLStatement {
                Definition() {
                    super(GetDelimiterOperation.NAME);
                }
            }
        }
    }
}

