/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.console;

import com.streamscape.lib.utils.CIString;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.tools.console.Console;
import com.streamscape.tools.console.ConsoleConfiguration;
import com.streamscape.tools.console.terminal.Color;
import com.streamscape.tools.console.terminal.ReadInterruptedException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public abstract class AbstractConsole
implements Console {
    public static final String DEFAULT_PROMPT = "slang";
    public static final String PROMPT_SIGN = "> ";
    private String prompt = "slang> ";
    private String prompt1;
    private boolean isNoPrompt = false;
    private PrintStream out = System.out;
    private static Map<CIString, HelpTag> HELP_TAGS = new HashMap<CIString, HelpTag>();

    protected AbstractConsole() {
        this(System.out);
    }

    protected AbstractConsole(PrintStream out) {
        this.out = out;
        this.prompt1 = this.buildPrompt1(this.prompt);
    }

    @Override
    public String readCommand() throws ReadInterruptedException {
        return this.readCommand(this.getDelimiter());
    }

    @Override
    public String readUser() throws ReadInterruptedException {
        return this.readUser("user: ");
    }

    @Override
    public String readPassword() throws ReadInterruptedException {
        return this.readPassword("password: ");
    }

    @Override
    public void destroy() {
    }

    @Override
    public void setPrompt(String prompt) {
        this.prompt = prompt;
        this.prompt1 = this.buildPrompt1(this.prompt);
    }

    @Override
    public String getPrompt() {
        if (this.isNoPrompt) {
            return "";
        }
        return this.prompt;
    }

    public String getPrompt1() {
        if (this.isNoPrompt) {
            return "";
        }
        return this.prompt1;
    }

    @Override
    public void setNoPrompt(boolean isNoPrompt) {
        this.isNoPrompt = isNoPrompt;
    }

    @Override
    public boolean isNoPrompt() {
        return this.isNoPrompt;
    }

    @Override
    public void setDelimiter(String delimiter) {
        ConsoleConfiguration.instance().setDelimiter(delimiter);
    }

    @Override
    public String getDelimiter() {
        return ConsoleConfiguration.instance().getDelimiter();
    }

    @Override
    public PrintStream getPrintStream() {
        return this.out;
    }

    @Override
    public PrintStream getPrintStreamLess() {
        return this.out;
    }

    @Override
    public PrintStream getPrintStream(Color color) {
        return this.getPrintStream();
    }

    @Override
    public PrintStream getPrintStreamLess(Color color) {
        return this.getPrintStreamLess();
    }

    @Override
    public PrintStream getErrorPrintStream() {
        return System.err;
    }

    @Override
    public PrintStream getWarningPrintStream() {
        return this.out;
    }

    private String buildPrompt1(String prompt) {
        int i;
        if (prompt == null || prompt.length() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int sign = prompt.lastIndexOf(">");
        if (sign == -1) {
            sign = prompt.length() - 1;
        }
        for (i = 0; i < sign; ++i) {
            builder.append(" ");
        }
        builder.append(">");
        for (i = sign + 1; i < prompt.length(); ++i) {
            builder.append(" ");
        }
        return builder.toString();
    }

    @Override
    public void printWithTags(PrintStream printStream, String text) {
        for (TextPiece piece : AbstractConsole.parseHelp(text)) {
            piece.text = piece.text.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
            if (piece.color == null) {
                printStream.print(piece.text);
                continue;
            }
            this.getPrintStreamLess(piece.color).print(piece.text);
        }
    }

    private static List<TextPiece> parseHelp(String help) {
        ArrayList<TextPiece> result = new ArrayList<TextPiece>();
        if (help == null) {
            return result;
        }
        HelpTag lastTag = new HelpTag(-1, -1);
        int iBegin = 0;
        while (iBegin < help.length()) {
            HelpTag tag = AbstractConsole.findTag(help, iBegin);
            if (tag != null) {
                result.add(new TextPiece(help.substring(lastTag.iEnd + 1, tag.iBegin), tag.isClosingFor(lastTag) && lastTag.colorSource != null ? lastTag.colorSource.get() : null));
                lastTag = tag;
                iBegin = lastTag.iEnd + 1;
                continue;
            }
            result.add(new TextPiece(help.substring(iBegin), null));
            iBegin = help.length();
        }
        return result;
    }

    private static HelpTag findTag(String help, int iBegin) {
        while (iBegin != -1 && iBegin < help.length()) {
            if ((iBegin = help.indexOf(60, iBegin)) == -1) continue;
            int iTagEnd = help.indexOf(62, iBegin + 1);
            if (iTagEnd != -1) {
                HelpTag tag = HELP_TAGS.get(new CIString(help.substring(iBegin, iTagEnd + 1)));
                if (tag != null) {
                    return new HelpTag(tag, iBegin, iTagEnd);
                }
                iBegin = iTagEnd + 1;
                continue;
            }
            ++iBegin;
        }
        return null;
    }

    @Override
    public SLResponse invokeConsoleCommand(String command) {
        return null;
    }

    @Override
    public void setEncoding(Charset charset) throws UnsupportedEncodingException {
    }

    static {
        HELP_TAGS.put(new CIString("<b>"), new HelpTag("b", true, () -> ConsoleConfiguration.instance().getHtmlTagBColor()));
        HELP_TAGS.put(new CIString("</b>"), new HelpTag("/b", false, null));
        HELP_TAGS.put(new CIString("<i>"), new HelpTag("i", true, () -> ConsoleConfiguration.instance().getHtmlTagIColor()));
        HELP_TAGS.put(new CIString("</i>"), new HelpTag("/i", false, null));
        HELP_TAGS.put(new CIString("<u>"), new HelpTag("u", true, () -> ConsoleConfiguration.instance().getHtmlTagUColor()));
        HELP_TAGS.put(new CIString("</u>"), new HelpTag("/u", false, null));
        HELP_TAGS.put(new CIString("<p>"), new HelpTag("p", true, null));
        HELP_TAGS.put(new CIString("</p>"), new HelpTag("/p", false, null));
    }

    private static class TextPiece {
        String text;
        Color color;

        TextPiece(String text, Color color) {
            this.text = text;
            this.color = color;
        }
    }

    private static class HelpTag {
        String tag;
        boolean isOpening = false;
        Supplier<Color> colorSource;
        int iBegin = -1;
        int iEnd = -1;

        HelpTag(int iBegin, int iEnd) {
            this.iBegin = iBegin;
            this.iEnd = iEnd;
        }

        HelpTag(String tag, boolean isOpening, Supplier<Color> colorSource) {
            this.tag = tag;
            this.isOpening = isOpening;
            this.colorSource = colorSource;
        }

        HelpTag(HelpTag other, int iBegin, int iEnd) {
            this(other.tag, other.isOpening, other.colorSource);
            this.iBegin = iBegin;
            this.iEnd = iEnd;
        }

        boolean isClosingFor(HelpTag other) {
            return !this.isOpening && other.isOpening && this.tag.equalsIgnoreCase("/" + other.tag);
        }

        public String toString() {
            return "<" + this.tag + ">";
        }
    }
}

