/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.console;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.tools.console.CommandReader;
import com.streamscape.tools.console.terminal.Terminal;
import java.util.ArrayList;
import java.util.List;

public class AbstractCommandReader
implements CommandReader {
    protected List<StringBuilder> lines;
    protected int currentLine;
    protected int currentPosition;
    protected boolean positionChanged = false;
    protected Terminal terminal;

    public AbstractCommandReader(Terminal terminal) {
        this.terminal = terminal;
        this.reset();
    }

    @Override
    public void reset() {
        this.lines = new ArrayList<StringBuilder>();
        this.currentLine = 0;
        this.currentPosition = 0;
        this.lines.add(new StringBuilder());
        this.positionChanged(false);
    }

    @Override
    public void positionChanged(boolean positionChanged) {
        this.positionChanged = positionChanged;
    }

    @Override
    public boolean newline(String prompt1, String delimiter) {
        int offset;
        StringBuilder line = this.lines.get(this.currentLine);
        if (this.currentLine == this.lines.size() - 1) {
            if (delimiter.equals("\n")) {
                return true;
            }
            if (this.currentLine == 0 && line.toString().trim().length() == 0) {
                return true;
            }
            if (line.toString().trim().endsWith(delimiter)) {
                return true;
            }
            if (this.currentLine == 0 && line.toString().trim().startsWith("//")) {
                return true;
            }
        }
        Coord coords = this.getCurrentPositionCoord(prompt1);
        if (coords.y != coords.linescount - 1) {
            return false;
        }
        if (this.currentPosition < line.length()) {
            this.terminal.clearforward(line.length() - this.currentPosition);
            ++this.currentLine;
            this.lines.add(this.currentLine, new StringBuilder().append(line.substring(this.currentPosition)));
            line.delete(this.currentPosition, line.length());
        } else {
            ++this.currentLine;
            this.lines.add(this.currentLine, new StringBuilder());
        }
        line = this.lines.get(this.currentLine);
        this.currentPosition = 0;
        this.println();
        this.terminal.getPrintStream().print(prompt1);
        this.print(line.toString());
        if (this.currentLine + 1 < this.lines.size() && (offset = this.lines.get(this.currentLine + 1).length() - line.length()) > 0) {
            this.terminal.clearforward(offset);
            this.terminal.back(offset);
        }
        int dy = 0;
        dy += this.getCurrentPositionCoord((String)prompt1).y;
        for (int i = this.currentLine + 1; i < this.lines.size(); ++i) {
            int offset2;
            this.println();
            this.terminal.getPrintStream().print(prompt1);
            this.print(this.lines.get(i).toString());
            if (i + 1 < this.lines.size() && (offset2 = this.lines.get(i + 1).length() - this.lines.get(i).length()) > 0) {
                this.terminal.clearforward(offset2);
                this.terminal.back(offset2);
            }
            dy += this.getPositionCoord((String)prompt1, (StringBuilder)this.lines.get((int)i)).y + 1;
        }
        int dx = prompt1.length() - this.getPositionCoord((String)prompt1, (StringBuilder)this.lines.get((int)(this.lines.size() - 1))).x;
        this.terminal.setPositionRelative(dx, -dy);
        this.positionChanged(true);
        return false;
    }

    @Override
    public void append(String prompt, char c) {
        StringBuilder line = this.lines.get(this.currentLine);
        if (this.lines.size() > 1 && this.currentLine < this.lines.size() - 1) {
            Coord coord = this.getPositionCoord(prompt, line);
            if (coord.y == coord.linescount - 1 && coord.x >= this.terminal.getWidth() - 1) {
                return;
            }
        }
        line.insert(this.currentPosition, c);
        ++this.currentPosition;
        this.print(c);
        this.print(line.substring(this.currentPosition));
        this.terminal.back(line.length() - this.currentPosition);
        this.positionChanged(true);
    }

    @Override
    public void append(String prompt1, String s) {
        List<String> strings = StringUtils.split(s, '\n');
        String firstLineTail = "";
        for (int i = 0; i < strings.size(); ++i) {
            int offset;
            String line = strings.get(i);
            if (i == 0) {
                StringBuilder lineBuilder = this.lines.get(this.currentLine);
                lineBuilder.insert(this.currentPosition, line);
                this.currentPosition += line.length();
                this.print(line);
                if (strings.size() == 1) {
                    this.print(lineBuilder.substring(this.currentPosition));
                    this.terminal.back(lineBuilder.length() - this.currentPosition);
                    continue;
                }
                int offset2 = lineBuilder.length() - this.currentPosition - line.length();
                if (offset2 > 0) {
                    this.terminal.clearforward(offset2);
                    this.terminal.back(offset2);
                }
                firstLineTail = lineBuilder.substring(this.currentPosition);
                lineBuilder.setLength(this.currentPosition);
                this.println();
                this.print(prompt1);
                this.currentPosition = 0;
                ++this.currentLine;
                this.lines.add(this.currentLine, new StringBuilder());
                continue;
            }
            if (i == strings.size() - 1) {
                this.lines.get(this.currentLine).append(line).append(firstLineTail);
                this.print(line);
                this.print(firstLineTail);
                this.terminal.back(firstLineTail.length());
                this.currentPosition = line.length();
                continue;
            }
            this.lines.get(this.currentLine).append(line);
            this.print(line);
            if (this.currentLine + 1 < this.lines.size() && (offset = this.lines.get(this.currentLine + 1).length() - line.length()) > 0) {
                this.terminal.clearforward(offset);
                this.terminal.back(offset);
            }
            this.println();
            this.print(prompt1);
            ++this.currentLine;
            this.lines.add(this.currentLine, new StringBuilder());
        }
        this.positionChanged(true);
    }

    @Override
    public void clearCommandLastLine(String prompt) {
        if (this.currentLine == this.lines.size() - 1) {
            this.terminal.back(this.currentPosition);
        } else {
            this.terminal.setPositionRelative(-this.currentPosition, this.lines.size() - this.currentLine - 1);
            this.currentLine = this.lines.size() - 1;
        }
        StringBuilder line = this.lines.get(this.currentLine);
        this.terminal.clearforward(line.length());
        this.terminal.back(line.length());
        this.reset();
        this.terminal.back(prompt.length());
        this.terminal.getPrintStream().print(prompt);
    }

    @Override
    public void clearCommandTillTheEnd(String prompt) {
        for (int i = this.currentLine + 1; i < this.lines.size(); ++i) {
            this.println();
            this.terminal.clearforward(prompt.length() + this.lines.get(i).length());
            this.terminal.back(prompt.length() + this.lines.get(i).length());
        }
        if (this.lines.size() - this.currentLine - 1 > 0) {
            this.terminal.setPositionRelative(0, -(this.lines.size() - this.currentLine - 1));
        }
    }

    @Override
    public void backspace(String prompt1) {
        if (this.currentPosition == 0) {
            if (this.currentLine == 0) {
                return;
            }
            for (int i = this.currentLine; i < this.lines.size(); ++i) {
                if (i + 1 < this.lines.size()) {
                    int offset = this.lines.get(i).length() - this.lines.get(i + 1).length();
                    this.print(this.lines.get(i + 1).toString());
                    if (offset > 0) {
                        this.terminal.clearforward(offset);
                    }
                    this.println();
                    this.print(prompt1);
                    continue;
                }
                this.terminal.clearforward(this.lines.get(i).length());
                this.terminal.back(this.lines.get(i).length());
            }
            this.terminal.backspace(prompt1.length());
            this.terminal.setPositionRelative(this.lines.get(this.currentLine - 1).length() + prompt1.length(), this.currentLine - this.lines.size());
            this.print(this.lines.get(this.currentLine).toString());
            this.terminal.back(this.lines.get(this.currentLine).length());
            this.currentPosition = this.lines.get(this.currentLine - 1).length();
            this.lines.get(this.currentLine - 1).append((CharSequence)this.lines.remove(this.currentLine));
            --this.currentLine;
        } else {
            StringBuilder line = this.lines.get(this.currentLine);
            line.deleteCharAt(this.currentPosition - 1);
            --this.currentPosition;
            this.terminal.backspace();
            this.print(line.substring(this.currentPosition));
            this.terminal.clearforward();
            this.terminal.back(line.length() - this.currentPosition + 1);
        }
        this.positionChanged(true);
    }

    @Override
    public void ctrlbackspace() {
        boolean isSpace;
        if (this.currentPosition == 0) {
            return;
        }
        StringBuilder line = this.lines.get(this.currentLine);
        boolean bl = isSpace = line.charAt(this.currentPosition - 1) == ' ';
        while (this.currentPosition > 1) {
            this.backspace("");
            if (this.currentPosition != 0 && (!isSpace || line.charAt(this.currentPosition - 1) == ' ') && (isSpace || line.charAt(this.currentPosition - 1) != ' ')) continue;
        }
        this.positionChanged(true);
    }

    @Override
    public void back(String prompt, String prompt1) {
        if (this.currentPosition == 0) {
            if (this.currentLine == 0) {
                return;
            }
            if (this.redrawUp(prompt, prompt1)) {
                this.terminal.setPositionRelative(this.getCurrentPositionCoord((String)prompt).x - prompt.length(), 0);
                this.currentPosition = this.getCurrentPositionCoord((String)prompt).x - prompt.length();
                return;
            }
            --this.currentLine;
            this.currentPosition = this.lines.get(this.currentLine).length();
            this.terminal.setPositionRelative(this.getCurrentPositionCoord((String)prompt).x - prompt.length(), -1);
        } else {
            --this.currentPosition;
            this.terminal.back();
        }
        this.positionChanged(true);
    }

    @Override
    public void ctrlback(String prompt, String prompt1) {
        boolean isSpace;
        if (this.currentPosition == 0) {
            return;
        }
        StringBuilder line = this.lines.get(this.currentLine);
        boolean bl = isSpace = line.charAt(this.currentPosition - 1) == ' ';
        while (this.currentPosition > 0) {
            this.back(prompt, prompt1);
            if (this.currentPosition != 0 && (!isSpace || line.charAt(this.currentPosition - 1) == ' ') && (isSpace || line.charAt(this.currentPosition - 1) != ' ')) continue;
        }
        this.positionChanged(true);
    }

    @Override
    public void forward(String prompt, String prompt1) {
        StringBuilder line = this.lines.get(this.currentLine);
        if (this.currentPosition == line.length()) {
            if (this.currentLine == this.lines.size() - 1) {
                return;
            }
            if (this.redrawDown(prompt, prompt1)) {
                this.terminal.setPositionRelative(prompt.length() - this.getCurrentPositionCoord((String)prompt).x, 0);
                this.currentPosition = 0;
                return;
            }
            ++this.currentLine;
            this.terminal.setPositionRelative(prompt.length() - this.getCurrentPositionCoord((String)prompt).x, 1);
            this.currentPosition = 0;
        } else {
            this.print(line.charAt(this.currentPosition));
            ++this.currentPosition;
        }
        this.positionChanged(true);
    }

    @Override
    public void ctrlforward(String prompt, String prompt1) {
        boolean isSpace;
        StringBuilder line = this.lines.get(this.currentLine);
        if (this.currentPosition == line.length()) {
            return;
        }
        boolean bl = isSpace = line.charAt(this.currentPosition) == ' ';
        while (this.currentPosition < line.length()) {
            this.forward(prompt, prompt1);
            if (this.currentPosition != line.length() && (!isSpace || line.charAt(this.currentPosition) == ' ') && (isSpace || line.charAt(this.currentPosition) != ' ')) continue;
        }
        this.positionChanged(true);
    }

    @Override
    public void ctrlhome() {
        if (this.currentPosition > 0) {
            this.terminal.back(this.currentPosition);
            this.currentPosition = 0;
            this.positionChanged(true);
        }
    }

    @Override
    public void ctrlend() {
        if (this.currentPosition < this.lines.get(this.currentLine).length()) {
            this.terminal.forward(this.lines.get(this.currentLine).length() - this.currentPosition, this.lines.get(this.currentLine).substring(this.currentPosition));
            this.currentPosition = this.lines.get(this.currentLine).length();
            this.positionChanged(true);
        }
    }

    @Override
    public void altup(String prompt, String prompt1) {
        Coord coord = this.getCurrentPositionCoord(prompt);
        if (this.currentLine == 0 && coord.y == 0) {
            return;
        }
        if (this.redrawUp(prompt, prompt1)) {
            return;
        }
        int dx = 0;
        if (coord.y == 0) {
            --this.currentLine;
            String line = this.lines.get(this.currentLine).toString();
            if (line.length() < this.currentPosition) {
                dx = line.length() - this.currentPosition;
                this.currentPosition = line.length();
            } else if (this.isMultiline(prompt, line)) {
                Coord coord1 = this.getPositionCoord(prompt, this.lines.get(this.currentLine));
                if (coord1.x <= this.currentPosition + prompt.length()) {
                    dx = coord1.x - (this.currentPosition + prompt.length());
                    this.currentPosition = line.length();
                } else {
                    this.currentPosition = line.length() - (coord1.x - (this.currentPosition + prompt.length()));
                }
            }
        } else if (coord.x > prompt.length() || coord.y > 1) {
            this.currentPosition -= this.terminal.getWidth();
        } else {
            this.currentPosition = 0;
            dx = prompt.length() - coord.x;
        }
        this.terminal.setPositionRelative(dx, -1);
        this.positionChanged(true);
    }

    @Override
    public void altdown(String prompt, String prompt1) {
        Coord coord = this.getCurrentPositionCoord(prompt);
        if (this.currentLine == this.lines.size() - 1 && coord.y == coord.linescount - 1) {
            return;
        }
        if (this.redrawDown(prompt, prompt1)) {
            return;
        }
        int dx = 0;
        if (coord.y == coord.linescount - 1) {
            ++this.currentLine;
            if (coord.x <= prompt.length()) {
                this.currentPosition = 0;
                dx = prompt.length() - coord.x;
            } else if (coord.x - prompt.length() > this.lines.get(this.currentLine).length()) {
                this.currentPosition = this.lines.get(this.currentLine).length();
                dx = this.lines.get(this.currentLine).length() - (coord.x - prompt.length());
            }
        } else {
            this.currentPosition += this.terminal.getWidth();
            if (this.currentPosition > this.lines.get(this.currentLine).length()) {
                dx = this.lines.get(this.currentLine).length() - this.currentPosition;
                this.currentPosition = this.lines.get(this.currentLine).length();
            }
        }
        this.terminal.setPositionRelative(dx, 1);
        this.positionChanged(true);
    }

    @Override
    public void del() {
        StringBuilder line = this.lines.get(this.currentLine);
        if (this.currentPosition == line.length() || line.length() == 0) {
            return;
        }
        line.deleteCharAt(this.currentPosition);
        this.print(line.substring(this.currentPosition));
        this.terminal.clearforward();
        this.terminal.back(line.length() - this.currentPosition + 1);
        this.positionChanged(true);
    }

    private boolean isMultiline(String prompt, String line) {
        return prompt.length() + line.length() > this.terminal.getWidth();
    }

    private Coord getCurrentPositionCoord(String prompt) {
        return this.getPositionCoord(prompt, this.lines.get(this.currentLine), this.currentPosition);
    }

    private Coord getPositionCoord(String prompt, StringBuilder line) {
        return this.getPositionCoord(prompt, line, line.length());
    }

    private Coord getPositionCoord(String prompt, StringBuilder line, int positionInLine) {
        int width = this.terminal.getWidth();
        int y = (prompt.length() + positionInLine) / width;
        int x = prompt.length() + positionInLine - width * y;
        int linescount = (prompt.length() + line.length()) / width + 1;
        return new Coord(x, y, linescount);
    }

    private int getLinesBelowCurrent(String prompt) {
        Coord coord = this.getCurrentPositionCoord(prompt);
        int linesBelow = coord.linescount - coord.y - 1;
        for (int i = this.currentLine + 1; i < this.lines.size(); ++i) {
            linesBelow += this.getPositionCoord((String)prompt, (StringBuilder)this.lines.get((int)i)).linescount;
        }
        return linesBelow;
    }

    private int getLinesUpperCurrent(String prompt) {
        Coord coord = this.getCurrentPositionCoord(prompt);
        int linesUpper = coord.y;
        for (int i = this.currentLine - 1; i >= 0; --i) {
            linesUpper += this.getPositionCoord((String)prompt, (StringBuilder)this.lines.get((int)i)).linescount;
        }
        return linesUpper;
    }

    private int getLinesCount(String prompt, StringBuilder line) {
        return this.getPositionCoord((String)prompt, (StringBuilder)line, (int)line.length()).linescount;
    }

    private boolean redrawUp(String prompt, String prompt1) {
        int linesBelow = this.getLinesBelowCurrent(prompt);
        if (linesBelow + 1 >= this.terminal.getHeight()) {
            --this.currentLine;
            this.terminal.clear();
            this.display(prompt, prompt1, this.currentLine, 0, true);
            this.positionChanged(true);
            return true;
        }
        return false;
    }

    private boolean redrawDown(String prompt, String prompt1) {
        int linesUpper = this.getLinesUpperCurrent(prompt);
        if (linesUpper + 1 >= this.terminal.getHeight()) {
            ++this.currentLine;
            this.terminal.clear();
            this.display(prompt, prompt1, this.currentLine - this.terminal.getHeight() + 1, 0, false);
            this.positionChanged(true);
            return true;
        }
        return false;
    }

    @Override
    public void display(String prompt, String prompt1) {
        for (int i = 0; i < this.lines.size(); ++i) {
            if (i == 0) {
                this.print(prompt);
            } else {
                this.println();
                this.print(prompt1);
            }
            this.print(this.lines.get(i).toString());
        }
        if (this.lines.size() > 0) {
            int dx = this.currentPosition - this.lines.get(this.lines.size() - 1).length();
            int dy = this.currentLine - this.lines.size() + 1;
            this.terminal.setPositionRelative(dx, dy);
        }
    }

    private void display(String prompt, String prompt1, int fromLine, int fromPosition, boolean positionAtBegining) {
        int linesCount = 0;
        int i = 0;
        for (i = fromLine; i < this.lines.size(); ++i) {
            if (i == 0) {
                this.print(prompt);
            } else if (i == fromLine) {
                this.print(prompt1);
            } else {
                this.println();
                this.print(prompt1);
            }
            this.print(this.lines.get(i).toString());
            if ((linesCount += this.getLinesCount(prompt, this.lines.get(i))) >= this.terminal.getHeight()) break;
        }
        if (positionAtBegining) {
            if (this.currentPosition > this.lines.get(fromLine).length()) {
                this.currentPosition = this.lines.get(fromLine).length();
            }
            int dx = this.currentPosition - this.lines.get(i < this.lines.size() ? i : this.lines.size() - 1).length();
            int dy = -linesCount;
            this.terminal.setPositionRelative(dx, dy);
        } else {
            int lastLength = this.lines.get(i < this.lines.size() ? i : this.lines.size() - 1).length();
            if (this.currentPosition > lastLength) {
                this.currentPosition = lastLength;
            }
            this.terminal.setPositionRelative(this.currentPosition - lastLength, 0);
        }
    }

    @Override
    public boolean isPositionChanged() {
        if (this.lines.size() == 0 || this.lines.size() == 1 && this.lines.get(0).length() == 0) {
            return false;
        }
        return this.positionChanged;
    }

    @Override
    public String toOneLineString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.lines.size(); ++i) {
            builder.append(this.lines.get(i).toString()).append(" ");
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    @Override
    public String toStringWithoutDelimiter(String delimiter) {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        int delimiterIndex = builder.lastIndexOf(delimiter);
        if (delimiterIndex != -1 && builder.substring(delimiterIndex).trim().equals(delimiter)) {
            builder.setLength(delimiterIndex);
        }
        if (builder.length() > 0 && builder.lastIndexOf("\n") == builder.length() - 1) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    @Override
    public String toStringWithDelimiter() {
        return this.toString(new StringBuilder()).toString();
    }

    public StringBuilder toString(StringBuilder builder) {
        for (int i = 0; i < this.lines.size(); ++i) {
            builder.append(this.lines.get(i).toString()).append("\n");
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    protected void print(char c) {
        this.terminal.getPrintStream().print(c);
    }

    protected void print(String s) {
        this.terminal.getPrintStream().print(s);
    }

    protected void println() {
        this.terminal.getPrintStream().println();
    }

    @Override
    public String getToCurrentPosition() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.currentLine; ++i) {
            if (i > 0 && builder.length() > 0 && builder.charAt(builder.length() - 1) != '\n') {
                builder.append('\n');
            }
            builder.append(this.lines.get(i).toString());
        }
        if (builder.length() > 0) {
            builder.append("\n");
        }
        if (this.currentPosition == 0) {
            return builder.toString();
        }
        builder.append(this.lines.get(this.currentLine).substring(0, this.currentPosition));
        return builder.toString();
    }

    static class Coord {
        int x;
        int y;
        int linescount;

        Coord(int x, int y, int linescount) {
            this.x = x;
            this.y = y;
            this.linescount = linescount;
        }
    }
}

