/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.value;

import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.value.AbstractStatementValue;

public class StatementParameterValue
extends AbstractStatementValue {
    private String value = null;
    private Character startDelimiter = null;
    private Character endDelimiter = null;
    private String prefix = null;
    private boolean isDataspaceReference = false;
    private Class<? extends AbstractParameter> parameterClass;

    public StatementParameterValue(String name, String value) {
        super(name);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(String defaultValue) {
        if (this.isPresent()) {
            return this.value;
        }
        return defaultValue;
    }

    public int getValue(int defaultValue) {
        if (this.isPresent()) {
            return Integer.valueOf(this.value);
        }
        return defaultValue;
    }

    public void setValue(String value) {
        this.value = value;
        this.setPresent(true);
    }

    public void setDelimiters(char startDelimiter, char endDelimiter) {
        this.startDelimiter = Character.valueOf(startDelimiter);
        this.endDelimiter = Character.valueOf(endDelimiter);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void print(StringBuilder builder) {
        if (!this.isPresent() || !this.isPrintable()) {
            return;
        }
        if (this.startDelimiter != null) {
            builder.append(this.startDelimiter);
        }
        if (this.prefix != null) {
            builder.append(this.prefix);
        }
        builder.append(this.value);
        if (this.endDelimiter != null) {
            builder.append(this.endDelimiter);
        }
    }

    public boolean isDataspaceReference() {
        return this.isDataspaceReference;
    }

    public StatementParameterValue setDataspaceReference(boolean dataspaceReference) {
        this.isDataspaceReference = dataspaceReference;
        return this;
    }

    public void setParameterClass(Class<? extends AbstractParameter> parameterClass) {
        this.parameterClass = parameterClass;
    }

    public Class<? extends AbstractParameter> getParameterClass() {
        return this.parameterClass;
    }
}

