/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.value;

import com.streamscape.slex.lang.value.AbstractStatementValue;
import com.streamscape.slex.lang.value.StatementBlockValue;
import com.streamscape.slex.lang.value.StatementByteParameterValue;
import com.streamscape.slex.lang.value.StatementModifierValue;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementSetValue;
import com.streamscape.slex.lang.value.StatementValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.ArrayList;
import java.util.List;

public class AbstractStatementValueList
extends AbstractStatementValue {
    protected ArrayList<StatementValue> values = new ArrayList();

    protected AbstractStatementValueList(String name) {
        super(name);
    }

    public StatementModifierValue addModifier(StatementModifierValue value) {
        return (StatementModifierValue)this.addValue(value);
    }

    public StatementModifierValue addModifier(String name, String value) {
        return this.addModifier(new StatementModifierValue(name, value));
    }

    public StatementModifierValue getModifier(String name) {
        StatementValue statementValue = this.getValue(name);
        if (statementValue != null && statementValue instanceof StatementModifierValue) {
            return (StatementModifierValue)statementValue;
        }
        StatementModifierValue modifierValue = new StatementModifierValue(name, "");
        modifierValue.setPresent(false);
        return modifierValue;
    }

    public boolean existsModifier(String name) {
        StatementValue statementValue = this.getValue(name);
        return statementValue != null && statementValue instanceof StatementModifierValue;
    }

    public List<String> listModifiers() {
        ArrayList<String> result = new ArrayList<String>();
        for (StatementValue value : this.values) {
            if (!(value instanceof StatementModifierValue)) continue;
            result.add(value.getName());
        }
        return result;
    }

    public StatementParameterValue addParameter(StatementParameterValue value) {
        return (StatementParameterValue)this.addValue(value);
    }

    public StatementParameterValue addParameter(String name, String value) {
        return this.addParameter(new StatementParameterValue(name, value));
    }

    public StatementParameterValue getParameter(String name) {
        StatementValue statementValue = this.getValue(name);
        if (statementValue != null && statementValue instanceof StatementParameterValue) {
            return (StatementParameterValue)statementValue;
        }
        StatementParameterValue parameterValue = new StatementParameterValue(name, null);
        parameterValue.setPresent(false);
        return parameterValue;
    }

    public StatementByteParameterValue addByteParameter(StatementByteParameterValue value) {
        return (StatementByteParameterValue)this.addValue(value);
    }

    public StatementByteParameterValue addByteParameter(String name, byte[] value) {
        return this.addByteParameter(new StatementByteParameterValue(name, value));
    }

    public StatementByteParameterValue getByteParameter(String name) {
        StatementValue statementValue = this.getValue(name);
        if (statementValue != null && statementValue instanceof StatementByteParameterValue) {
            return (StatementByteParameterValue)statementValue;
        }
        StatementByteParameterValue parameterValue = new StatementByteParameterValue(name, null);
        parameterValue.setPresent(false);
        return parameterValue;
    }

    public boolean existsParameter(String name) {
        StatementValue statementValue = this.getValue(name);
        return statementValue != null && statementValue instanceof StatementParameterValue;
    }

    public List<String> listParameters() {
        ArrayList<String> result = new ArrayList<String>();
        for (StatementValue value : this.values) {
            if (!(value instanceof StatementParameterValue)) continue;
            result.add(value.getName());
        }
        return result;
    }

    public StatementBlockValue addBlock(StatementBlockValue value) {
        return (StatementBlockValue)this.addValue(value);
    }

    public StatementBlockValue getBlock(String name) {
        StatementValue statementValue = this.getValue(name);
        if (statementValue != null && statementValue instanceof StatementBlockValue) {
            return (StatementBlockValue)statementValue;
        }
        StatementBlockValue blockValue = new StatementBlockValue(name, "");
        blockValue.setPresent(false);
        return blockValue;
    }

    public boolean existsBlock(String name) {
        StatementValue statementValue = this.getValue(name);
        return statementValue != null && statementValue instanceof StatementBlockValue;
    }

    public List<String> listBlocks() {
        ArrayList<String> result = new ArrayList<String>();
        for (StatementValue value : this.values) {
            if (!(value instanceof StatementBlockValue)) continue;
            result.add(value.getName());
        }
        return result;
    }

    public StatementSetValue addSet(StatementSetValue value) {
        return (StatementSetValue)this.addValue(value);
    }

    public StatementSetValue getSet(String name) {
        StatementValue statementValue = this.getValue(name);
        if (statementValue != null && statementValue instanceof StatementSetValue) {
            return (StatementSetValue)statementValue;
        }
        StatementSetValue arrayValue = new StatementSetValue(name);
        arrayValue.setPresent(false);
        return arrayValue;
    }

    public boolean existsSet(String name) {
        StatementValue statementValue = this.getValue(name);
        return statementValue != null && statementValue instanceof StatementSetValue;
    }

    public List<String> listSets() {
        ArrayList<String> result = new ArrayList<String>();
        for (StatementValue value : this.values) {
            if (!(value instanceof StatementSetValue)) continue;
            result.add(value.getName());
        }
        return result;
    }

    public StatementValue addValue(StatementValue value) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        this.values.add(value);
        return value;
    }

    public StatementValue getValue(String name) {
        if (this.values != null) {
            for (StatementValue value : this.values) {
                if (!value.getName().equals(name)) continue;
                return value;
            }
        }
        return null;
    }

    public StatementValue getValue(int index) {
        if (this.values != null && index >= 0 && index < this.values.size()) {
            return this.values.get(index);
        }
        return null;
    }

    public boolean existsValue(String name) {
        StatementValue statementValue = this.getValue(name);
        return statementValue != null;
    }

    public List<String> listValues() {
        ArrayList<String> result = new ArrayList<String>();
        for (StatementValue value : this.values) {
            result.add(value.getName());
        }
        return result;
    }

    public void removeValue(String name) {
        if (this.values != null) {
            int index;
            for (index = 0; index < this.values.size() && !this.values.get(index).getName().equalsIgnoreCase(name); ++index) {
            }
            if (index < this.values.size()) {
                this.values.remove(index);
            }
        }
    }

    public int getValuesCount() {
        return this.values.size();
    }

    public void clear() {
        this.values.clear();
    }

    public int size() {
        return this.values.size();
    }

    public void addAll(StatementValueList list) {
        this.values.addAll(list.values);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.print(builder);
        return builder.toString();
    }

    @Override
    public void print(StringBuilder builder) {
        if (!this.isPresent()) {
            return;
        }
        if (!this.isPrintable()) {
            return;
        }
        if (this.values != null) {
            for (int i = 0; i < this.values.size(); ++i) {
                if (i != 0) {
                    builder.append(" ");
                }
                this.values.get(i).print(builder);
            }
        }
    }
}

