/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.trie;

import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.trie.TrieNode;
import com.streamscape.tools.lexer.BufferUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TrieParseContext<T extends SLCallable> {
    private String script;
    private int position;
    private T callable;
    private MFSession session;
    private AbstractDSLOperation<T> operation;
    private List<TrieNode> processedNodes = new ArrayList<TrieNode>();
    private List<AbstractModifier<?>> processedModifiers = new ArrayList();
    private Map<TrieNode, TrieNode> parents = new HashMap<TrieNode, TrieNode>();
    private List<TrieNode> blockNodes;
    private DSLCompletion parameterCompletion;
    private DSLCompletion partialParameterCompletion;
    private int lineNumber = 1;

    TrieParseContext(String script, T callable, MFSession session, AbstractDSLOperation<T> operation) {
        this.script = script;
        this.position = 0;
        this.callable = callable;
        this.session = session;
        this.operation = operation;
    }

    boolean hasNext() {
        return this.position < this.script.length();
    }

    boolean isAtEnd() {
        return this.position >= this.script.length();
    }

    char next() {
        this.checkPosition();
        this.increaseLineNumbers(this.position, this.position + 1);
        return this.script.charAt(this.position++);
    }

    char current() {
        if (this.position - 1 >= this.script.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this.position == 0 ? this.script.charAt(this.position) : this.script.charAt(this.position - 1);
    }

    String getRemainingScript() {
        if (this.position - 1 >= this.script.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this.position == 0 ? this.script.substring(this.position) : this.script.substring(this.position - 1);
    }

    public String getProcessedScript() {
        return this.position <= 1 ? "" : this.script.substring(0, this.position > this.script.length() ? this.script.length() - 1 : this.position - 1);
    }

    int position() {
        return this.position;
    }

    int length() {
        return this.script.length();
    }

    void skip(int n) {
        if (n > 0) {
            this.increaseLineNumbers(this.position, this.position + n);
        } else {
            this.decreaseLineNumbers(this.position + n, this.position);
        }
        this.position += n;
    }

    String getScript() {
        return this.script;
    }

    int getPosition() {
        return this.position;
    }

    int getLineNumber() {
        return this.lineNumber;
    }

    void checkPosition() {
        if (this.position >= this.script.length()) {
            throw new IndexOutOfBoundsException();
        }
    }

    boolean skipMultilineComments() {
        int oldPosition = this.position;
        this.position = BufferUtils.skipMultilineComments(this.script, this.position);
        this.increaseLineNumbers(oldPosition, this.position);
        return oldPosition != this.position;
    }

    boolean skipOneLineComments() {
        int oldPosition = this.position;
        this.position = BufferUtils.skipOneLineComments(this.script, this.position);
        this.increaseLineNumbers(oldPosition, this.position);
        return oldPosition != this.position;
    }

    public boolean skipSpaces() {
        int oldPosition = this.position;
        this.position = BufferUtils.skipSpaces(this.script, this.position);
        this.increaseLineNumbers(oldPosition, this.position);
        return oldPosition != this.position;
    }

    private void increaseLineNumbers(int startPosition, int endPosition) {
        this.applyLineNumbers(startPosition, endPosition, 1);
    }

    private void decreaseLineNumbers(int startPosition, int endPosition) {
        this.applyLineNumbers(startPosition > 0 ? startPosition : 0, endPosition, -1);
    }

    private void applyLineNumbers(int startPosition, int endPosition, int offset) {
        while (startPosition < endPosition && startPosition < this.script.length()) {
            if (!BufferUtils.isNewLine(this.script.charAt(startPosition++))) continue;
            this.lineNumber += offset;
        }
    }

    T getCallable() {
        return this.callable;
    }

    MFSession getSession() {
        return this.session;
    }

    AbstractDSLOperation<T> getOperation() {
        return this.operation;
    }

    public void addModifier(AbstractModifier<?> modifier, TrieNode node) {
        this.processedModifiers.add(modifier);
        this.addProcessedNode(node);
    }

    public List<AbstractModifier<?>> getProcessedModifiers() {
        return this.processedModifiers;
    }

    public void addProcessedNode(TrieNode node) {
        if (node.isRepeatable()) {
            return;
        }
        if (!this.processedNodes.contains(node)) {
            this.processedNodes.add(node);
        }
        this.addToBlockNodes(node);
    }

    public boolean isNodeProcessed(TrieNode node) {
        return this.processedNodes.contains(node);
    }

    public boolean isClosestDataNodeProcessed(TrieNode node) {
        if (this.processedNodes.contains(node)) {
            return true;
        }
        while (node != null && node.getData() == null) {
            node = node.getParent() != null ? node.getParent()[0] : null;
        }
        return node != null && this.isNodeProcessed(node);
    }

    public boolean isAllProcessedNodesLeftThan(TrieNode node) {
        for (TrieNode processedNode : this.processedNodes) {
            if (!node.isLeftThen(this, processedNode)) continue;
            return false;
        }
        return true;
    }

    public void setParentFor(TrieNode parent, TrieNode child) {
        this.parents.put(child, parent);
        this.addToBlockNodes(child);
    }

    public TrieNode getParentFor(TrieNode child) {
        return this.parents.get(child);
    }

    public void addToBlockNodes(TrieNode node) {
        if (this.blockNodes != null && !this.blockNodes.contains(node)) {
            this.blockNodes.add(node);
        }
    }

    public void startBlockModifier() {
        this.removeBlockNodes();
        this.blockNodes = new ArrayList<TrieNode>();
    }

    public void endBlockModifier() {
        this.removeBlockNodes();
        this.blockNodes = null;
    }

    private void removeBlockNodes() {
        if (this.blockNodes == null) {
            return;
        }
        for (TrieNode node : this.blockNodes) {
            if (node.isRepeatable()) {
                this.processedNodes.remove(node);
            }
            this.parents.remove(node);
        }
    }

    public void setParameterCompletion(DSLCompletion parameterCompletion) {
        this.parameterCompletion = parameterCompletion;
    }

    public DSLCompletion getParameterCompletion() {
        return this.parameterCompletion;
    }

    public void setPartialParameterCompletion(DSLCompletion partialParameterCompletion) {
        this.partialParameterCompletion = partialParameterCompletion;
    }

    public DSLCompletion getPartialParameterCompletion() {
        return this.partialParameterCompletion;
    }
}

