/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.trie;

import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.Suggestion;
import com.streamscape.slex.lang.completion.SuggestionSequence;
import com.streamscape.slex.lang.completion.SyntaxSuggestion;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.SyntaxToken;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.trie.TrieParseContext;
import com.streamscape.slex.lang.value.StatementValueList;
import com.streamscape.tools.lexer.BufferUtils;
import com.streamscape.tools.parser.ParserException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class TrieNode {
    private TrieNode[] parent;
    private char character = '\u0000';
    private boolean caseSensitive;
    private ArrayList<TrieNode> childs = null;
    private SyntaxToken<?> data = null;
    private TrieNode backwardLink = null;
    private int index;
    private boolean isRepeatable;
    private boolean isAggregate;

    public TrieNode(TrieNode parent, char character) {
        this(parent, character, false);
    }

    TrieNode(TrieNode parent, char character, boolean caseSensitive) {
        TrieNode[] trieNodeArray;
        if (parent != null) {
            TrieNode[] trieNodeArray2 = new TrieNode[1];
            trieNodeArray = trieNodeArray2;
            trieNodeArray2[0] = parent;
        } else {
            trieNodeArray = null;
        }
        this.parent = trieNodeArray;
        this.character = character;
        this.caseSensitive = caseSensitive;
        this.isRepeatable = false;
        this.isAggregate = false;
        this.index = this.parent == null ? 0 : this.parent[0].nextIndex();
    }

    public TrieNode[] getParent() {
        return this.parent;
    }

    public void addParent(TrieNode parent) {
        TrieNode[] old = this.parent;
        this.parent = new TrieNode[this.parent.length + 1];
        System.arraycopy(old, 0, this.parent, 0, old.length);
        this.parent[this.parent.length - 1] = parent;
    }

    public int getIndex() {
        return this.index;
    }

    private int nextIndex() {
        if (this.parent == null) {
            return this.index++;
        }
        return this.parent[0].nextIndex();
    }

    public void setRepeatable(boolean isRepeatable) {
        this.isRepeatable = isRepeatable;
    }

    public boolean isRepeatable() {
        return this.isRepeatable;
    }

    public void setAggregate(boolean isAggregate) {
        this.isAggregate = isAggregate;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public SyntaxToken<?> getData() {
        return this.data;
    }

    public void setData(SyntaxToken<?> data) {
        this.data = data;
    }

    public void setBackwardLink(TrieNode backwardLink) {
        this.backwardLink = backwardLink;
    }

    public TrieNode getBackwardLink() {
        return this.backwardLink;
    }

    public boolean equalsCharacter(char character) {
        return this.caseSensitive ? this.character == character : Character.toLowerCase(this.character) == Character.toLowerCase(character);
    }

    public boolean equalsCharacter(char character, boolean caseSensitive) {
        return this.caseSensitive == caseSensitive && (this.caseSensitive ? this.character == character : Character.toLowerCase(this.character) == Character.toLowerCase(character));
    }

    public boolean hasChilds() {
        return this.childs != null && this.childs.size() > 0;
    }

    public boolean hasOneAggregateChildWithoutChilds() {
        return this.childs != null && this.childs.size() == 1 && this.childs.get(0).isAggregate() && !this.childs.get(0).hasChilds();
    }

    TrieNode lookupChild(char character) {
        return this.lookupChild(character, false);
    }

    TrieNode lookupChild(char character, TrieParseContext<?> context) {
        return this.lookupChild(character, false, context);
    }

    TrieNode lookupChild(char character, boolean caseSensitive) {
        return this.lookupChild(character, false, null);
    }

    TrieNode lookupChild(char character, boolean caseSensitive, TrieParseContext<?> context) {
        if (!this.hasChilds()) {
            return null;
        }
        for (TrieNode node : this.childs) {
            if (!node.equalsCharacter(character, caseSensitive) && (context == null || node.character != '\u0000' || context.isNodeProcessed(node))) continue;
            return node;
        }
        return null;
    }

    public void appendChild(TrieNode child) {
        if (this.childs == null) {
            this.childs = new ArrayList();
        }
        this.childs.add(child);
    }

    public TrieNode createChild(char character) {
        return this.createChild(character, false);
    }

    TrieNode createChild(char character, boolean caseSensitive) {
        if (this.childs == null) {
            this.childs = new ArrayList();
        }
        TrieNode child = new TrieNode(this, character, caseSensitive);
        this.childs.add(child);
        return child;
    }

    public void removeChild(TrieNode child) {
        if (child == null) {
            return;
        }
        this.childs.remove(child);
    }

    public TrieNode add(String s) {
        return this.add(s, false);
    }

    public TrieNode add(String s, boolean caseSensitive) {
        if (s == null || s.length() == 0) {
            return null;
        }
        TrieNode parent = this;
        boolean space = false;
        for (char c : s.toCharArray()) {
            if (TrieNode.isSpace(c)) {
                c = ' ';
                if (space) continue;
                space = true;
            } else {
                space = false;
            }
            TrieNode child = parent.lookupChild(c, caseSensitive);
            if (child == null) {
                child = parent.createChild(c, caseSensitive);
            }
            parent = child;
        }
        return parent;
    }

    public TrieNode parse(TrieParseContext<?> context) {
        while (context.skipSpaces() || context.skipMultilineComments() || context.skipOneLineComments()) {
        }
        TrieNode node = this.processDataAndBackwardLink(context);
        if (node == null) {
            return null;
        }
        boolean wasSpace = false;
        while (context.hasNext()) {
            TrieNode childNode;
            char c = ' ';
            if (context.skipSpaces() || context.skipMultilineComments() || context.skipOneLineComments()) {
                if (wasSpace) continue;
                c = ' ';
                wasSpace = true;
            } else {
                c = context.next();
                wasSpace = false;
            }
            if (node == null) {
                return null;
            }
            if (TrieNode.isDelimiter(node.character) && c == ' ' && ((childNode = node.lookupChild(c, context)) == null || childNode.character != ' ')) continue;
            childNode = node.lookupChild(c, context);
            if (childNode == null && TrieNode.isDelimiter(c) && (childNode = node.lookupChild(' ', context)) != null) {
                childNode = childNode.lookupChild(c, context);
            }
            if (childNode == null) {
                if (node.getBackwardLink() != null) {
                    node = node.getBackwardLink();
                    context.skip(-1);
                    continue;
                }
                if (node.getData() instanceof Modifier) {
                    node = node.lookupChild(' ', context);
                    context.skip(-1);
                    continue;
                }
                return null;
            }
            if (childNode.getParent() != null && childNode.getParent().length > 1) {
                context.setParentFor(node, childNode);
            }
            node = childNode;
            if ((node = node.processDataAndBackwardLink(context)) == null) {
                return null;
            }
            while (c == ' ' && node.character == ' ' && node.childs != null && node.childs.size() == 1 && node.childs.get((int)0).character == ' ') {
                childNode = node.childs.get(0);
                if (childNode.getParent() != null && childNode.getParent().length > 1) {
                    context.setParentFor(node, childNode);
                }
                node = childNode;
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    TrieNode processDataAndBackwardLink(TrieParseContext<?> context) {
        block29: {
            if (this.data != null) {
                if (this.data instanceof BlockModifier) {
                    if (this.character == '(') {
                        context.startBlockModifier();
                    } else if (this.character == ')') {
                        context.endBlockModifier();
                    }
                    context.addProcessedNode(this);
                    context.addModifier((AbstractModifier)this.data, this);
                } else if (this.data instanceof AbstractModifier) {
                    context.addProcessedNode(this);
                    context.addModifier((AbstractModifier)this.data, this);
                } else if (this.data instanceof SyntaxParameter && context.getRemainingScript().trim().length() > 0) {
                    context.addProcessedNode(this);
                    SyntaxParameter parameter = (SyntaxParameter)this.data;
                    StatementValueList statement = new StatementValueList("templist");
                    String script = context.getRemainingScript();
                    String processedScript = context.getProcessedScript();
                    ScriptParser parser = new ScriptParser(script);
                    int position = context.getPosition() - 1;
                    if (position < 0) {
                        position = 0;
                    }
                    try {
                        if (parameter.isEndDelimiterToCommandEnd() && parameter.isCompletionable()) {
                            context.setParameterCompletion(parameter.complete(script, processedScript, context.getCallable(), context.getSession()));
                            this.setLineNumberAndPositionsForCompletionException(context.getParameterCompletion(), context, script, position);
                            if (context.getParameterCompletion() != null) {
                                return null;
                            }
                            break block29;
                        }
                        if (parameter.parse(statement, parser) == null) {
                            if (!this.data.isRequired()) {
                                int toSkipCount = script.length() - 1;
                                context.skip(toSkipCount);
                                try {
                                    if (context.isAtEnd() && parameter.isCompletionable()) {
                                        DSLCompletion completion = parameter.complete(script, processedScript, context.getCallable(), context.getSession());
                                        if (completion == null) {
                                            TrieNode trieNode = this.parent[0];
                                            return trieNode;
                                        }
                                        this.setLineNumberAndPositionsForCompletionException(context.getParameterCompletion(), context, script, position);
                                        context.setPartialParameterCompletion(completion);
                                        TrieNode trieNode = this.parent[0];
                                        return trieNode;
                                    }
                                    TrieNode completion = this.parent[0];
                                    return completion;
                                }
                                finally {
                                    context.skip(-1 - toSkipCount);
                                }
                            }
                            break block29;
                        }
                        int toSkipCount = parser.getPosition() - 1;
                        context.skip(toSkipCount);
                        if ((!context.isAtEnd() || !parameter.isCompletionable()) && !parameter.isAlwaysComplete()) break block29;
                        if (!context.isAtEnd()) {
                            script = script.substring(0, toSkipCount);
                        }
                        DSLCompletion completion = parameter.complete(script, processedScript, context.getCallable(), context.getSession());
                        if (!context.isAtEnd() && (completion == null || completion.getException() == null)) break block29;
                        if (completion == null) {
                            if (!this.data.isRequired()) {
                                context.skip(-1 - toSkipCount);
                                return this.parent[0];
                            }
                            break block29;
                        }
                        this.setLineNumberAndPositionsForCompletionException(completion, context, script, position);
                        if (this.data.isRequired()) {
                            context.setParameterCompletion(completion);
                            return null;
                        }
                        context.setPartialParameterCompletion(completion);
                        context.skip(-1 - toSkipCount);
                        return this.parent[0];
                    }
                    catch (DSLSyntaxValidationException exception) {
                        if (parameter.isCompletionable()) {
                            context.setParameterCompletion(parameter.complete(script, processedScript, context.getCallable(), context.getSession()));
                            this.setLineNumberAndPositionsForCompletionException(context.getParameterCompletion(), context, script, position);
                            return null;
                        }
                        if (!parameter.isRequired()) break block29;
                        return null;
                    }
                }
            }
        }
        if (this.backwardLink == null) return this;
        if (!this.isAllChildsProcessed(context)) return this;
        if (!(this.backwardLink.data instanceof BlockModifier)) return this.backwardLink;
        if (this.backwardLink.character == '(') {
            context.startBlockModifier();
            return this.backwardLink;
        }
        if (this.backwardLink.character != ')') return this.backwardLink;
        context.endBlockModifier();
        return this.backwardLink;
    }

    private void setLineNumberAndPositionsForCompletionException(DSLCompletion completion, TrieParseContext<?> context, String script, int scriptPosition) {
        if (completion == null || completion.getException() == null || !(completion.getException() instanceof ParserException)) {
            return;
        }
        ParserException exception = (ParserException)completion.getException();
        if (exception.getLineNumber() <= 0 || exception.getPositionInLine() < 0) {
            return;
        }
        int position = BufferUtils.getAbsolutePosition(script, exception.getLineNumber(), exception.getPositionInLine() - 1);
        BufferUtils.setLineAndPositions(exception, context.getScript(), position += scriptPosition);
    }

    private void setLineNumberAndPositionsForCompletionException(DSLCompletion completion, TrieParseContext<?> context) {
        if (completion == null || completion.getException() == null || !(completion.getException() instanceof ParserException)) {
            return;
        }
        ParserException exception = (ParserException)completion.getException();
        if (exception.getLineNumber() <= 0 || exception.getPositionInLine() < 0) {
            return;
        }
        BufferUtils.setLineAndPositions(exception, context.getScript(), context.getPosition() > 0 ? context.getPosition() - 1 : 0);
    }

    public TrieNode complete(TrieParseContext<?> context, DSLCompletion completion) {
        Suggestion suggestion;
        boolean isPrefixExists;
        TrieNode node = this;
        while (node.getBackwardLink() != null && node.isAllChildsProcessed(context)) {
            node = node.getBackwardLink();
        }
        String prefix = this.buildPrefix(context);
        boolean bl = isPrefixExists = prefix.length() > 0;
        if (node.getData() instanceof SyntaxParameter && !((SyntaxParameter)node.getData()).isCompletionable()) {
            prefix = "";
        }
        do {
            DSLCompletion c;
            TrieNode child = null;
            if (node.childs != null && node.childs.size() == 1 && (node.childs.get((int)0).character == ' ' || isPrefixExists || node.isInTheMiddleOfModifier(context) || node.existsNotProcessedRequiredChild(context))) {
                child = node.childs.get(0);
            }
            if (child == null && node.countOfNotProcessedDataChilds(context, false) > 1) break;
            if (child == null) {
                child = node.getFirstNotProcessedRequiredChild(context);
            }
            if (child == null) break;
            if (child.data != null) {
                isPrefixExists = false;
            }
            if (child.getParent() != null && child.getParent().length > 1) {
                context.setParentFor(node, child);
            }
            node = child;
            if (context.isAtEnd() && this.childs != null && this.childs.get(0) == node && node.getData() instanceof SyntaxParameter && ((SyntaxParameter)node.getData()).isCompletionable() && !context.isNodeProcessed(node) && (c = ((SyntaxParameter)node.getData()).complete("", context.getProcessedScript(), context.getCallable(), context.getSession())) != null) {
                completion.setCompletion(c.getCompletion());
                completion.setSuggestions(c.getSuggestions());
                completion.setException(c.getException());
                this.setLineNumberAndPositionsForCompletionException(completion, context);
                return null;
            }
            if (node.data == null) continue;
            context.addProcessedNode(node);
        } while (context.getProcessedModifiers().size() != 0 || node.character != ' ');
        context.addProcessedNode(node);
        List<TrieNode> nodes = node.buildNodesUpTo(context, this);
        if (nodes != null) {
            boolean needToCheck = false;
            TrieNode lastDataNode = null;
            for (TrieNode n : nodes) {
                if (!needToCheck && (n.character == ' ' || n.getData() != null)) break;
                needToCheck = true;
                if (n.getData() == null) continue;
                lastDataNode = n;
            }
            if (lastDataNode != null) {
                node = lastDataNode;
            }
        }
        if ((suggestion = node.buildCompletionUpToNode(context, this)) != null) {
            suggestion = suggestion.asSequence().prependPrefix(prefix).compress();
            completion.setCompletion(suggestion);
        } else if (prefix != null && prefix.length() > 0) {
            completion.setCompletion(new TokenSuggestion(prefix).setOffset(prefix.length()));
        }
        return node;
    }

    public void buildSuggestions(final TrieParseContext<?> context, DSLCompletion completion) {
        TrieNode node = this;
        if (!this.hasChilds() && this.getBackwardLink() != null) {
            node = this.getBackwardLink();
        }
        final ArrayList leafs = new ArrayList();
        final TrieNode topNode = node;
        topNode.accept(new Visitor(){

            @Override
            public boolean visit(TrieNode node) {
                List<TrieNode> nodes;
                if (topNode != node && node.getData() instanceof BlockModifier && node.equalsCharacter('(') && context.isNodeProcessed(node)) {
                    return false;
                }
                if (node != topNode && node.childs != null && node.childs.size() > 1 && (nodes = node.buildNodesUpTo(context, topNode)) != null && nodes.size() > 0) {
                    boolean weAreAtTheGoodEnd = true;
                    TrieNode lastDataNode = null;
                    for (TrieNode n : nodes) {
                        if (weAreAtTheGoodEnd && (n.character == ' ' || n.getData() != null)) break;
                        weAreAtTheGoodEnd = false;
                        if (n.getData() == null) continue;
                        lastDataNode = n;
                    }
                    if (lastDataNode == null && weAreAtTheGoodEnd) {
                        weAreAtTheGoodEnd = false;
                        for (TrieNode n : nodes) {
                            if (n.getData() == null) continue;
                            weAreAtTheGoodEnd = true;
                            break;
                        }
                        if (weAreAtTheGoodEnd) {
                            lastDataNode = node;
                        }
                    }
                    if (lastDataNode != null) {
                        if (!leafs.contains(lastDataNode) && !context.isClosestDataNodeProcessed(lastDataNode) && (lastDataNode.isRepeatable() || lastDataNode.parent != null && lastDataNode.parent[0].isRepeatable()) || context.isAllProcessedNodesLeftThan(lastDataNode)) {
                            leafs.add(lastDataNode);
                        }
                        return false;
                    }
                }
                if (node.hasChilds() && !node.hasOneAggregateChildWithoutChilds()) {
                    return true;
                }
                if (!leafs.contains(node) && !node.isAggregate() && !context.isClosestDataNodeProcessed(node) && context.isAllProcessedNodesLeftThan(node)) {
                    leafs.add(node);
                }
                return true;
            }
        }, context);
        Collections.sort(leafs, new Comparator<TrieNode>(this){

            @Override
            public int compare(TrieNode node1, TrieNode node2) {
                return node1.getIndex() - node2.getIndex();
            }
        });
        for (TrieNode leaf : leafs) {
            List<Suggestion> suggestions = leaf.buildAllCompletionsUpToNode(context, node);
            if (suggestions == null) continue;
            for (Suggestion suggestion : suggestions) {
                suggestion = suggestion.asSequence().prepend(completion.getCompletion()).compress();
                completion.addSuggestion(suggestion);
            }
        }
    }

    public List<TrieNode> buildNodesUpTo(TrieParseContext<?> context, TrieNode top) {
        ArrayList<TrieNode> nodes = new ArrayList<TrieNode>();
        if (this != top) {
            TrieNode node = this;
            do {
                nodes.add(node);
                if (node.parent != null) {
                    TrieNode p = null;
                    if (node.parent.length > 1) {
                        p = context.getParentFor(node);
                    }
                    node = p != null ? p : node.parent[0];
                    continue;
                }
                node = null;
            } while (node != null && node != top);
            if (node != top) {
                nodes.clear();
            }
        }
        return nodes;
    }

    private Suggestion buildCompletionUpToNode(TrieParseContext<?> context, TrieNode top) {
        if (this == top) {
            return null;
        }
        TrieNode node = this;
        List<TrieNode> nodes = node.buildNodesUpTo(context, top);
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        SuggestionSequence sequence = new SuggestionSequence();
        StringBuilder builder = null;
        for (int i = nodes.size() - 1; i >= 0; --i) {
            node = nodes.get(i);
            if (node.character != '\u0000') {
                if (builder == null) {
                    builder = new StringBuilder();
                }
                if (TrieNode.isDelimiter(node.character) && builder.length() > 0 && TrieNode.isSpace(builder.charAt(builder.length() - 1))) {
                    builder.setLength(builder.length() - 1);
                }
                builder.append(node.character);
            }
            if (node.character != '\u0000' && !(node.data instanceof SyntaxParameter) && i != 0) continue;
            if (builder != null) {
                sequence.add(new TokenSuggestion(builder.toString()));
                builder = null;
            }
            if (!(node.data instanceof SyntaxParameter)) continue;
            sequence.add(new SyntaxSuggestion(null, node.data.getSyntax()));
        }
        return sequence;
    }

    private List<Suggestion> buildAllCompletionsUpToNode(TrieParseContext<?> context, TrieNode top) {
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        if (this != top) {
            TrieNode node = this;
            ArrayList<TrieNode> nodes = new ArrayList<TrieNode>();
            do {
                nodes.add(node);
                if (node.parent != null) {
                    if (node.parent.length > 1) {
                        for (TrieNode p : node.parent) {
                            if (context.isNodeProcessed(p) && !p.isRepeatable()) continue;
                            suggestions.addAll(p.buildAllCompletionsUpToNode(context, top));
                        }
                        break;
                    }
                    TrieNode p = context.getParentFor(node);
                    if (p == null) {
                        p = node.parent[0];
                    }
                    node = p;
                    continue;
                }
                node = null;
            } while (node != null && node != top);
            if (node != null) {
                SuggestionSequence sequence = this.buildSuggestionFromNodesSequence(nodes);
                if (suggestions.size() > 0) {
                    for (int i = 0; i < suggestions.size(); ++i) {
                        if (((Suggestion)suggestions.get(i)).getDisplayString().endsWith(" ") && sequence.getDisplayString().startsWith(" ") && sequence.size() > 0 && sequence.get(0).getToken() != null && sequence.get(0).getToken().startsWith(" ")) {
                            sequence.get(0).setToken(sequence.get(0).getToken().substring(1));
                        }
                        suggestions.set(i, ((Suggestion)suggestions.get(i)).asSequence().add(sequence));
                    }
                } else {
                    suggestions.add(sequence);
                }
            }
        }
        return suggestions;
    }

    private SuggestionSequence buildSuggestionFromNodesSequence(List<TrieNode> nodes) {
        SuggestionSequence sequence = new SuggestionSequence();
        StringBuilder builder = null;
        for (int i = nodes.size() - 1; i >= 0; --i) {
            TrieNode node = nodes.get(i);
            if (node.character != '\u0000') {
                if (builder == null) {
                    builder = new StringBuilder();
                }
                if (TrieNode.isDelimiter(node.character) && builder.length() > 0 && TrieNode.isSpace(builder.charAt(builder.length() - 1))) {
                    builder.setLength(builder.length() - 1);
                }
                builder.append(node.character);
            }
            if (node.character != '\u0000' && !(node.data instanceof SyntaxParameter) && i != 0) continue;
            if (builder != null) {
                sequence.add(new TokenSuggestion(builder.toString()));
                builder = null;
            }
            if (!(node.data instanceof SyntaxParameter)) continue;
            sequence.add(new SyntaxSuggestion(null, node.data.getSyntax()));
        }
        return sequence;
    }

    private String buildPrefix(TrieParseContext<?> context) {
        int n = 0;
        String result = "";
        if (context.isAtEnd()) {
            while (context.position() > 0 && !TrieNode.isDelimiter(context.current())) {
                context.skip(-1);
                ++n;
            }
            if (n > 0) {
                context.skip(1);
                --n;
            }
            if ((result = context.getRemainingScript()).length() == 1 && TrieNode.isDelimiter(result.charAt(0))) {
                result = "";
            }
            context.skip(n);
        }
        return result;
    }

    public void accept(Visitor visitor, TrieParseContext<?> context) {
        if (!visitor.visit(this)) {
            return;
        }
        if (this.childs != null) {
            for (TrieNode child : this.childs) {
                TrieNode oldParent = null;
                if (context != null) {
                    oldParent = context.getParentFor(child);
                    if (child.getParent() != null && child.getParent().length > 1) {
                        context.setParentFor(this, child);
                    }
                }
                child.accept(visitor, context);
                if (context == null) continue;
                context.setParentFor(oldParent, child);
            }
        }
    }

    private boolean isAllChildsProcessed(final TrieParseContext<?> context) {
        if (this.childs == null) {
            return true;
        }
        final boolean[] result = new boolean[]{true};
        for (TrieNode child : this.childs) {
            if (!result[0]) break;
            child.accept(new LeafNodesVisitor(this){

                @Override
                public boolean onLeafNode(TrieNode node) {
                    result[0] = result[0] & context.isClosestDataNodeProcessed(node);
                    return result[0];
                }
            }, context);
        }
        return result[0];
    }

    public boolean existsNotProcessedRequiredChild(final TrieParseContext<?> context) {
        final boolean[] result = new boolean[]{false};
        final TrieNode startNode = this;
        this.accept(new Visitor(){

            @Override
            public boolean visit(TrieNode node) {
                if (node == startNode) {
                    return true;
                }
                if (node.getData() != null) {
                    if (node.getData().isRequired() && !context.isNodeProcessed(node)) {
                        result[0] = true;
                    }
                    return false;
                }
                return true;
            }
        }, context);
        return result[0];
    }

    private int countOfNotProcessedDataChilds(final TrieParseContext<?> context, final boolean required) {
        final int[] result = new int[]{0};
        final TrieNode startNode = this;
        this.accept(new Visitor(){

            @Override
            public boolean visit(TrieNode node) {
                if (node == startNode) {
                    return true;
                }
                if (node.getData() != null && (!required || node.getData().isRequired())) {
                    if (!context.isNodeProcessed(node)) {
                        result[0] = result[0] + 1;
                    }
                    return false;
                }
                return true;
            }
        }, context);
        return result[0];
    }

    private TrieNode getFirstNotProcessedRequiredChild(TrieParseContext<?> context) {
        if (this.childs == null || this.childs.size() == 0) {
            return null;
        }
        for (TrieNode child : this.childs) {
            if (child.countOfNotProcessedDataChilds(context, true) <= 0) continue;
            return child;
        }
        return null;
    }

    public TrieNode findLastNodeBeforeFork(TrieParseContext<?> context) {
        TrieNode node = this;
        while (node.parent != null) {
            TrieNode p = context.getParentFor(node);
            if (p == null) {
                p = node.parent[0];
            }
            if (p == null || p.childs.size() > 1) break;
            node = p;
        }
        return node;
    }

    private boolean isInTheMiddleOfModifier(TrieParseContext<?> context) {
        return this.getData() == null && !this.isAggregate();
    }

    public boolean isLeftThen(TrieParseContext<?> context, TrieNode right) {
        TrieNode p;
        TrieNode left = this;
        HashMap<TrieNode, TrieNode> leftParents = new HashMap<TrieNode, TrieNode>();
        while (left != null) {
            left = left.findLastNodeBeforeFork(context);
            if (left.parent != null) {
                p = context.getParentFor(left);
                if (p == null) {
                    p = left.parent[0];
                }
                leftParents.put(p, left);
                left = p;
                continue;
            }
            left = null;
        }
        while (right != null) {
            right = right.findLastNodeBeforeFork(context);
            if (right.parent != null) {
                p = context.getParentFor(right);
                if (p == null) {
                    p = right.parent[0];
                }
                if ((left = (TrieNode)leftParents.get(p)) != null) {
                    return p.childs.indexOf(left) < p.childs.indexOf(right);
                }
                right = p;
                continue;
            }
            right = null;
        }
        return false;
    }

    public void print(StringBuilder builder) {
        this.printUpToNode(builder, null);
    }

    public void printUpToNode(StringBuilder builder, TrieNode node) {
        if (this == node) {
            return;
        }
        if (this.character != '\u0000') {
            builder.append(this.character);
        } else if (this.data instanceof SyntaxParameter) {
            builder.append(new StringBuilder(this.data.getSyntax()).reverse().toString());
        }
        if (this.parent != null) {
            this.parent[0].printUpToNode(builder, node);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.print(builder);
        return builder.reverse().toString();
    }

    private static boolean isSpace(char c) {
        return " \t\n\r".indexOf(c) != -1;
    }

    private static boolean isDelimiter(char c) {
        return TrieNode.isSpace(c) || ",()'\"{}".indexOf(c) >= 0;
    }

    public static interface Visitor {
        public boolean visit(TrieNode var1);
    }

    public static abstract class LeafNodesVisitor
    implements Visitor {
        @Override
        public boolean visit(TrieNode node) {
            return node.hasChilds() || this.onLeafNode(node);
        }

        public abstract boolean onLeafNode(TrieNode var1);
    }
}

