/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.trie;

import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.trie.TrieNode;
import com.streamscape.slex.lang.trie.TrieParseContext;
import com.streamscape.tools.console.autocompletion.CompoundCompleter;
import java.util.List;

public class Trie {
    private TrieNode top = new TrieNode(null, '\u0000');

    public TrieNode add(String s) {
        return this.top.add(s, false);
    }

    public TrieNode add(String s, boolean caseSensitive) {
        return this.top.add(s, caseSensitive);
    }

    public TrieNode getTopNode() {
        return this.top;
    }

    public <T extends SLCallable> DSLCompletion complete(String s, T callable, MFSession session, AbstractDSLOperation<T> operation) {
        TrieParseContext<T> context = new TrieParseContext<T>(s, callable, session, operation);
        TrieNode node = this.top.parse(context);
        if (context.getParameterCompletion() != null) {
            return context.getParameterCompletion();
        }
        if (node == null && context.getPartialParameterCompletion() != null) {
            return context.getPartialParameterCompletion();
        }
        if (node == null) {
            return null;
        }
        if (context.isAtEnd() && node.getData() instanceof SyntaxParameter && ((SyntaxParameter)node.getData()).isCompletionable() && !context.isNodeProcessed(node)) {
            return ((SyntaxParameter)node.getData()).complete("", s, context.getCallable(), context.getSession());
        }
        DSLCompletion completion = new DSLCompletion();
        TrieNode completionNode = node.complete(context, completion);
        if (completion.getCompletion() != null && s.endsWith(" ") && completion.getCompletion().toString().equals(" ")) {
            completion.setCompletion(null);
        }
        if (completionNode != null && context.getProcessedModifiers().size() > 0) {
            boolean needToAddSuggestions = false;
            if (completion.getCompletion() != null) {
                String completePrinted;
                String completeToken = completion.getCompletion().getTokenFromOffset();
                if (completeToken == (completePrinted = completion.getCompletion().getDisplayStringFromOffset()) || completeToken != null && completeToken.equals(completePrinted)) {
                    needToAddSuggestions = true;
                    List<TrieNode> nodes = completionNode.buildNodesUpTo(context, node);
                    if (nodes != null && nodes.size() > 0) {
                        for (TrieNode n : nodes) {
                            if (n.getData() == null) continue;
                            needToAddSuggestions = false;
                            break;
                        }
                    }
                    if (!needToAddSuggestions) {
                        needToAddSuggestions = completionNode.existsNotProcessedRequiredChild(context);
                    }
                }
            } else {
                needToAddSuggestions = true;
            }
            if (needToAddSuggestions) {
                completionNode.buildSuggestions(context, completion);
            }
        }
        if (context.getPartialParameterCompletion() != null) {
            completion = CompoundCompleter.mergeCompletions("", context.getPartialParameterCompletion(), completion);
        }
        if (completion != null) {
            completion.checkAndCompress();
        }
        return completion;
    }
}

