/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.parameter;

import com.streamscape.slex.lang.parameter.EnumParameter;
import java.util.concurrent.TimeUnit;

public class TimeUnitParameter
extends EnumParameter {
    public TimeUnitParameter() {
        super("");
        this.addPossibleValue("sec");
        this.addPossibleValue("min");
        this.addPossibleValue("hr");
        this.addPossibleValue("days");
    }

    public static TimeUnit parseValue(String name) {
        if ("sec".equalsIgnoreCase(name)) {
            return TimeUnit.SECONDS;
        }
        if ("min".equalsIgnoreCase(name)) {
            return TimeUnit.MINUTES;
        }
        if ("hr".equalsIgnoreCase(name)) {
            return TimeUnit.HOURS;
        }
        if ("days".equalsIgnoreCase(name)) {
            return TimeUnit.DAYS;
        }
        throw new IllegalArgumentException("Unknown time unit '" + name + "'.");
    }

    public static String getName(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "nanos";
            }
            case MICROSECONDS: {
                return "micros";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "sec";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "hr";
            }
            case DAYS: {
                return "days";
            }
        }
        return "none";
    }
}

