/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.parameter;

import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.List;

public class TextParameter
extends AbstractParameter<StringParameter> {
    public TextParameter(String token) {
        super(token);
    }

    @Override
    public StatementParameterValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        int startPosition = parser.getPosition();
        String value = parser.getRemainingScript().trim();
        List<String> exclusionValues = this.getExclusionValues();
        int index = -1;
        if (exclusionValues != null && exclusionValues.size() > 0) {
            String lowerCaseValue = value.toLowerCase();
            for (String exclusion : exclusionValues) {
                index = lowerCaseValue.toLowerCase().indexOf(exclusion);
                if (index <= 0) continue;
                break;
            }
        }
        if (index > 0) {
            value = value.substring(0, index).trim();
            parser.next(value.length());
        } else {
            parser.seek(parser.getLength());
        }
        if (value.length() == 0 && this.isRequired()) {
            if (this.isRequired()) {
                throw new DSLParameterValidationException("Expected parameter with syntax '" + this.getSyntax(true) + "', after '" + parser.getProcessedScript() + "'.");
            }
            return null;
        }
        this.validateValue(value, parser, startPosition);
        return statement.addParameter(this.getName(), value);
    }
}

