/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.parameter;

import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementValueList;

public class StringParameter
extends AbstractParameter<StringParameter> {
    public StringParameter(String token) {
        super(token, Character.valueOf('\''), Character.valueOf('\''));
    }

    public StringParameter(String token, Character startDelimiter, Character endDelimiter) {
        super(token, startDelimiter, endDelimiter);
        if (!(startDelimiter != null && endDelimiter != null && (startDelimiter.charValue() == '\'' && endDelimiter.charValue() == '\'' || startDelimiter.charValue() == '\"' && endDelimiter.charValue() == '\"' || startDelimiter.charValue() == '[' && endDelimiter.charValue() == ']'))) {
            throw new RuntimeException("String parameter delimiters should be quotes ' or \" or squared brackets [].");
        }
    }

    @Override
    public StatementParameterValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        int startPosition = parser.getPosition();
        StatementParameterValue parameter = super.parse(statement, parser);
        if (this.startDelimiter == null) {
            if (parameter.getValue().equalsIgnoreCase("null")) {
                parameter.setValue(null);
            } else {
                if (!(parameter.getValue().startsWith("\"") && parameter.getValue().endsWith("\"") || parameter.getValue().startsWith("'") && parameter.getValue().endsWith("'") || parameter.getValue().startsWith("[") && parameter.getValue().endsWith("]"))) {
                    parser.seek(startPosition);
                    throw new DSLParameterValidationException("Invalid string parameter value '" + parameter.getValue() + "', value should be in quotes or in squared brackets", this.getSyntax(true), parser.getProcessedScript());
                }
                parameter.setDelimiters(parameter.getValue().charAt(0), parameter.getValue().charAt(0));
                parameter.setValue(parameter.getValue().substring(1, parameter.getValue().length() - 1));
            }
        }
        return parameter;
    }
}

