/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.parameter;

import com.streamscape.omf.json.utils.MemoryRefStack;
import com.streamscape.slex.lang.DSLDefinitionException;
import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidator;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.SyntaxToken;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementSetValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SetParameter
extends AbstractParameter<SetParameter> {
    private List<AbstractParameter<?>> parameters;
    private Modifier delimiter;
    private boolean ignoreQuotes;

    public SetParameter(String name) {
        super(name);
    }

    public SetParameter(String name, AbstractParameter<?> ... parameters) {
        super(name);
        for (AbstractParameter<?> parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    public SetParameter addParameter(AbstractParameter<?> parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(parameter);
        return this;
    }

    public SetParameter setDelimiter(Modifier delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public static List<String> getValue(StatementValueList statement, String setName, String parameterName) {
        StatementSetValue set = statement.getSet(setName);
        if (set.isPresent()) {
            return IntStream.range(0, set.size()).mapToObj(i -> set.getElement(i).getParameter(parameterName).getValue()).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    protected String onGetSyntax(boolean isFull) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (i > 0) {
                    if (this.delimiter != null) {
                        builder.append(" ").append(this.delimiter.getSyntax(isFull)).append(" ");
                    } else {
                        builder.append(" ");
                    }
                }
                builder.append(this.parameters.get(i).getSyntax(isFull));
            }
        }
        builder.append(",... )");
        return builder.toString();
    }

    @Override
    public StatementParameterValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        String element;
        int startPosition = parser.getPosition();
        String arrayScript = parser.nextTokenIn('(', ')', this.ignoreQuotes, false);
        if (arrayScript == null) {
            parser.seek(startPosition);
            if (this.isRequired()) {
                this.throwEmptyScriptException(parser);
            }
            return null;
        }
        if (arrayScript.length() == 0) {
            this.throwEmptyScriptException(parser);
        }
        StatementSetValue arrayValue = new StatementSetValue(this.getName());
        ScriptParser arrayParser = new ScriptParser(arrayScript + ",");
        while ((element = arrayParser.nextTokenWithEnd(',', this.ignoreQuotes)) != null) {
            ScriptParser elementParser = new ScriptParser(element);
            StatementValueList statementValueList = new StatementValueList("StatementValueList");
            for (int i = 0; i < this.parameters.size(); ++i) {
                try {
                    this.parameters.get(i).parse(statementValueList, elementParser);
                    if (this.delimiter == null || i >= this.parameters.size() - 1) continue;
                    this.delimiter.parse(statementValueList, elementParser);
                    continue;
                }
                catch (DSLParameterValidationException exception) {
                    this.throwSyntaxException("Syntax error in: '" + element + "'. Cause: " + exception.getMessage());
                }
            }
            if (statementValueList.getValuesCount() == 0) {
                throw new DSLParameterValidationException("Error in: '" + element + "', in array (" + arrayScript + ")", this.getSyntax(true), elementParser.getProcessedScript());
            }
            arrayParser.skipSpacesAndComments();
            elementParser.skipSpacesAndComments();
            if (!elementParser.isAtEnd()) {
                this.throwSyntaxException("Unexpected end of element: '" + elementParser.getRemainingScript() + "', in '" + element + "', syntax: '" + this.getSyntax(true) + "'.");
            }
            arrayValue.addElement(statementValueList);
        }
        arrayParser.skipSpacesAndComments();
        if (!arrayParser.isAtEnd()) {
            this.throwSyntaxException("Unexpected end of set: '" + arrayParser.getRemainingScript() + "', in (" + arrayScript + "), syntax: '" + this.getSyntax(true) + "'.");
        }
        return statement.addSet(arrayValue);
    }

    private void throwSyntaxException(String errorMessage) throws DSLParameterValidationException {
        throw new DSLParameterValidationException(errorMessage);
    }

    private void throwEmptyScriptException(ScriptParser parser) throws DSLParameterValidationException {
        this.throwSyntaxException("Expected parameter with syntax '" + this.getSyntax(true) + "', after '" + parser.getProcessedScript() + "'.");
    }

    public void validate(MemoryRefStack<Object> stack) throws DSLDefinitionException {
        HashSet<String> names = new HashSet<String>();
        for (SyntaxToken syntaxToken : this.parameters) {
            DSLSyntaxValidator.addNameOrThrowException(names, syntaxToken);
            if (stack.contains(syntaxToken)) continue;
            stack.push(syntaxToken);
            HashSet<String> names1 = new HashSet<String>();
            DSLSyntaxValidator.validate(names1, stack, syntaxToken);
            stack.pop();
        }
    }

    public SetParameter setIgnoreQuotes(boolean ignoreQuotes) {
        this.ignoreQuotes = ignoreQuotes;
        return this;
    }
}

