/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.parameter;

import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.parameter.ParameterValueValidator;
import java.util.regex.Pattern;

public class RegexpValidator
implements ParameterValueValidator {
    private String regexp;
    private boolean caseSensitive = true;
    private transient Pattern pattern;

    public RegexpValidator(String regexp) {
        this.init(regexp);
    }

    public RegexpValidator(String regexp, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.init(regexp);
    }

    private void init(String regexp) {
        this.regexp = regexp;
        this.initPattern();
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public RegexpValidator setCaseSensitive(boolean caseSensitive) {
        if (this.caseSensitive != caseSensitive) {
            this.caseSensitive = caseSensitive;
            this.initPattern();
        }
        return this;
    }

    @Override
    public void validate(String value) throws DSLParameterValidationException {
        if (this.pattern == null) {
            this.initPattern();
        }
        if (!this.pattern.matcher(value).matches()) {
            throw new DSLParameterValidationException("Illegal parameter value: '" + value + "', regexp: " + this.regexp);
        }
    }

    private void initPattern() {
        this.pattern = Pattern.compile((String)(this.caseSensitive ? this.regexp : "(?i)^" + this.regexp));
    }
}

