/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.parameter;

import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.regex.Pattern;

public class NumericParameter
extends AbstractParameter<NumericParameter> {
    private static Pattern NUMERIC_PATTERN = Pattern.compile("-?\\d+");

    public NumericParameter(String token) {
        super(token);
    }

    protected NumericParameter(String token, Character startDelimiter, Character endDelimiter) {
        super(token, startDelimiter, endDelimiter);
    }

    @Override
    public StatementParameterValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        int startPosition = parser.getPosition();
        StatementParameterValue parameter = super.parse(statement, parser);
        if (parameter != null && parameter.getValue() != null && parameter.getValue().length() > 0 && !NUMERIC_PATTERN.matcher(parameter.getValue()).matches()) {
            parser.seek(startPosition);
            throw new DSLParameterValidationException("Invalid numeric parameter value '" + parameter.getValue() + "'", this.getSyntax(true), parser.getProcessedScript());
        }
        return parameter;
    }
}

