/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.parameter;

import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementValueList;

public class LongParameter
extends AbstractParameter<LongParameter> {
    private long min = Long.MIN_VALUE;
    private long max = Long.MAX_VALUE;

    public LongParameter(String token) {
        super(token);
    }

    protected LongParameter(String token, Character startDelimiter, Character endDelimiter) {
        super(token, startDelimiter, endDelimiter);
    }

    @Override
    public StatementParameterValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        int startPosition = parser.getPosition();
        StatementParameterValue parameter = super.parse(statement, parser);
        if (parameter != null && !parameter.isDataspaceReference()) {
            long value = 0L;
            try {
                value = Long.parseLong(parameter.getValue());
            }
            catch (Exception e) {
                parser.seek(startPosition);
                throw new DSLParameterValidationException("Long parameter value '" + parameter.getValue() + "'", this.getSyntax(true), parser.getProcessedScript());
            }
            if (value < this.min || value > this.max) {
                parser.seek(startPosition);
                throw new DSLParameterValidationException("Long parameter value '" + parameter.getValue() + "' is out of range [" + this.min + ", " + this.max + "]", this.getSyntax(true), parser.getProcessedScript());
            }
        }
        return parameter;
    }

    public LongParameter setRange(long min, long max) {
        this.min = min;
        this.max = max;
        return this;
    }
}

