/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.parameter;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.ScriptCompleter;
import com.streamscape.slex.lang.completion.SuggestionGroup;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import java.io.File;
import java.util.ArrayList;

public class LocalPathCompleter
implements ScriptCompleter<Object> {
    private PathScope pathScope;

    public LocalPathCompleter() {
        this(PathScope.ALL);
    }

    public LocalPathCompleter(PathScope pathScope) {
        this.pathScope = pathScope;
    }

    @Override
    public DSLCompletion complete(String script, String processedScript, Object callable, MFSession session) {
        if (!script.startsWith("'") || script.length() > 1 && script.endsWith("'")) {
            return null;
        }
        return this.completePath(script.substring(1));
    }

    public DSLCompletion completePath(String pathPrefix) {
        DSLCompletion completion;
        String namePrefix = "";
        String basePath = pathPrefix;
        if (!StringUtils.endsWithAny(pathPrefix, "\\", "/")) {
            int pos = StringUtils.lastIndexOfAny(pathPrefix, "\\", "/");
            namePrefix = pathPrefix.substring(pos + 1);
            basePath = pathPrefix.substring(0, pos + 1);
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        if (basePath.length() == 0) {
            for (File f : File.listRoots()) {
                if (!f.getPath().startsWith(namePrefix)) continue;
                suggestions.add(f.getPath());
            }
            if (namePrefix.length() == 0) {
                suggestions.add("." + File.separator);
            }
        }
        if (pathPrefix.equals(".")) {
            suggestions.add("." + File.separator);
        }
        if (basePath.length() > 0) {
            String namePrefixFinal = namePrefix;
            File[] files = new File(basePath).listFiles(file -> (this.pathScope == PathScope.ALL || this.pathScope == PathScope.DIRECTORIES && file.isDirectory() || this.pathScope == PathScope.FILES && !file.isDirectory()) && file.getName().startsWith(namePrefixFinal) && (namePrefixFinal.length() > 0 || !file.getName().startsWith(".")));
            ArrayList<String> fileSuggestions = new ArrayList<String>();
            if (files != null) {
                for (File file2 : files) {
                    if (file2.isDirectory()) {
                        suggestions.add(file2.getName() + File.separator);
                        continue;
                    }
                    fileSuggestions.add(file2.getName());
                }
            }
            suggestions.sort(String::compareTo);
            fileSuggestions.sort(String::compareTo);
            suggestions.addAll(fileSuggestions);
        }
        if ((completion = DSLCompletion.buildPrefixAndCompletion(namePrefix, suggestions)) != null) {
            for (String suggestion : suggestions) {
                completion.addSuggestion(new TokenSuggestion(LocalPathCompleter.formatSuggestion(suggestion), SuggestionGroup.PATH).setOffset(namePrefix));
            }
            completion.checkAndCompress();
            completion.moveSingleSuggestionToCompletion();
        }
        return completion;
    }

    private static String formatSuggestion(String suggestion) {
        return suggestion.endsWith("\\") ? suggestion + "\\" : suggestion;
    }

    public static enum PathScope {
        ALL,
        FILES,
        DIRECTORIES;

    }
}

