/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.parameter;

import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementValueList;

public class JavadocCommentParameter
extends AbstractParameter<JavadocCommentParameter> {
    public JavadocCommentParameter() {
        super("javadoc");
    }

    @Override
    public String getSyntaxName() {
        return "/** Comments and Tags */";
    }

    @Override
    public StatementParameterValue parse(StatementValueList statement, ScriptParser parser) throws DSLParameterValidationException {
        int startPosition = parser.getPosition();
        String block = parser.nextBlockIn("/**", "*/");
        if (block == null) {
            parser.seek(startPosition);
            if (this.isRequired()) {
                throw new DSLParameterValidationException("Invalid java doc parameter value, value should be in quotes /** .. */", this.getSyntax(true), parser.getProcessedScript());
            }
            return null;
        }
        return statement.addParameter(this.getName(), "/**" + block + "*/");
    }
}

