/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.parameter;

import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementValueList;

public class IntegerParameter
extends AbstractParameter<IntegerParameter> {
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;

    public IntegerParameter(String token) {
        super(token);
    }

    protected IntegerParameter(String token, Character startDelimiter, Character endDelimiter) {
        super(token, startDelimiter, endDelimiter);
    }

    @Override
    public StatementParameterValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        int startPosition = parser.getPosition();
        StatementParameterValue parameter = super.parse(statement, parser);
        if (parameter != null && !parameter.isDataspaceReference()) {
            int value;
            try {
                value = Integer.parseInt(parameter.getValue());
            }
            catch (Exception exception) {
                parser.seek(startPosition);
                throw new DSLParameterValidationException("Invalid integer parameter value '" + parameter.getValue() + "'", this.getSyntax(true), parser.getProcessedScript());
            }
            if (value < this.min || value > this.max) {
                parser.seek(startPosition);
                throw new DSLParameterValidationException("Integer parameter value '" + parameter.getValue() + "' is out of range [" + this.min + ", " + this.max + "]", this.getSyntax(true), parser.getProcessedScript());
            }
        }
        return parameter;
    }

    public IntegerParameter setRange(int min, int max) {
        this.min = min;
        this.max = max;
        return this;
    }
}

