/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.parameter;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementValueList;

public class IdentifierParameter
extends AbstractParameter<IdentifierParameter> {
    private boolean asteriskAllowed = false;

    public IdentifierParameter(String token) {
        super(token);
    }

    public IdentifierParameter(String token, Character startDelimiter, Character endDelimiter) {
        super(token, startDelimiter, endDelimiter);
    }

    @Override
    public StatementParameterValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        int startPosition = parser.getPosition();
        StatementParameterValue parameter = super.parse(statement, parser);
        if (parameter != null && parameter.isPresent()) {
            String value = parameter.getValue();
            if (this.getExcludedDelimiters() != null && this.getExcludedDelimiters().length() > 0) {
                for (char c : this.getExcludedDelimiters().toCharArray()) {
                    value = value.replace(c, 'a');
                }
            }
            if (!StringUtils.validateObjectName(value) && !this.isAsterisk(parameter.getValue())) {
                parser.seek(startPosition);
                throw new DSLParameterValidationException("Invalid symbols in value '" + parameter.getValue() + "'", this.getSyntax(true), parser.getProcessedScript());
            }
        }
        return parameter;
    }

    public IdentifierParameter setAsteriskAllowed(boolean asteriskAllowed) {
        this.asteriskAllowed = asteriskAllowed;
        return this;
    }

    public boolean isAsteriskAllowed() {
        return this.asteriskAllowed;
    }

    private boolean isAsterisk(String value) {
        return this.asteriskAllowed && value.equals("*");
    }
}

