/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.parameter;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementValueList;

public class EventIdParameter
extends AbstractParameter<EventIdParameter> {
    private boolean isFilter = false;

    public EventIdParameter(String token) {
        super(token);
    }

    public EventIdParameter(String token, boolean isFilter) {
        super(token);
        this.isFilter = isFilter;
    }

    public boolean isFilter() {
        return this.isFilter;
    }

    @Override
    public StatementParameterValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        int startPosition = parser.getPosition();
        parser.skipSpacesAndComments();
        String next = parser.next(1);
        if (next == null && !this.isRequired()) {
            return null;
        }
        if (next == null || !next.equals("[")) {
            parser.seek(startPosition);
            startPosition = parser.getPosition();
            String value = parser.nextToken();
            parser.seek(startPosition);
            throw new DSLParameterValidationException("Invalid event id value '" + value + "' (should be in [] brackets)", this.getSyntax(true), parser.getProcessedScript());
        }
        StatementParameterValue parameter = super.parse(statement, parser);
        parser.skipSpacesAndComments();
        next = parser.next(1);
        if (next == null || !next.equals("]")) {
            parser.seek(startPosition);
            throw new DSLParameterValidationException("Invalid event id value, '[" + parameter.getValue() + "' (should be in [] brackets)", this.getSyntax(true), parser.getProcessedScript());
        }
        if (!this.isFilter) {
            if (!StringUtils.validateEventId(parameter.getValue())) {
                parser.seek(startPosition);
                throw new DSLParameterValidationException("Invalid event id value, [" + parameter.getValue() + "]", this.getSyntax(true), parser.getProcessedScript());
            }
        } else if (!StringUtils.validateEventFilter(parameter.getValue())) {
            parser.seek(startPosition);
            throw new DSLParameterValidationException("Invalid event filter value, [" + parameter.getValue() + "]", this.getSyntax(true), parser.getProcessedScript());
        }
        parameter.setDelimiters('[', ']');
        return parameter;
    }
}

