/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.parameter;

import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class EnumParameter
extends AbstractParameter<EnumParameter> {
    protected List<String> possibleValues = null;
    protected Class<?> enumClass = null;
    protected boolean caseSensitive = false;
    protected boolean toUpperCase = true;
    protected String defaultValue = null;

    public EnumParameter(String token) {
        this(token, (Class<?>)null, (Character)null, (Character)null);
    }

    public EnumParameter(String token, Character startDelimiter, Character endDelimiter) {
        this(token, null, startDelimiter, endDelimiter);
    }

    public EnumParameter(String token, Class<?> enumClass) {
        this(token, enumClass, (Character)null, (Character)null);
    }

    public EnumParameter(String token, Class<?> enumClass, Enum<?> ... values) {
        super(token, null, null);
        this.enumClass = enumClass;
        this.possibleValues = new ArrayList<String>();
        for (Enum<?> value : values) {
            this.possibleValues.add(value.toString());
        }
        this.setCompletionAdviser(new EnumParameterCompleter());
    }

    public EnumParameter(String token, Class<?> enumClass, Character startDelimiter, Character endDelimiter) {
        super(token, startDelimiter, endDelimiter);
        this.enumClass = enumClass;
        this.possibleValues = new ArrayList<String>();
        if (enumClass != null) {
            for (Object c : enumClass.getEnumConstants()) {
                this.possibleValues.add(c.toString());
            }
        }
        this.setCompletionAdviser(new EnumParameterCompleter());
    }

    public EnumParameter addPossibleValues(String ... values) {
        Collections.addAll(this.possibleValues, values);
        return this;
    }

    public EnumParameter addPossibleValue(String value) {
        this.possibleValues.add(value);
        return this;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public EnumParameter setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    public boolean isToUpperCase() {
        return this.toUpperCase;
    }

    public EnumParameter setToUpperCase(boolean toUpperCase) {
        this.toUpperCase = toUpperCase;
        return this;
    }

    public EnumParameter setInLowerCase() {
        for (int i = 0; i < this.possibleValues.size(); ++i) {
            this.possibleValues.set(i, this.possibleValues.get(i).toLowerCase());
        }
        return this;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public EnumParameter setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    protected String onGetSyntax(boolean isFull) {
        StringBuilder buffer = new StringBuilder();
        if (!this.isRequired()) {
            buffer.append("[");
        }
        buffer.append("{ ");
        for (String possibleValue : this.possibleValues) {
            String value;
            String string = value = this.caseSensitive ? possibleValue : possibleValue.toLowerCase();
            if (this.defaultValue != null && this.equals(possibleValue, this.defaultValue)) {
                buffer.append("<u>").append(value).append("</u>");
            } else {
                buffer.append(value);
            }
            buffer.append(" | ");
        }
        buffer.replace(buffer.length() - 3, buffer.length(), "");
        buffer.append(" }");
        if (!this.isRequired()) {
            buffer.append("]");
        }
        return buffer.toString();
    }

    private boolean equals(String value, String defaultValue) {
        return this.caseSensitive ? value.equals(defaultValue) : value.equalsIgnoreCase(defaultValue);
    }

    @Override
    public StatementParameterValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        int startPosition = parser.getPosition();
        StatementParameterValue parameter = super.parse(statement, parser);
        if (parameter == null) {
            return null;
        }
        if (!parameter.isDataspaceReference()) {
            boolean found = false;
            for (String value : this.possibleValues) {
                found = this.caseSensitive ? value.equals(parameter.getValue()) : value.equalsIgnoreCase(parameter.getValue());
                if (!found) continue;
                if (!this.toUpperCase) break;
                parameter.setValue(parameter.getValue().toUpperCase());
                break;
            }
            if (!found) {
                parser.seek(startPosition);
                throw new DSLParameterValidationException("Invalid Enum parameter value '" + parameter.getValue() + "'", this.getSyntax(true), parser.getProcessedScript());
            }
        }
        return parameter;
    }

    private class EnumParameterCompleter
    implements CompletionAdviser {
        private EnumParameterCompleter() {
        }

        public List<String> getCompletions(String script, String processedScript, Object callable, MFSession session) {
            return EnumParameter.this.possibleValues.stream().map(value -> EnumParameter.this.caseSensitive ? value : value.toLowerCase()).collect(Collectors.toList());
        }

        @Override
        public boolean isCaseSensitive() {
            return EnumParameter.this.caseSensitive;
        }
    }
}

