/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.parameter;

import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementValueList;

public class DoubleParameter
extends AbstractParameter<DoubleParameter> {
    private double min = Double.MIN_VALUE;
    private double max = Double.MAX_VALUE;

    public DoubleParameter(String token) {
        super(token);
    }

    protected DoubleParameter(String token, Character startDelimiter, Character endDelimiter) {
        super(token, startDelimiter, endDelimiter);
    }

    @Override
    public StatementParameterValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        int startPosition = parser.getPosition();
        StatementParameterValue parameter = super.parse(statement, parser);
        if (parameter != null && !parameter.isDataspaceReference()) {
            try {
                double value = Double.parseDouble(parameter.getValue());
                if (value != 0.0 && (Math.abs(value) < this.min || Math.abs(value) > this.max)) {
                    throw new DSLParameterValidationException("Double parameter value '" + parameter.getValue() + "' is out of range [" + this.min + ", " + this.max + "]", this.getSyntax(true), parser.getProcessedScript());
                }
            }
            catch (Exception e) {
                parser.seek(startPosition);
                if (e instanceof DSLParameterValidationException) {
                    throw (DSLParameterValidationException)e;
                }
                throw new DSLParameterValidationException("Invalid double parameter value '" + parameter.getValue() + "'", this.getSyntax(true), parser.getProcessedScript());
            }
        }
        return parameter;
    }

    public DoubleParameter setRange(double min, double max) {
        this.min = min;
        this.max = max;
        return this;
    }
}

