/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.parameter;

import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.parameter.ParameterValueValidator;
import com.streamscape.slex.lang.parameter.StringParameter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateParameter
extends StringParameter {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_DATE_FORMAT_MILLIS = "yyyy-MM-dd HH:mm:ss.SSS";

    public DateParameter(String token) {
        this(token, DEFAULT_DATE_FORMAT);
    }

    public DateParameter(String token, String dateFormat) {
        super(token);
        this.setValueValidator(new DateValidator(this, dateFormat));
    }

    public DateParameter(String token, SimpleDateFormat dateFormat) {
        super(token);
        this.setValueValidator(new DateValidator(this, dateFormat.toPattern()));
    }

    public static Date parseDate(String value, SimpleDateFormat format) throws ParseException {
        return format.parse(value);
    }

    public static Date parseDate(String value, String format) throws ParseException {
        return DateParameter.parseDate(value, new SimpleDateFormat(format));
    }

    public static String formatDate(Date date, SimpleDateFormat format) {
        return format.format(date);
    }

    public static String formatDate(Date date, String format) {
        return DateParameter.formatDate(date, new SimpleDateFormat(format));
    }

    public static String formatDate(Date date) {
        return DateParameter.formatDate(date, DEFAULT_DATE_FORMAT);
    }

    public static String formatDate(long time, String format) {
        return DateParameter.formatDate(new Date(time), format);
    }

    public static String formatDate(long time) {
        return DateParameter.formatDate(time, DEFAULT_DATE_FORMAT);
    }

    public static String formatDateMillis(Date date) {
        return DateParameter.formatDate(date, DEFAULT_DATE_FORMAT_MILLIS);
    }

    public static String formatDateMillis(long time) {
        return DateParameter.formatDate(time, DEFAULT_DATE_FORMAT_MILLIS);
    }

    public class DateValidator
    implements ParameterValueValidator {
        private String dateFormat;

        public DateValidator(DateParameter this$0, String dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void validate(String value) throws DSLParameterValidationException {
            try {
                DateParameter.parseDate(value, this.dateFormat);
            }
            catch (Exception exception) {
                throw new DSLParameterValidationException("Illegal parameter value: '" + value + "', it should be in format '" + this.dateFormat + "'.");
            }
        }
    }
}

