/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.parameter;

import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.parser.statement.Statement;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.utils.RowSetFactoryForDSResult;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sef.dispatcher.AbstractRuntimeServiceMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SLSessionData;
import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementValueList;

public class DataspaceVariableReferenceParameter
extends AbstractParameter<DataspaceVariableReferenceParameter> {
    public DataspaceVariableReferenceParameter(String token) {
        super(token);
        this.setPrefix("@");
    }

    @Override
    public StatementParameterValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        int startPosition = parser.getPosition();
        StatementParameterValue parameter = super.parse(statement, parser);
        if (parameter != null && parameter.isPresent() && !StringUtils.validateObjectName(parameter.getValue())) {
            parser.seek(startPosition);
            throw new DSLParameterValidationException("Invalid symbols in value '" + parameter.getValue() + "'", this.getSyntax(true), parser.getProcessedScript());
        }
        return parameter;
    }

    public static Object getVariableValue(MFSession session, String variableName) throws Exception {
        if (!(session instanceof AbstractRuntimeServiceMFSession)) {
            throw new Exception("Current session doesn't have dataspace session and cannot resolve dataspace reference for variable @" + variableName + ".");
        }
        Session dataspaceSession = ((AbstractRuntimeServiceMFSession)session).getDataspaceSDSSession();
        Result result = null;
        try {
            Statement cs = dataspaceSession.compileStatement("select " + variableName);
            result = cs.execute(dataspaceSession);
            result.setStatement(cs);
        }
        catch (DataspaceException e) {
            result = Result.newErrorResult(e);
        }
        if (result.getException() != null) {
            throw result.getException();
        }
        if (result.isError()) {
            throw new Exception("Failed to get value of dataspace variable @" + variableName + ".");
        }
        if (!result.getNavigator().next()) {
            throw new Exception("No result in sql query.");
        }
        return RowSetFactoryForDSResult.convertValue(dataspaceSession, result.getNavigator().getCurrent()[0], result.metaData.columnTypes[0], true, false, SLSessionData.DataObjectNotation.none);
    }
}

