/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.parameter;

import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.ArrayList;
import java.util.List;

public class CompoundParameter
extends AbstractParameter<CompoundParameter> {
    private List<AbstractParameter<?>> parameters = new ArrayList();
    private char parametersDelimiter = (char)32;
    private boolean reverseOrder = false;
    private int requiredPartsNumber = 0;

    public CompoundParameter() {
        super(CompoundParameter.makeUniqueName("CompoundParameter"));
    }

    public CompoundParameter(char delimiter) {
        this();
        this.setParametersDelimiter(delimiter);
    }

    public CompoundParameter(String name) {
        super(name);
    }

    public CompoundParameter(String name, char delimiter) {
        super(name);
        this.setParametersDelimiter(delimiter);
    }

    public boolean isReverseOrder() {
        return this.reverseOrder;
    }

    public CompoundParameter setReverseOrder(boolean reverseOrder) {
        this.reverseOrder = reverseOrder;
        return this;
    }

    @Override
    public String getSyntaxName() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (i > 0) {
                if (this.parameters.get(i - 1).isRequired()) {
                    builder.append(this.parametersDelimiter);
                } else {
                    builder.insert(builder.length() - 1, this.parametersDelimiter);
                }
            }
            builder.append(this.parameters.get(i).getSyntax());
        }
        return builder.toString();
    }

    public CompoundParameter addParameter(AbstractParameter<?> parameter) {
        if (this.reverseOrder) {
            if (this.parameters.size() > this.requiredPartsNumber && parameter.isRequired()) {
                throw new RuntimeException("Parameter already has optional parts. New part '" + parameter.getName() + "' must be optional.");
            }
        } else if (this.requiredPartsNumber > 0 && !parameter.isRequired()) {
            throw new RuntimeException("Parameter already has required parts. New part '" + parameter.getName() + "' must be required.");
        }
        if (parameter.isRequired()) {
            ++this.requiredPartsNumber;
        }
        this.parameters.add(parameter);
        return this;
    }

    public CompoundParameter addParameters(AbstractParameter<?> ... parameters) {
        for (AbstractParameter<?> parameter : parameters) {
            this.addParameter(parameter);
        }
        return this;
    }

    public CompoundParameter setParametersDelimiter(char delimiter) {
        this.parametersDelimiter = delimiter;
        return this;
    }

    @Override
    public StatementParameterValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        int startPosition = parser.getPosition();
        StatementParameterValue pvalue = super.parse(statement, parser);
        if (pvalue == null) {
            return null;
        }
        String svalue = pvalue.getValue().trim();
        ScriptParser valueParser = new ScriptParser(svalue);
        ArrayList<String> parameterNames = new ArrayList<String>();
        parameterNames.add(pvalue.getName());
        try {
            if (parser.isAtEnd() && parser.endsWith(String.valueOf(this.parametersDelimiter))) {
                throw new DSLParameterValidationException("Parameter cannot ends with '" + this.parametersDelimiter + "'.");
            }
            ArrayList<String> partValues = new ArrayList<String>();
            String partValue = null;
            String delimiter = null;
            while ((partValue = valueParser.nextToken(this.parametersDelimiter)) != null) {
                delimiter = null;
                partValues.add(partValue);
                delimiter = valueParser.next(1);
            }
            if (this.parameters.size() < partValues.size()) {
                throw new DSLParameterValidationException("Parameter has " + this.parameters.size() + " parts, but there are " + partValues.size() + ".");
            }
            if (partValues.size() < this.requiredPartsNumber) {
                throw new DSLParameterValidationException("Parameter has " + this.requiredPartsNumber + " required parts, but there are only " + partValues.size() + ".");
            }
            if (this.reverseOrder) {
                this.parseReverseOrder(statement, partValues, parameterNames);
            } else {
                this.parseDirectOrder(statement, partValues, parameterNames);
            }
        }
        catch (DSLParameterValidationException exception) {
            parser.seek(startPosition);
            if (!this.isRequired()) {
                for (String name : parameterNames) {
                    statement.removeValue(name);
                }
                return null;
            }
            throw new DSLParameterValidationException("Invalid parameter value '" + svalue + "'", this.getSyntax(), parser.getProcessedScript(), exception);
        }
        return pvalue;
    }

    private void parseDirectOrder(StatementValueList statement, List<String> partValues, List<String> parameterNames) throws DSLSyntaxValidationException {
        int startParameterIndex = this.parameters.size() - partValues.size();
        for (int index = 0; index < partValues.size(); ++index) {
            StatementParameterValue value = this.parameters.get(index + startParameterIndex).parse(statement, new ScriptParser(partValues.get(index)));
            this.addValue(value, parameterNames);
        }
    }

    private void parseReverseOrder(StatementValueList statement, List<String> partValues, List<String> parameterNames) throws DSLSyntaxValidationException {
        for (int index = 0; index < partValues.size(); ++index) {
            StatementParameterValue value = this.parameters.get(index).parse(statement, new ScriptParser(partValues.get(index)));
            this.addValue(value, parameterNames);
        }
    }

    private void addValue(StatementParameterValue value, List<String> parameterNames) {
        if (value != null) {
            parameterNames.add(value.getName());
            value.setPrintable(false);
        }
    }
}

