/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.parameter;

import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.PrefixTree;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.ScriptCompleter;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import com.streamscape.slex.lang.modifier.AbstractSyntaxToken;
import com.streamscape.slex.lang.parameter.ParameterValueValidator;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.trie.TrieNode;
import com.streamscape.slex.lang.value.StatementParameterValue;
import com.streamscape.slex.lang.value.StatementValueList;
import com.streamscape.tools.console.autocompletion.PrefixTreeCompleter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public abstract class AbstractParameter<T>
extends AbstractSyntaxToken<T>
implements SyntaxParameter<T> {
    private String syntaxName;
    protected Character startDelimiter = null;
    protected Character endDelimiter = null;
    private String prefix = null;
    private List<String> exclusionValues = null;
    private String excludedDelimiters = null;
    private boolean endDelimiterIsCommandEnd = false;
    private ParameterValueValidator valueValidator;
    private boolean throwOnValidationFailed = true;
    protected boolean skipOneLineComments = false;
    protected boolean ignoreQuotes = true;
    private CompletionAdviser completionAdviser = null;
    private ScriptCompleter completer = null;
    private boolean isAlwaysComplete = false;

    protected AbstractParameter(String syntaxName) {
        this(syntaxName, null, null);
    }

    protected AbstractParameter(String syntaxName, Character startDelimiter, Character endDelimiter) {
        super(syntaxName);
        this.syntaxName = syntaxName;
        this.startDelimiter = startDelimiter;
        this.endDelimiter = endDelimiter;
        this.prefix = null;
        if (startDelimiter != null && endDelimiter == null) {
            throw new RuntimeException("End delimiter should be also set if start delimiter is set.");
        }
        if (startDelimiter != null && (startDelimiter.charValue() == '\u0000' || endDelimiter.charValue() == '\u0000')) {
            throw new RuntimeException("Start/end delimiter cannot be set to '\\0'.");
        }
    }

    @Override
    public String getSyntaxName() {
        return "&lt;" + this.syntaxName + "&gt;";
    }

    @Override
    protected String onGetSyntax(boolean isFull) {
        StringBuilder builder = new StringBuilder();
        if (!this.isRequired()) {
            builder.append("[");
        }
        if (this.prefix != null) {
            builder.append(this.prefix);
        }
        if (this.startDelimiter != null) {
            builder.append(this.startDelimiter);
        }
        builder.append(this.getSyntaxName());
        if (this.endDelimiter != null) {
            builder.append(this.endDelimiter);
        }
        if (!this.isRequired()) {
            builder.append("]");
        }
        return builder.toString();
    }

    @Override
    public T setEndDelimiterToCommandEnd() {
        this.endDelimiterIsCommandEnd = true;
        return (T)this;
    }

    @Override
    public boolean isEndDelimiterToCommandEnd() {
        return this.endDelimiterIsCommandEnd;
    }

    @Override
    public Character getStartDelimiter() {
        return this.startDelimiter;
    }

    @Override
    public Character getEndDelimiter() {
        return this.endDelimiter;
    }

    @Override
    public T setPrefix(String prefix) {
        this.prefix = prefix;
        return (T)this;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public T setValueValidator(ParameterValueValidator valueValidator) {
        return this.setValueValidator(valueValidator, true);
    }

    @Override
    public T setValueValidator(ParameterValueValidator valueValidator, boolean throwOnValidationFailed) {
        this.valueValidator = valueValidator;
        this.throwOnValidationFailed = throwOnValidationFailed;
        return (T)this;
    }

    @Override
    public ParameterValueValidator getValueValidator() {
        return this.valueValidator;
    }

    public T addExclusionValue(String value) {
        if (this.exclusionValues == null) {
            this.exclusionValues = new ArrayList<String>();
        }
        this.exclusionValues.add(value.toLowerCase());
        return (T)this;
    }

    public T addExclusionValues(String ... values) {
        if (this.exclusionValues == null) {
            this.exclusionValues = new ArrayList<String>();
        }
        for (String value : values) {
            this.exclusionValues.add(value.toLowerCase());
        }
        return (T)this;
    }

    public String getExcludedDelimiters() {
        return this.excludedDelimiters;
    }

    public List<String> getExclusionValues() {
        return this.exclusionValues;
    }

    public T setExcludedDelimiters(String excludedDelimiters) {
        this.excludedDelimiters = excludedDelimiters;
        return (T)this;
    }

    @Override
    public StatementParameterValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        String value;
        String ss;
        int startPosition = parser.getPosition();
        if (!(this.prefix == null || this.prefix.length() <= 0 || (ss = parser.next(this.prefix.length())) != null && ss.equalsIgnoreCase(this.prefix))) {
            parser.seek(startPosition);
            if (this.isRequired()) {
                throw new DSLParameterValidationException("Expected parameter prefix '" + this.prefix + "' instead of '" + ss + "'", this.getSyntax(true), parser.getProcessedScript());
            }
            return null;
        }
        StatementParameterValue parameterValue = this.readDataspaceVariableReference(statement, parser);
        if (parameterValue != null) {
            return parameterValue;
        }
        if (this.startDelimiter == null) {
            if (this.endDelimiterIsCommandEnd) {
                value = parser.getRemainingScript();
                if (value != null) {
                    value = value.trim();
                }
                parser.seek(parser.getLength());
            } else {
                value = parser.nextTokenExcludeDelimiters(this.excludedDelimiters);
            }
            if (value != null && this.exclusionValues != null && (this.prefix == null || this.prefix.length() == 0) && this.exclusionValues.contains(value.toLowerCase())) {
                value = null;
                parser.seek(startPosition);
            }
        } else {
            value = parser.nextTokenIn(this.startDelimiter.charValue(), this.endDelimiter.charValue(), this.ignoreQuotes, this.skipOneLineComments);
            if (value == null && this instanceof StringParameter && ((value = parser.nextTokenExcludeDelimiters(this.excludedDelimiters)) == null || !value.equalsIgnoreCase("null"))) {
                parser.seek(startPosition);
                value = null;
            }
        }
        if (value == null) {
            parser.seek(startPosition);
            if (this.isRequired()) {
                throw new DSLParameterValidationException("Expected parameter with syntax " + this.getSyntax() + ", after '" + parser.getProcessedScript() + "'.");
            }
            return null;
        }
        this.validateValue(value, parser, startPosition);
        parameterValue = statement.addParameter(this.getName(), value);
        if (this.startDelimiter != null) {
            parameterValue.setDelimiters(this.startDelimiter.charValue(), this.endDelimiter.charValue());
        }
        if (this.prefix != null) {
            parameterValue.setPrefix(this.prefix);
        }
        return parameterValue;
    }

    protected StatementParameterValue readDataspaceVariableReference(StatementValueList statement, ScriptParser parser) throws DSLParameterValidationException {
        if (this.prefix != null && this.prefix.length() > 0) {
            return null;
        }
        int startPosition = parser.getPosition();
        if (!"@".equals(parser.next(1))) {
            parser.seek(startPosition);
            return null;
        }
        String remainingScript = parser.getRemainingScript();
        if (remainingScript.length() > 0 && Character.isWhitespace(remainingScript.charAt(0))) {
            parser.seek(startPosition);
            return null;
        }
        String value = parser.nextTokenExcludeDelimiters(this.excludedDelimiters);
        if (value == null || value.length() == 0) {
            throw new DSLParameterValidationException("Expected dataspace variable reference after prefix @, after '" + parser.getProcessedScript() + "'.");
        }
        StatementParameterValue parameterValue = statement.addParameter(this.getName(), value);
        parameterValue.setDataspaceReference(true);
        parameterValue.setParameterClass(this.getClass());
        return parameterValue;
    }

    protected void validateValue(String value, ScriptParser parser, int startPosition) throws DSLSyntaxValidationException {
        if (this.valueValidator != null) {
            try {
                this.valueValidator.validate(value);
            }
            catch (DSLParameterValidationException exception) {
                parser.seek(startPosition);
                if (this.throwOnValidationFailed) {
                    throw new DSLParameterValidationException("Validation failed for parameter with syntax '" + this.getSyntax() + "'.\nCause: " + exception.getMessage());
                }
                throw new DSLSyntaxValidationException("Validation failed for parameter with syntax '" + this.getSyntax() + "'.\nCause: " + exception.getMessage());
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    protected static String makeUniqueName(String name) {
        return name + "_" + UUID.randomUUID().toString();
    }

    @Override
    public TrieNode buildTrie(TrieNode node) {
        TrieNode parameterNode = node.createChild('\u0000');
        parameterNode.setData(this);
        parameterNode = parameterNode.add(" ");
        if (!this.isRequired()) {
            parameterNode.setBackwardLink(node);
        }
        return parameterNode;
    }

    @Override
    public T setCompletionAdviser(CompletionAdviser<?> completionAdviser) {
        this.completionAdviser = completionAdviser;
        return (T)this;
    }

    @Override
    public T setCompleter(ScriptCompleter<?> completer) {
        this.completer = completer;
        return (T)this;
    }

    @Override
    public boolean isCompletionable() {
        return this.completionAdviser != null || this.completer != null;
    }

    public T setAlwaysComplete(boolean isAlwaysComplete) {
        this.isAlwaysComplete = isAlwaysComplete;
        return (T)this;
    }

    @Override
    public boolean isAlwaysComplete() {
        return this.isAlwaysComplete;
    }

    @Override
    public DSLCompletion complete(String script, String processedScript, Object callable, MFSession session) {
        if (this.completer != null) {
            return this.completer.complete(script, processedScript, callable, session);
        }
        if (this.completionAdviser == null) {
            return null;
        }
        List<String> completions = this.completionAdviser.getCompletions(script, processedScript, callable, session);
        if (completions == null || completions.size() == 0) {
            return null;
        }
        if (script == null || script.length() == 0) {
            DSLCompletion completion = new DSLCompletion();
            for (String c : completions) {
                completion.addSuggestion(new TokenSuggestion(c));
            }
            return completion;
        }
        PrefixTree<Object> prefixTree = new PrefixTree<Object>(this.completionAdviser.isCaseSensitive());
        Object object = new Object();
        for (String c : completions) {
            prefixTree.add(c, object);
        }
        PrefixTreeCompleter completer = new PrefixTreeCompleter(prefixTree);
        return completer.completeDsl(script);
    }
}

