/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.modifier;

import com.streamscape.omf.json.utils.MemoryRefStack;
import com.streamscape.slex.lang.DSLDefinitionException;
import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidator;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.SyntaxToken;
import com.streamscape.slex.lang.trie.TrieNode;
import com.streamscape.slex.lang.value.StatementSetValue;
import com.streamscape.slex.lang.value.StatementValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class SetModifier
extends AbstractModifier<SetModifier> {
    private List<AbstractModifier<?>> modifiers = new ArrayList();

    public SetModifier(String name) {
        super("", name);
    }

    public SetModifier(String name, AbstractModifier<?> ... modifiers) {
        super("", name);
        for (AbstractModifier<?> modifier : modifiers) {
            this.addModifier(modifier);
        }
    }

    public SetModifier addModifier(AbstractModifier<?> modifier) {
        if (this.modifiers == null) {
            this.modifiers = new ArrayList();
        }
        this.modifiers.add(modifier);
        return this;
    }

    @Override
    protected String onGetSyntax(boolean isFull) {
        StringBuilder builder = new StringBuilder();
        if (!this.isRequired()) {
            builder.append("[");
        }
        builder.append("(");
        if (this.modifiers != null) {
            for (int i = 0; i < this.modifiers.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.modifiers.get(i).getSyntax(isFull));
            }
        }
        builder.append(")");
        if (!this.isRequired()) {
            builder.append("]");
        }
        return builder.toString();
    }

    @Override
    public StatementValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        int startPosition = parser.getPosition();
        String setScript = parser.nextTokenIn('(', ')');
        if (setScript == null) {
            parser.seek(startPosition);
            if (this.isRequired()) {
                throw new DSLParameterValidationException("Expected set modifier with syntax '" + this.getSyntax(true) + "', after '" + parser.getBlock(0, startPosition) + "'.");
            }
            return null;
        }
        if (setScript.length() == 0) {
            parser.seek(startPosition);
            throw new DSLParameterValidationException("Expected set modifier with syntax '" + this.getSyntax(true) + "', after '" + parser.getBlock(0, startPosition) + "'.");
        }
        StatementSetValue valueSet = new StatementSetValue(this.getName());
        ScriptParser setParser = new ScriptParser(setScript + ",");
        for (AbstractModifier<?> modifier : this.modifiers) {
            ScriptParser modifierParser;
            String modifierScript;
            block11: {
                StatementValueList valueList = new StatementValueList(modifier.getName());
                int startPositionSetParser = setParser.getPosition();
                modifierScript = setParser.nextTokenWithEnd(',');
                if (modifierScript == null) {
                    if (!modifier.isRequired()) continue;
                    parser.seek(startPosition);
                    throw new DSLSyntaxValidationException("Expected modifier with syntax '" + modifier.getSyntax(true) + "', after '" + parser.getBlock(0, startPosition) + "'.");
                }
                modifierParser = new ScriptParser(modifierScript);
                try {
                    modifier.parse(valueList, modifierParser);
                    if (valueList.size() > 0) {
                        valueSet.addElement(valueList);
                        break block11;
                    }
                    setParser.seek(startPositionSetParser);
                    continue;
                }
                catch (DSLParameterValidationException exception) {
                    parser.seek(startPosition);
                    throw new DSLParameterValidationException("Syntax error in modifier set '(" + setScript + ")' in modifier '" + modifierScript + "', cause: " + exception.getMessage());
                }
                catch (DSLSyntaxValidationException exception) {
                    if (!modifier.isRequired()) {
                        setParser.seek(startPositionSetParser);
                        continue;
                    }
                    parser.seek(startPosition);
                    throw new DSLSyntaxValidationException("Syntax error in modifier set '(" + setScript + ")' in modifier '" + modifierScript + "', cause: " + exception.getMessage());
                }
            }
            if (modifierParser.getRemainingScript().trim().length() <= 0) continue;
            parser.seek(startPosition);
            throw new DSLSyntaxValidationException("Syntax error in modifier set '(" + setScript + ")' in modifier '" + modifierScript + "', unexpected symbols at the end: '" + modifierParser.getRemainingScript() + "'.");
        }
        if (!setParser.isAtEnd()) {
            parser.seek(startPosition);
            throw new DSLParameterValidationException("Unexpected end of set: '" + setParser.getRemainingScript() + "', in modifier set (" + setScript + "), set syntax: '" + this.getSyntax(true) + "'.");
        }
        return statement.addSet(valueSet);
    }

    public void validate(MemoryRefStack<Object> stack) throws DSLDefinitionException {
        HashSet<String> names = new HashSet<String>();
        for (SyntaxToken syntaxToken : this.modifiers) {
            DSLSyntaxValidator.addNameOrThrowException(names, syntaxToken);
            if (stack.contains(syntaxToken)) continue;
            stack.push(syntaxToken);
            HashSet<String> names1 = new HashSet<String>();
            DSLSyntaxValidator.validate(names1, stack, syntaxToken);
            stack.pop();
        }
    }

    @Override
    public TrieNode buildTrie(TrieNode node) {
        node = super.buildTrie(node);
        TrieNode superModifierBackwardLink = node.getBackwardLink();
        node.setBackwardLink(null);
        node = node.add("(");
        node.setData(this);
        for (int i = 0; i < this.modifiers.size(); ++i) {
            AbstractModifier<?> modifier = this.modifiers.get(i);
            node = modifier.buildTrie(node);
            if (i >= this.modifiers.size() - 1) continue;
            TrieNode comma = node.add(",");
            comma.setBackwardLink(node.getBackwardLink());
            node.setBackwardLink(null);
            node = comma;
        }
        node = node.add(")");
        node.setData(this);
        node.setBackwardLink(superModifierBackwardLink);
        return node;
    }
}

