/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.modifier;

import com.streamscape.slex.lang.DSLParameterValidationException;
import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.AbstractModifierList;
import com.streamscape.slex.lang.trie.TrieNode;
import com.streamscape.slex.lang.value.StatementValue;
import com.streamscape.slex.lang.value.StatementValueList;

public class RepeatableModifier
extends AbstractModifierList<RepeatableModifier> {
    public RepeatableModifier() {
        super(RepeatableModifier.makeUniqueName("RepeatableModifier"));
    }

    public RepeatableModifier(String name) {
        super(name);
    }

    @Override
    protected String onGetSyntax(boolean isFull) {
        StringBuilder builder = new StringBuilder();
        if (!this.isRequired()) {
            builder.append("[");
        }
        for (AbstractModifier modifier : this.modifiers) {
            builder.append(modifier.getSyntax(isFull));
        }
        builder.append(",...");
        if (!this.isRequired()) {
            builder.append("]");
        }
        return builder.toString();
    }

    @Override
    public StatementValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        try {
            for (AbstractModifier modifier : this.modifiers) {
                modifier.parse(statement, parser);
            }
        }
        catch (DSLParameterValidationException exception) {
            throw exception;
        }
        catch (DSLSyntaxValidationException exception) {
            statement.clear();
            throw exception;
        }
        parser.skipSpacesAndComments();
        if (!parser.isAtEnd()) {
            throw new DSLSyntaxValidationException("Unexpected end of line: '" + parser.getRemainingScript() + "', possible missing ','.");
        }
        return statement;
    }

    @Override
    public TrieNode buildTrie(TrieNode node) {
        TrieNode startNode = node;
        for (AbstractModifier modifier : this.modifiers) {
            node = modifier.buildTrie(node);
        }
        startNode.accept(new TrieNode.Visitor(this){

            @Override
            public boolean visit(TrieNode child) {
                if (child.getData() != null) {
                    child.setRepeatable(true);
                }
                return true;
            }
        }, null);
        TrieNode lastNode = node;
        while (lastNode != startNode && lastNode != null) {
            if (lastNode.getData() != null) {
                lastNode.setRepeatable(true);
            }
            lastNode = lastNode.getParent() != null ? lastNode.getParent()[0] : null;
        }
        return node;
    }
}

