/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.slex.lang.modifier;

import com.streamscape.slex.lang.DSLSyntaxValidationException;
import com.streamscape.slex.lang.ScriptParser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.slex.lang.trie.TrieNode;
import com.streamscape.slex.lang.value.StatementValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.ArrayList;
import java.util.List;

public abstract class ModifierWithParameters<T>
extends AbstractModifier<T> {
    protected List<SyntaxParameter<?>> parameters = null;

    public ModifierWithParameters(String token) {
        super(token);
    }

    public ModifierWithParameters(String token, String name) {
        super(token, name);
    }

    public ModifierWithParameters(String token, String name, boolean required) {
        super(token, name, required);
    }

    public SyntaxParameter<?> getParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        for (SyntaxParameter<?> parameter : this.parameters) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public List<SyntaxParameter<?>> getParameters() {
        return this.parameters;
    }

    public T addParameter(SyntaxParameter<?> parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(parameter);
        return (T)this;
    }

    public boolean hasParameter(String name) {
        if (this.parameters == null) {
            return false;
        }
        for (SyntaxParameter<?> parameter : this.parameters) {
            if (!parameter.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String onGetSyntax(boolean isFull) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.onGetSyntax(isFull));
        if (this.parameters != null) {
            StringBuilder pbuilder = new StringBuilder();
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (i > 0) {
                    pbuilder.append(" ");
                }
                pbuilder.append(this.parameters.get(i).getSyntax(isFull));
            }
            if (!this.isRequired()) {
                if (buffer.length() > 0 && !this.isNoSpacesAfter()) {
                    buffer.insert(buffer.length() - 1, " ");
                }
                buffer.insert(buffer.length() - 1, pbuilder);
            } else {
                if (buffer.length() > 0 && !this.isNoSpacesAfter()) {
                    buffer.append(" ");
                }
                buffer.append((CharSequence)pbuilder);
            }
        }
        return buffer.toString();
    }

    @Override
    public StatementValue parse(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        StatementValue value = super.parse(statement, parser);
        if (value.isPresent() && this.parameters != null) {
            for (SyntaxParameter<?> parameter : this.parameters) {
                parameter.parse(statement, parser);
            }
        }
        return value;
    }

    public StatementValue parseWithoutParameters(StatementValueList statement, ScriptParser parser) throws DSLSyntaxValidationException {
        return super.parse(statement, parser);
    }

    @Override
    public TrieNode buildTrie(TrieNode node) {
        TrieNode modifierNode = super.buildTrie(node);
        if (this.parameters != null) {
            TrieNode parentNode = modifierNode;
            TrieNode lastRequiredParameterNode = null;
            for (int i = 0; i < this.parameters.size(); ++i) {
                SyntaxParameter<?> parameter = this.parameters.get(i);
                TrieNode parameterNode = parentNode.createChild('\u0000');
                parameterNode.setData(parameter);
                parameterNode = parameterNode.add(" ");
                if (parameter.isRequired()) {
                    parentNode = parameterNode;
                    lastRequiredParameterNode = parameterNode;
                    continue;
                }
                parameterNode.setBackwardLink(parentNode);
            }
            if (lastRequiredParameterNode != null) {
                lastRequiredParameterNode.setBackwardLink(modifierNode.getBackwardLink());
                modifierNode = lastRequiredParameterNode;
            }
        }
        if (modifierNode.getBackwardLink() != null) {
            modifierNode = modifierNode.getBackwardLink();
        }
        return modifierNode;
    }
}

